/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.stateful;

import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.ejb3.stateful.StatefulBeanContext;
import org.jboss.ejb3.stateful.StatefulContainer;
import org.jboss.ejb3.stateful.StatefulContainerInvocation;
import org.jboss.ejb3.tx.TxUtil;
import org.jboss.logging.Logger;
import org.jboss.tm.TxUtils;

public class StatefulRemoveInterceptor
implements Interceptor {
    private static final Logger log = Logger.getLogger(StatefulRemoveInterceptor.class);
    protected boolean retainIfException;

    public StatefulRemoveInterceptor(boolean removeOnException) {
        this.retainIfException = removeOnException;
    }

    public String getName() {
        return this.getClass().getName();
    }

    public Object invoke(Invocation invocation) throws Throwable {
        Object rtn = null;
        try {
            rtn = invocation.invokeNext();
        }
        catch (Throwable t) {
            if (!this.retainIfException) {
                this.removeSession(invocation);
            }
            throw t;
        }
        this.removeSession(invocation);
        return rtn;
    }

    protected void removeSession(Invocation invocation) {
        StatefulContainerInvocation ejb = (StatefulContainerInvocation)invocation;
        Object id = ejb.getId();
        StatefulContainer container = (StatefulContainer)ejb.getAdvisor();
        Transaction tx = null;
        try {
            tx = TxUtil.getTransactionManager().getTransaction();
        }
        catch (SystemException e) {
            throw new RuntimeException(e);
        }
        if (tx != null && TxUtils.isActive(tx)) {
            try {
                tx.registerSynchronization(new RemoveSynchronization(container, id));
            }
            catch (RollbackException e) {
                throw new RuntimeException(e);
            }
            catch (SystemException e) {
                throw new RuntimeException(e);
            }
        } else {
            StatefulBeanContext ctx = container.getCache().get(id);
            container.getCache().remove(id);
        }
    }

    private static class RemoveSynchronization
    implements Synchronization {
        private StatefulContainer container;
        private Object id;

        public RemoveSynchronization(StatefulContainer container, Object id) {
            this.container = container;
            this.id = id;
        }

        public void beforeCompletion() {
        }

        public void afterCompletion(int status) {
            this.container.getCache().remove(this.id);
        }
    }
}

