/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.mdb;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.ejb.ActivationConfigProperty;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import org.jboss.annotation.ejb.Consumer;
import org.jboss.annotation.ejb.DefaultActivationSpecs;
import org.jboss.annotation.ejb.Local;
import org.jboss.annotation.ejb.MessageProperties;
import org.jboss.annotation.ejb.MessagePropertiesImpl;
import org.jboss.annotation.ejb.Producer;
import org.jboss.annotation.ejb.Producers;
import org.jboss.aop.AspectManager;
import org.jboss.aop.MethodInfo;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.InvocationResponse;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.aop.util.PayloadKey;
import org.jboss.ejb3.Container;
import org.jboss.ejb3.EJBContainerInvocation;
import org.jboss.ejb3.Ejb3Deployment;
import org.jboss.ejb3.ThreadLocalENCFactory;
import org.jboss.ejb3.interceptor.InterceptorInfoRepository;
import org.jboss.ejb3.mdb.LocalProducerFactory;
import org.jboss.ejb3.mdb.MessagingContainer;
import org.jboss.ejb3.mdb.ProducerFactory;
import org.jboss.ejb3.mdb.RemoteProducerFactory;
import org.jboss.logging.Logger;

public class ConsumerContainer
extends MessagingContainer {
    private static final Logger log = Logger.getLogger(ConsumerContainer.class);
    protected Class messagingType = null;
    protected Method ON_MESSAGE;
    protected ArrayList<ProducerFactory> producers = new ArrayList();
    protected static final String DEFAULT_DESTINATION_TYPE = "javax.jms.Topic";
    public static final String CONSUMER_MESSAGE = "CONSUMER_MESSAGE";

    public ConsumerContainer(String ejbName, AspectManager manager, ClassLoader cl, String beanClassName, Hashtable ctxProperties, InterceptorInfoRepository interceptorRepository, Ejb3Deployment deployment) {
        super(ejbName, manager, cl, beanClassName, ctxProperties, interceptorRepository, deployment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InvocationResponse dynamicInvoke(Invocation invocation) throws Throwable {
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        EJBContainerInvocation newSi = null;
        ThreadLocalENCFactory.push(this.enc);
        try {
            Thread.currentThread().setContextClassLoader(this.classloader);
            MethodInvocation si = (MethodInvocation)invocation;
            MethodInfo info = (MethodInfo)this.methodInterceptors.get(si.getMethodHash());
            if (info == null) {
                throw new RuntimeException("Could not resolve beanClass method from proxy call");
            }
            Interceptor[] aspects = info.getInterceptors();
            newSi = new EJBContainerInvocation(info, aspects);
            newSi.setArguments(si.getArguments());
            newSi.setMetaData(si.getMetaData());
            newSi.setAdvisor(this);
            InvocationResponse response = new InvocationResponse(newSi.invokeNext());
            response.setContextInfo(newSi.getResponseContextInfo());
            InvocationResponse invocationResponse = response;
            return invocationResponse;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldLoader);
            ThreadLocalENCFactory.pop();
        }
    }

    protected Method getOnMessage() {
        if (this.ON_MESSAGE != null) {
            return this.ON_MESSAGE;
        }
        try {
            Class<Message> arg = Message.class;
            this.ON_MESSAGE = MessageListener.class.getMethod("onMessage", arg);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ExceptionInInitializerError(e);
        }
        return this.ON_MESSAGE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object localInvoke(MethodInfo info, Object[] args) throws Throwable {
        if (info.getAdvisedMethod().equals(this.getOnMessage())) {
            ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
            ThreadLocalENCFactory.push(this.enc);
            try {
                Message message = (Message)args[0];
                MethodInvocation invocation = (MethodInvocation)((ObjectMessage)message).getObject();
                invocation.getMetaData().addMetaData(CONSUMER_MESSAGE, CONSUMER_MESSAGE, message, PayloadKey.TRANSIENT);
                InvocationResponse invocationResponse = this.dynamicInvoke(invocation);
                return invocationResponse;
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldLoader);
                ThreadLocalENCFactory.pop();
            }
        }
        return super.localInvoke(info, args);
    }

    public Class getMessagingType() {
        return MessageListener.class;
    }

    public MethodInfo getMethodInfo(Method method) {
        MethodInfo info = new MethodInfo();
        info.setAdvisor(this);
        info.setAdvisedMethod(method);
        info.setUnadvisedMethod(method);
        return info;
    }

    public Map getActivationConfigProperties() {
        HashMap result = new HashMap();
        Consumer annotation = (Consumer)this.resolveAnnotation(Consumer.class);
        for (ActivationConfigProperty property : annotation.activationConfig()) {
            this.addActivationSpecProperty(result, property);
        }
        DefaultActivationSpecs defaultSpecsAnnotation = (DefaultActivationSpecs)this.resolveAnnotation(DefaultActivationSpecs.class);
        if (defaultSpecsAnnotation != null) {
            for (ActivationConfigProperty property : defaultSpecsAnnotation.value()) {
                this.addActivationSpecProperty(result, property);
            }
        }
        return result;
    }

    public void start() throws Exception {
        super.start();
        this.registerProducers();
    }

    public Class[] getProducerInterfaces(Container container1) {
        Producers producersAnnotation;
        Class producer;
        Class beanClass = container1.getBeanClass();
        Class[] interfaces = beanClass.getInterfaces();
        if (interfaces.length == 0) {
            throw new RuntimeException("Bean class must implement at least one interface: " + beanClass.getName());
        }
        if (interfaces.length == 1) {
            return interfaces;
        }
        ArrayList<Class> localInterfaces = new ArrayList<Class>();
        for (int i = 0; i < interfaces.length; ++i) {
            if (!interfaces[i].isAnnotationPresent(Producer.class)) continue;
            localInterfaces.add(interfaces[i]);
        }
        Producer annotation = (Producer)this.resolveAnnotation(Producer.class);
        if (annotation != null && (producer = annotation.producer()) != null) {
            localInterfaces.add(producer);
        }
        if ((producersAnnotation = (Producers)this.resolveAnnotation(Producers.class)) != null) {
            for (Producer producerAnnotation : producersAnnotation.value()) {
                Class producer2 = producerAnnotation.producer();
                if (producer2 == null) continue;
                localInterfaces.add(producer2);
            }
        }
        if (localInterfaces.size() == 0) {
            return null;
        }
        interfaces = localInterfaces.toArray(new Class[localInterfaces.size()]);
        return interfaces;
    }

    protected void registerProducers() throws Exception {
        Destination dest = (Destination)this.getInitialContext().lookup(this.getDestination());
        Class[] producers = this.getProducerInterfaces(this);
        MessageProperties props = (MessageProperties)this.resolveAnnotation(MessageProperties.class);
        if (props == null) {
            props = new MessagePropertiesImpl();
        }
        for (Class producer : producers) {
            log.debug("Producer: " + producer.getName());
            ProducerFactory producerFactory = null;
            producerFactory = producer.isAnnotationPresent(Local.class) ? new LocalProducerFactory(this, producer, props, dest, this.getInitialContext(), this.initialContextProperties) : new RemoteProducerFactory(this, producer, props, dest, this.getInitialContext(), this.initialContextProperties);
            this.producers.add(producerFactory);
            producerFactory.start();
        }
    }

    protected void unregisterProducers() throws Exception {
        for (ProducerFactory factory : this.producers) {
            factory.stop();
        }
    }

    protected void populateActivationSpec() {
        DefaultActivationSpecs defaultSpecs = (DefaultActivationSpecs)this.resolveAnnotation(DefaultActivationSpecs.class);
        if (defaultSpecs != null) {
            this.activationSpec.merge(defaultSpecs.value());
        }
        Consumer md = (Consumer)this.resolveAnnotation(Consumer.class);
        this.activationSpec.merge(md.activationConfig());
    }

    public void stop() throws Exception {
        super.stop();
        this.unregisterProducers();
    }
}

