/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.entity;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.sql.Connection;
import javax.persistence.EntityManager;
import org.hibernate.CacheMode;
import org.hibernate.Criteria;
import org.hibernate.EntityMode;
import org.hibernate.Filter;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.Query;
import org.hibernate.ReplicationMode;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.ejb.HibernateEntityManager;
import org.hibernate.stat.SessionStatistics;
import org.jboss.ejb3.PersistenceUnitRegistry;
import org.jboss.ejb3.entity.ManagedEntityManagerFactory;
import org.jboss.ejb3.entity.PersistenceUnitDeployment;

public class TransactionScopedHibernateSession
implements Session,
Externalizable {
    private transient ManagedEntityManagerFactory factory;

    protected Session getHibernateSession() {
        if (this.getSession() instanceof HibernateEntityManager) {
            return ((HibernateEntityManager)this.getSession()).getSession();
        }
        throw new RuntimeException("ILLEGAL ACTION:  Not a Hibernate persistence provider");
    }

    protected EntityManager getSession() {
        return this.factory.getTransactionScopedEntityManager();
    }

    public TransactionScopedHibernateSession(ManagedEntityManagerFactory factory) {
        if (factory == null) {
            throw new NullPointerException("factory must not be null");
        }
        this.factory = factory;
    }

    public TransactionScopedHibernateSession() {
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.factory.getKernelName());
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        String kernelName = in.readUTF();
        PersistenceUnitDeployment deployment = PersistenceUnitRegistry.getPersistenceUnit(kernelName);
        if (deployment == null) {
            throw new IOException("Unable to find persistence unit in registry: " + kernelName);
        }
        this.factory = deployment.getManagedFactory();
    }

    public EntityMode getEntityMode() {
        return this.getHibernateSession().getEntityMode();
    }

    public Session getSession(EntityMode entityMode) {
        return this.getHibernateSession().getSession(entityMode);
    }

    public void flush() throws HibernateException {
        this.getHibernateSession().flush();
    }

    public void setFlushMode(FlushMode flushMode) {
        this.getHibernateSession().setFlushMode(flushMode);
    }

    public FlushMode getFlushMode() {
        return this.getHibernateSession().getFlushMode();
    }

    public void setCacheMode(CacheMode cacheMode) {
        this.getHibernateSession().setCacheMode(cacheMode);
    }

    public CacheMode getCacheMode() {
        return this.getHibernateSession().getCacheMode();
    }

    public SessionFactory getSessionFactory() {
        return this.getHibernateSession().getSessionFactory();
    }

    public Connection connection() throws HibernateException {
        return this.getHibernateSession().connection();
    }

    public Connection disconnect() throws HibernateException {
        return this.getHibernateSession().disconnect();
    }

    public void reconnect() throws HibernateException {
        this.getHibernateSession().reconnect();
    }

    public void reconnect(Connection connection) throws HibernateException {
        this.getHibernateSession().reconnect(connection);
    }

    public Connection close() throws HibernateException {
        throw new IllegalStateException("Illegal to call this method from injected, managed EntityManager");
    }

    public void cancelQuery() throws HibernateException {
        this.getHibernateSession().cancelQuery();
    }

    public boolean isOpen() {
        return this.getHibernateSession().isOpen();
    }

    public boolean isConnected() {
        return this.getHibernateSession().isConnected();
    }

    public boolean isDirty() throws HibernateException {
        return this.getHibernateSession().isDirty();
    }

    public Serializable getIdentifier(Object object) throws HibernateException {
        return this.getHibernateSession().getIdentifier(object);
    }

    public boolean contains(Object object) {
        return this.getHibernateSession().contains(object);
    }

    public void evict(Object object) throws HibernateException {
        this.getHibernateSession().evict(object);
    }

    public Object load(Class theClass, Serializable id, LockMode lockMode) throws HibernateException {
        return this.getHibernateSession().load(theClass, id, lockMode);
    }

    public Object load(String entityName, Serializable id, LockMode lockMode) throws HibernateException {
        return this.getHibernateSession().load(entityName, id, lockMode);
    }

    public Object load(Class theClass, Serializable id) throws HibernateException {
        return this.getHibernateSession().load(theClass, id);
    }

    public Object load(String entityName, Serializable id) throws HibernateException {
        return this.getHibernateSession().load(entityName, id);
    }

    public void load(Object object, Serializable id) throws HibernateException {
        this.getHibernateSession().load(object, id);
    }

    public void replicate(Object object, ReplicationMode replicationMode) throws HibernateException {
        this.getHibernateSession().replicate(object, replicationMode);
    }

    public void replicate(String entityName, Object object, ReplicationMode replicationMode) throws HibernateException {
        this.getHibernateSession().replicate(entityName, object, replicationMode);
    }

    public Serializable save(Object object) throws HibernateException {
        return this.getHibernateSession().save(object);
    }

    public Serializable save(String entityName, Object object) throws HibernateException {
        return this.getHibernateSession().save(entityName, object);
    }

    public void saveOrUpdate(Object object) throws HibernateException {
        this.getHibernateSession().saveOrUpdate(object);
    }

    public void saveOrUpdate(String entityName, Object object) throws HibernateException {
        this.getHibernateSession().saveOrUpdate(entityName, object);
    }

    public void update(Object object) throws HibernateException {
        this.getHibernateSession().update(object);
    }

    public void update(String entityName, Object object) throws HibernateException {
        this.getHibernateSession().update(entityName, object);
    }

    public Object merge(Object object) throws HibernateException {
        return this.getHibernateSession().merge(object);
    }

    public Object merge(String entityName, Object object) throws HibernateException {
        return this.getHibernateSession().merge(entityName, object);
    }

    public void persist(Object object) throws HibernateException {
        this.getHibernateSession().persist(object);
    }

    public void persist(String entityName, Object object) throws HibernateException {
        this.getHibernateSession().persist(entityName, object);
    }

    public void delete(Object object) throws HibernateException {
        this.getHibernateSession().delete(object);
    }

    public void delete(String entityName, Object object) throws HibernateException {
        this.getHibernateSession().delete(entityName, object);
    }

    public void lock(Object object, LockMode lockMode) throws HibernateException {
        this.getHibernateSession().lock(object, lockMode);
    }

    public void lock(String entityName, Object object, LockMode lockMode) throws HibernateException {
        this.getHibernateSession().lock(entityName, object, lockMode);
    }

    public void refresh(Object object) throws HibernateException {
        this.getHibernateSession().refresh(object);
    }

    public void refresh(Object object, LockMode lockMode) throws HibernateException {
        this.getHibernateSession().refresh(object, lockMode);
    }

    public LockMode getCurrentLockMode(Object object) throws HibernateException {
        return this.getHibernateSession().getCurrentLockMode(object);
    }

    public Transaction beginTransaction() throws HibernateException {
        return this.getHibernateSession().beginTransaction();
    }

    public Criteria createCriteria(Class persistentClass) {
        return this.getHibernateSession().createCriteria(persistentClass);
    }

    public Criteria createCriteria(Class persistentClass, String alias) {
        return this.getHibernateSession().createCriteria(persistentClass, alias);
    }

    public Criteria createCriteria(String entityName) {
        return this.getHibernateSession().createCriteria(entityName);
    }

    public Criteria createCriteria(String entityName, String alias) {
        return this.getHibernateSession().createCriteria(entityName, alias);
    }

    public Query createQuery(String queryString) throws HibernateException {
        return this.getHibernateSession().createQuery(queryString);
    }

    public SQLQuery createSQLQuery(String queryString) throws HibernateException {
        return this.getHibernateSession().createSQLQuery(queryString);
    }

    public Query createFilter(Object collection, String queryString) throws HibernateException {
        return this.getHibernateSession().createFilter(collection, queryString);
    }

    public Query getNamedQuery(String queryName) throws HibernateException {
        return this.getHibernateSession().getNamedQuery(queryName);
    }

    public void clear() {
        this.getHibernateSession().clear();
    }

    public Object get(Class clazz, Serializable id) throws HibernateException {
        return this.getHibernateSession().get(clazz, id);
    }

    public Object get(Class clazz, Serializable id, LockMode lockMode) throws HibernateException {
        return this.getHibernateSession().get(clazz, id, lockMode);
    }

    public Object get(String entityName, Serializable id) throws HibernateException {
        return this.getHibernateSession().get(entityName, id);
    }

    public Object get(String entityName, Serializable id, LockMode lockMode) throws HibernateException {
        return this.getHibernateSession().get(entityName, id, lockMode);
    }

    public String getEntityName(Object object) throws HibernateException {
        return this.getHibernateSession().getEntityName(object);
    }

    public Filter enableFilter(String filterName) {
        return this.getHibernateSession().enableFilter(filterName);
    }

    public Filter getEnabledFilter(String filterName) {
        return this.getHibernateSession().getEnabledFilter(filterName);
    }

    public void disableFilter(String filterName) {
        this.getHibernateSession().disableFilter(filterName);
    }

    public SessionStatistics getStatistics() {
        return this.getHibernateSession().getStatistics();
    }

    public void setReadOnly(Object entity, boolean readOnly) {
        this.getHibernateSession().setReadOnly(entity, readOnly);
    }

    public Transaction getTransaction() {
        return this.getHibernateSession().getTransaction();
    }
}

