/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.cache;

import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.ejb3.cache.ClusteredStatefulCache;
import org.jboss.ejb3.cache.Optimized;
import org.jboss.ejb3.stateful.StatefulBeanContext;
import org.jboss.ejb3.stateful.StatefulContainer;
import org.jboss.ejb3.stateful.StatefulContainerInvocation;

public class StatefulReplicationInterceptor
implements Interceptor {
    public String getName() {
        return this.getClass().getName();
    }

    public Object invoke(Invocation invocation) throws Throwable {
        Object rtn = invocation.invokeNext();
        Object obj = invocation.getTargetObject();
        if (obj instanceof Optimized && !((Optimized)obj).isModified()) {
            return rtn;
        }
        StatefulContainerInvocation ejb = (StatefulContainerInvocation)invocation;
        StatefulBeanContext ctx = (StatefulBeanContext)ejb.getBeanContext();
        StatefulContainer container = (StatefulContainer)ejb.getAdvisor();
        if (container.getCache() instanceof ClusteredStatefulCache) {
            ClusteredStatefulCache cache = (ClusteredStatefulCache)container.getCache();
            cache.replicate(ctx);
        }
        return rtn;
    }
}

