/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3;

import java.io.DataInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javassist.bytecode.ClassFile;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.persistence.Entity;
import javax.security.jacc.PolicyConfiguration;
import javax.security.jacc.PolicyConfigurationFactory;
import org.hibernate.cfg.EJB3DTDEntityResolver;
import org.hibernate.ejb.packaging.PersistenceMetadata;
import org.hibernate.ejb.packaging.PersistenceXmlLoader;
import org.jboss.ejb3.Container;
import org.jboss.ejb3.DependencyPolicy;
import org.jboss.ejb3.DeploymentUnit;
import org.jboss.ejb3.EAR;
import org.jboss.ejb3.EJB3Util;
import org.jboss.ejb3.EJBContainer;
import org.jboss.ejb3.Ejb3Handler;
import org.jboss.ejb3.Ejb3HandlerFactory;
import org.jboss.ejb3.Ejb3Registry;
import org.jboss.ejb3.KernelAbstraction;
import org.jboss.ejb3.PersistenceUnitRegistry;
import org.jboss.ejb3.enc.EjbModuleEjbResolver;
import org.jboss.ejb3.enc.EjbModulePersistenceUnitResolver;
import org.jboss.ejb3.entity.PersistenceUnitDeployment;
import org.jboss.logging.Logger;
import org.jboss.util.file.ArchiveBrowser;
import org.jboss.util.file.ClassFileFilter;
import org.xml.sax.EntityResolver;

public abstract class Ejb3Deployment {
    private static final Logger log = Logger.getLogger(Ejb3Deployment.class);
    public static final String ACTUAL_ENTITY_MANAGER_FACTORY_CONTEXT = "java:/ActualEntityManagerFactories";
    public static final String MANAGED_ENTITY_FACTORY_CONTEXT = "java:/managedEntityFactories";
    protected DeploymentUnit di;
    protected LinkedHashMap ejbContainers = new LinkedHashMap();
    protected boolean hasEntities;
    protected List<String> explicitEntityClasses = new ArrayList<String>();
    protected List<PersistenceUnitDeployment> persistenceUnitDeployments = new ArrayList<PersistenceUnitDeployment>();
    protected String defaultSLSBDomain = "Stateless Bean";
    protected String defaultSFSBDomain = "Stateful Bean";
    protected String defaultMDBDomain = "Message Driven Bean";
    protected String defaultConsumerDomain = "Consumer Bean";
    protected String defaultServiceDomain = "Service Bean";
    protected InitialContext initialContext;
    protected KernelAbstraction kernelAbstraction;
    protected MBeanServer mbeanServer;
    protected EAR ear;
    protected EjbModuleEjbResolver ejbRefResolver;
    protected EjbModulePersistenceUnitResolver persistenceUnitResolver;
    PolicyConfiguration pc;

    public Ejb3Deployment(DeploymentUnit di, EAR ear) {
        this.di = di;
        this.ear = ear;
        try {
            this.initialContext = EJB3Util.getInitialContext(di.getJndiProperties());
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
        this.ejbRefResolver = new EjbModuleEjbResolver(ear, di.getShortName(), this.ejbContainers, this);
        this.persistenceUnitResolver = new EjbModulePersistenceUnitResolver(this.persistenceUnitDeployments, ear, this.ejbContainers);
    }

    public EAR getEar() {
        return this.ear;
    }

    public KernelAbstraction getKernelAbstraction() {
        return this.kernelAbstraction;
    }

    public MBeanServer getMbeanServer() {
        return this.mbeanServer;
    }

    public void setMbeanServer(MBeanServer mbeanServer) {
        this.mbeanServer = mbeanServer;
    }

    public DeploymentUnit getDeploymentUnit() {
        return this.di;
    }

    public String getDefaultSLSBDomain() {
        return this.defaultSLSBDomain;
    }

    public String getScopeKernelName() {
        String scopedKernelName = "";
        if (this.ear != null) {
            scopedKernelName = scopedKernelName + ",ear=" + this.ear.getShortName();
        }
        scopedKernelName = scopedKernelName + ",jar=" + this.di.getShortName();
        return scopedKernelName;
    }

    public void setDefaultSLSBDomain(String defaultSLSBDomain) {
        this.defaultSLSBDomain = defaultSLSBDomain;
    }

    public String getDefaultSFSBDomain() {
        return this.defaultSFSBDomain;
    }

    public String getDefaultConsumerDomain() {
        return this.defaultConsumerDomain;
    }

    public void setDefaultSFSBDomain(String defaultSFSBDomain) {
        this.defaultSFSBDomain = defaultSFSBDomain;
    }

    public String getDefaultMDBDomain() {
        return this.defaultMDBDomain;
    }

    public void setDefaultMDBDomain(String defaultMDBDomain) {
        this.defaultMDBDomain = defaultMDBDomain;
    }

    public String getDefaultServiceDomain() {
        return this.defaultServiceDomain;
    }

    public void setDefaultServiceDomain(String defaultServiceDomain) {
        this.defaultServiceDomain = defaultServiceDomain;
    }

    protected String getJaccContextId() {
        return this.di.getShortName();
    }

    public Container getContainer(ObjectName name) {
        return (Container)this.ejbContainers.get(name);
    }

    public Map getEjbContainers() {
        return this.ejbContainers;
    }

    public PersistenceUnitDeployment getPersistenceUnitDeployment(String unitName) throws NameNotFoundException {
        return this.persistenceUnitResolver.getPersistenceUnitDeployment(unitName);
    }

    public PersistenceUnitDeployment getPersistenceUnitDeploymentInternal(String unitName) {
        return this.persistenceUnitResolver.getPersistenceUnitDeploymentInternal(unitName);
    }

    public EJBContainer getEjbContainer(String ejbLink, Class businessIntf) {
        return this.ejbRefResolver.getEjbContainer(ejbLink, businessIntf);
    }

    public String getEjbJndiName(String ejbLink, Class businessIntf) {
        return this.ejbRefResolver.getEjbJndiName(ejbLink, businessIntf);
    }

    public EJBContainer getEjbContainer(Ejb3Deployment deployment, Class businessIntf) throws NameNotFoundException {
        return this.ejbRefResolver.getEjbContainer(deployment, businessIntf);
    }

    public EJBContainer getEjbContainer(Class businessIntf) throws NameNotFoundException {
        return this.ejbRefResolver.getEjbContainer(businessIntf);
    }

    public String getEjbJndiName(Class businessIntf) throws NameNotFoundException {
        return this.ejbRefResolver.getEjbJndiName(businessIntf);
    }

    protected void processEJBContainerMetadata(Container container) throws Exception {
        ObjectName on = container.getObjectName();
        this.ejbContainers.put(on, container);
        DependencyPolicy policy = this.createDependencyPolicy();
        container.processMetadata(policy);
    }

    protected void registerEJBContainer(Container container) throws Exception {
        ObjectName on = container.getObjectName();
        this.kernelAbstraction.install(on.getCanonicalName(), container.getDependencyPolicy(), container);
        log.debug("Bound ejb3 container " + on);
    }

    protected abstract PolicyConfiguration createPolicyConfiguration() throws Exception;

    protected abstract void putJaccInService(PolicyConfiguration var1, DeploymentUnit var2);

    public void create() throws Exception {
        long start = System.currentTimeMillis();
        this.pc = this.createPolicyConfiguration();
        this.deploy();
        this.initializePersistenceUnits();
        log.info("EJB3 deployment time took: " + (System.currentTimeMillis() - start));
    }

    public void start() throws Exception {
        try {
            Container con;
            this.startPersistenceUnits();
            for (Object o : this.ejbContainers.values()) {
                con = (Container)o;
                this.processEJBContainerMetadata(con);
            }
            for (Object o : this.ejbContainers.values()) {
                con = (Container)o;
                this.registerEJBContainer(con);
            }
            this.putJaccInService(this.pc, this.di);
        }
        catch (Exception ex) {
            try {
                this.stop();
                this.destroy();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw ex;
        }
    }

    protected void deploy() throws Exception {
        Ejb3HandlerFactory factory = Ejb3HandlerFactory.getInstance(this);
        if (this.di.getUrl() != null) {
            this.deployUrl(factory);
        }
        if (this.di.getClasses() != null) {
            for (Class explicit : this.di.getClasses()) {
                if (explicit.isAnnotationPresent(Entity.class)) continue;
                String name = explicit.getName().replace('.', '/') + ".class";
                InputStream stream = explicit.getClassLoader().getResourceAsStream(name);
                this.deployElement(stream, factory, this.initialContext);
            }
        }
    }

    protected void deployUrl(Ejb3HandlerFactory factory) throws Exception {
        Iterator it = ArchiveBrowser.getBrowser(this.di.getUrl(), new ClassFileFilter());
        InitialContext ctx = this.initialContext;
        while (it.hasNext()) {
            InputStream stream = (InputStream)it.next();
            this.deployElement(stream, factory, ctx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deployElement(InputStream stream, Ejb3HandlerFactory factory, InitialContext ctx) throws Exception {
        DataInputStream dstream = new DataInputStream(stream);
        ClassFile cf = null;
        try {
            cf = new ClassFile(dstream);
        }
        finally {
            dstream.close();
            stream.close();
        }
        this.deployElement(factory, cf, ctx);
    }

    protected void deployElement(Ejb3HandlerFactory factory, ClassFile cf, InitialContext ctx) throws Exception {
        Ejb3Handler handler = factory.createHandler(cf);
        handler.setCtxProperties(this.di.getJndiProperties());
        if (handler.isEjb() || handler.isJBossBeanType()) {
            List<Container> containers = handler.getContainers(cf, this);
            for (Container con : containers) {
                ((EJBContainer)con).instantiated();
                this.ejbContainers.put(con.getObjectName(), con);
                Ejb3Registry.register(con);
            }
        }
    }

    protected void initializePersistenceUnits() throws Exception {
        URL persistenceXmlUrl = null;
        persistenceXmlUrl = this.di.getPersistenceXml();
        boolean bl = this.hasEntities = persistenceXmlUrl != null;
        if (!this.hasEntities) {
            return;
        }
        if (this.di.getClasses() != null) {
            for (Class explicit : this.di.getClasses()) {
                if (!explicit.isAnnotationPresent(Entity.class)) continue;
                this.explicitEntityClasses.add(explicit.getName());
            }
        }
        List persistenceMetadata = PersistenceXmlLoader.deploy((URL)persistenceXmlUrl, new HashMap(), (EntityResolver)new EJB3DTDEntityResolver());
        for (PersistenceMetadata metadata : persistenceMetadata) {
            String earShortName = this.ear == null ? null : this.ear.getShortName();
            boolean isScoped = this.ejbContainers.size() > 0;
            PersistenceUnitDeployment deployment = new PersistenceUnitDeployment(this.initialContext, this, this.explicitEntityClasses, persistenceXmlUrl, metadata, earShortName, this.di.getShortName(), isScoped);
            PersistenceUnitRegistry.register(deployment);
            this.persistenceUnitDeployments.add(deployment);
        }
    }

    public abstract DependencyPolicy createDependencyPolicy();

    protected void startPersistenceUnits() {
        if (this.persistenceUnitDeployments == null) {
            return;
        }
        for (PersistenceUnitDeployment entityDeployment : this.persistenceUnitDeployments) {
            if (entityDeployment == null) continue;
            DependencyPolicy policy = this.createDependencyPolicy();
            entityDeployment.addDependencies(policy);
            this.kernelAbstraction.install(entityDeployment.getKernelName(), policy, entityDeployment);
        }
    }

    protected void stopPersistenceUnits() {
        if (this.persistenceUnitDeployments == null) {
            return;
        }
        for (PersistenceUnitDeployment entityDeployment : this.persistenceUnitDeployments) {
            try {
                PersistenceUnitRegistry.unregister(entityDeployment);
                if (entityDeployment == null) continue;
                this.kernelAbstraction.uninstall(entityDeployment.getKernelName());
            }
            catch (Exception e) {
                log.debug("error trying to shut down persistence unit", e);
            }
        }
    }

    public void stop() throws Exception {
        for (Object o : this.ejbContainers.keySet()) {
            try {
                ObjectName on = (ObjectName)o;
                this.kernelAbstraction.uninstall(on.getCanonicalName());
                Container container = (Container)this.ejbContainers.get(on);
                Ejb3Registry.unregister(container);
                container.stop();
            }
            catch (Exception e) {
                log.debug("error trying to shut down ejb container", e);
            }
        }
        this.stopPersistenceUnits();
    }

    public void destroy() throws Exception {
        PolicyConfigurationFactory pcFactory = PolicyConfigurationFactory.getPolicyConfigurationFactory();
        PolicyConfiguration pc = pcFactory.getPolicyConfiguration(this.getJaccContextId(), true);
        pc.delete();
    }
}

