/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins.inflow;

import EDU.oswego.cs.dl.util.concurrent.SynchronizedInt;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import javax.ejb.EJBMetaData;
import javax.management.ObjectName;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.UnavailableException;
import javax.resource.spi.endpoint.MessageEndpoint;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.transaction.xa.XAResource;
import org.jboss.deployment.DeploymentException;
import org.jboss.ejb.Container;
import org.jboss.ejb.EJBProxyFactory;
import org.jboss.ejb.MessageDrivenContainer;
import org.jboss.ejb.plugins.inflow.GetTCLAction;
import org.jboss.ejb.plugins.inflow.JBossMessageEndpointFactoryMBean;
import org.jboss.invocation.Invocation;
import org.jboss.invocation.InvocationType;
import org.jboss.invocation.InvokerInterceptor;
import org.jboss.metadata.ActivationConfigPropertyMetaData;
import org.jboss.metadata.InvokerProxyBindingMetaData;
import org.jboss.metadata.MessageDestinationMetaData;
import org.jboss.metadata.MessageDrivenMetaData;
import org.jboss.metadata.MetaData;
import org.jboss.mx.util.JMXExceptionDecoder;
import org.jboss.proxy.GenericProxyFactory;
import org.jboss.system.ServiceMBeanSupport;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JBossMessageEndpointFactory
extends ServiceMBeanSupport
implements EJBProxyFactory,
MessageEndpointFactory,
JBossMessageEndpointFactoryMBean {
    protected boolean trace;
    protected MessageDrivenContainer container;
    protected MessageDrivenMetaData metaData;
    protected String invokerBinding;
    protected InvokerProxyBindingMetaData invokerMetaData;
    protected HashMap properties;
    protected GenericProxyFactory proxyFactory;
    protected Class messagingTypeClass;
    protected String resourceAdapterName;
    protected ObjectName resourceAdapterObjectName;
    protected ActivationSpec activationSpec;
    protected ArrayList interceptors;
    protected Class[] interfaces;
    protected SynchronizedInt nextProxyId;
    protected String[] createActivationSpecSig;
    protected String[] activationSig;

    public JBossMessageEndpointFactory() {
        this.trace = this.log.isTraceEnabled();
        this.properties = new HashMap();
        this.proxyFactory = new GenericProxyFactory();
        this.nextProxyId = new SynchronizedInt(0);
        this.createActivationSpecSig = new String[]{Class.class.getName(), Collection.class.getName()};
        this.activationSig = new String[]{MessageEndpointFactory.class.getName(), ActivationSpec.class.getName()};
    }

    public MessageDrivenContainer getContainer() {
        return this.container;
    }

    public String getConfig() {
        return this.toString();
    }

    public MessageEndpoint createEndpoint(XAResource resource) throws UnavailableException {
        this.trace = this.log.isTraceEnabled();
        if (this.getState() != 3 && this.getState() != 2) {
            throw new UnavailableException("The container is not started");
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("MessageEndpoint.Factory", this);
        context.put("MessageEndpoint.XAResource", resource);
        String ejbName = this.container.getBeanMetaData().getContainerObjectNameJndiName();
        if (this.trace) {
            this.log.trace("createEndpoint " + this + " xaResource=" + resource);
        }
        MessageEndpoint endpoint = (MessageEndpoint)this.proxyFactory.createProxy(ejbName + "@" + this.nextProxyId.increment(), this.container.getServiceName(), InvokerInterceptor.getLocal(), null, null, this.interceptors, this.container.getClassLoader(), this.interfaces, context);
        if (this.trace) {
            this.log.trace("Created endpoint " + endpoint + " from " + this);
        }
        return endpoint;
    }

    public boolean isDeliveryTransacted(Method method) throws NoSuchMethodException {
        boolean result = false;
        byte transType = this.metaData.getMethodTransactionType(method.getName(), method.getParameterTypes(), InvocationType.LOCAL);
        if (transType == 1) {
            result = true;
        }
        if (this.trace) {
            this.log.trace("isDeliveryTransacted " + this.container.getBeanMetaData().getContainerObjectNameJndiName() + " method=" + method + " result=" + result);
        }
        return result;
    }

    protected void startService() throws Exception {
        this.metaData = (MessageDrivenMetaData)this.container.getBeanMetaData();
        this.resolveMessageListener();
        this.resolveResourceAdapter();
        this.createActivationSpec();
        this.setupProxyParameters();
        this.activate();
    }

    protected void stopService() throws Exception {
        this.deactivate();
    }

    public boolean isIdentical(Container container, Invocation mi) {
        throw new Error("Not valid for MessageDriven beans");
    }

    public Object getEJBHome() {
        throw new Error("Not valid for MessageDriven beans");
    }

    public EJBMetaData getEJBMetaData() {
        throw new Error("Not valid for MessageDriven beans");
    }

    public Collection getEntityCollection(Collection c) {
        throw new Error("Not valid for MessageDriven beans");
    }

    public Object getEntityEJBObject(Object id) {
        throw new Error("Not valid for MessageDriven beans");
    }

    public Object getStatefulSessionEJBObject(Object id) {
        throw new Error("Not valid for MessageDriven beans");
    }

    public Object getStatelessSessionEJBObject() {
        throw new Error("Not valid for MessageDriven beans");
    }

    public void setInvokerBinding(String binding) {
        this.invokerBinding = binding;
    }

    public void setInvokerMetaData(InvokerProxyBindingMetaData imd) {
        this.invokerMetaData = imd;
    }

    public void setContainer(Container container) {
        this.container = (MessageDrivenContainer)container;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(100);
        buffer.append(super.toString());
        buffer.append("{ resourceAdapter=").append(this.resourceAdapterObjectName);
        buffer.append(", messagingType=").append(this.messagingTypeClass.getName());
        buffer.append(", ejbName=").append(this.container.getBeanMetaData().getContainerObjectNameJndiName());
        buffer.append(", activationConfig=").append(this.properties.values());
        buffer.append(", activationSpec=").append(this.activationSpec);
        buffer.append("}");
        return buffer.toString();
    }

    protected void resolveMessageListener() throws DeploymentException {
        String messagingType = this.metaData.getMessagingType();
        try {
            this.messagingTypeClass = GetTCLAction.getContextClassLoader().loadClass(messagingType);
        }
        catch (Exception e) {
            DeploymentException.rethrowAsDeploymentException("Could not load messaging-type class " + messagingType, e);
        }
    }

    protected String resolveResourceAdapterName() throws DeploymentException {
        return this.metaData.getResourceAdapterName();
    }

    protected void resolveResourceAdapter() throws DeploymentException {
        this.resourceAdapterName = this.resolveResourceAdapterName();
        try {
            this.resourceAdapterObjectName = new ObjectName("jboss.jca:service=RARDeployment,name='" + this.resourceAdapterName + "'");
            int state = (Integer)this.server.getAttribute(this.resourceAdapterObjectName, "State");
            if (state != 3) {
                throw new DeploymentException("The resource adapter is not started " + this.resourceAdapterName);
            }
        }
        catch (Exception e) {
            DeploymentException.rethrowAsDeploymentException("Cannot locate resource adapter deployment " + this.resourceAdapterName, e);
        }
    }

    protected void setupProxyParameters() throws DeploymentException {
        this.interfaces = new Class[]{MessageEndpoint.class, this.messagingTypeClass};
        this.interceptors = new ArrayList();
        Element proxyConfig = this.invokerMetaData.getProxyFactoryConfig();
        Element endpointInterceptors = MetaData.getOptionalChild(proxyConfig, "endpoint-interceptors", null);
        if (endpointInterceptors == null) {
            throw new DeploymentException("No endpoint interceptors found");
        }
        NodeList children = endpointInterceptors.getElementsByTagName("interceptor");
        for (int i = 0; i < children.getLength(); ++i) {
            Node currentChild = children.item(i);
            if (currentChild.getNodeType() != 1) continue;
            Element interceptor = (Element)children.item(i);
            String className = MetaData.getElementContent(interceptor);
            try {
                Class<?> clazz = this.container.getClassLoader().loadClass(className);
                this.interceptors.add(clazz);
                continue;
            }
            catch (Throwable t) {
                DeploymentException.rethrowAsDeploymentException("Error loading interceptor class " + className, t);
            }
        }
    }

    protected void augmentActivationConfigProperties() throws DeploymentException {
        String link;
        Element proxyConfig = this.invokerMetaData.getProxyFactoryConfig();
        Element activationConfig = MetaData.getOptionalChild(proxyConfig, "activation-config");
        if (activationConfig != null) {
            Iterator iterator = MetaData.getChildrenByTagName(activationConfig, "activation-config-property");
            while (iterator.hasNext()) {
                Element resourceRef = (Element)iterator.next();
                ActivationConfigPropertyMetaData metaData = new ActivationConfigPropertyMetaData();
                metaData.importXml(resourceRef);
                if (this.properties.containsKey(metaData.getName())) continue;
                this.properties.put(metaData.getName(), metaData);
            }
        }
        if ((link = this.metaData.getDestinationLink()) != null && (link = link.trim()).length() > 0) {
            if (this.properties.containsKey("destination")) {
                this.log.warn("Ignoring message-destination-link '" + link + "' when the destination " + "is already in the activation-config.");
            } else {
                MessageDestinationMetaData destinationMetaData = this.container.getMessageDestination(link);
                if (destinationMetaData == null) {
                    throw new DeploymentException("Unresolved message-destination-link '" + link + "' no message-destination in ejb-jar.xml");
                }
                String jndiName = destinationMetaData.getJNDIName();
                if (jndiName == null) {
                    throw new DeploymentException("The message-destination '" + link + "' has no jndi-name in jboss.xml");
                }
                this.properties.put("destination", jndiName);
            }
        }
    }

    protected void createActivationSpec() throws DeploymentException {
        this.properties = new HashMap(this.metaData.getActivationConfigProperties());
        this.augmentActivationConfigProperties();
        Object[] params = new Object[]{this.messagingTypeClass, this.properties.values()};
        try {
            this.activationSpec = (ActivationSpec)this.server.invoke(this.resourceAdapterObjectName, "createActivationSpec", params, this.createActivationSpecSig);
        }
        catch (Throwable t) {
            t = JMXExceptionDecoder.decode(t);
            DeploymentException.rethrowAsDeploymentException("Unable to create activation spec ra=" + this.resourceAdapterObjectName + " messaging-type=" + this.messagingTypeClass.getName() + " properties=" + this.metaData.getActivationConfigProperties(), t);
        }
    }

    protected void activate() throws DeploymentException {
        Object[] params = new Object[]{this, this.activationSpec};
        try {
            this.server.invoke(this.resourceAdapterObjectName, "endpointActivation", params, this.activationSig);
        }
        catch (Throwable t) {
            t = JMXExceptionDecoder.decode(t);
            DeploymentException.rethrowAsDeploymentException("Endpoint activation failed ra=" + this.resourceAdapterObjectName + " activationSpec=" + this.activationSpec, t);
        }
    }

    protected void deactivate() {
        Object[] params = new Object[]{this, this.activationSpec};
        try {
            this.server.invoke(this.resourceAdapterObjectName, "endpointDeactivation", params, this.activationSig);
        }
        catch (Throwable t) {
            t = JMXExceptionDecoder.decode(t);
            this.log.warn("Endpoint activation failed ra=" + this.resourceAdapterObjectName + " activationSpec=" + this.activationSpec, t);
        }
    }
}

