/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins;

import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;
import org.jboss.deployment.DeploymentException;
import org.jboss.ejb.EnterpriseContext;
import org.jboss.ejb.plugins.AbstractInstanceCache;
import org.jboss.logging.Logger;
import org.jboss.metadata.MetaData;
import org.jboss.metadata.XmlLoadable;
import org.jboss.monitor.Monitorable;
import org.jboss.monitor.client.BeanCacheSnapshot;
import org.jboss.util.LRUCachePolicy;
import org.w3c.dom.Element;

public class LRUEnterpriseContextCachePolicy
extends LRUCachePolicy
implements XmlLoadable,
Monitorable {
    protected static Logger log = Logger.getLogger(LRUEnterpriseContextCachePolicy.class);
    protected static Timer tasksTimer = new Timer(true);
    private AbstractInstanceCache m_cache;
    private long m_resizerPeriod;
    private long m_overagerPeriod;
    private long m_maxBeanAge;
    private long m_minPeriod;
    private long m_maxPeriod;
    private double m_factor;
    private TimerTask m_overager;
    private TimerTask m_resizer;
    private StringBuffer m_buffer = new StringBuffer();

    public LRUEnterpriseContextCachePolicy(AbstractInstanceCache eic) {
        if (eic == null) {
            throw new IllegalArgumentException("Instance cache argument cannot be null");
        }
        this.m_cache = eic;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sample(Object s) {
        if (this.m_cache == null) {
            return;
        }
        BeanCacheSnapshot snapshot = (BeanCacheSnapshot)s;
        LRUCachePolicy.LRUList list = this.getList();
        Object object = this.m_cache.getCacheLock();
        synchronized (object) {
            snapshot.m_cacheMinCapacity = list.m_minCapacity;
            snapshot.m_cacheMaxCapacity = list.m_maxCapacity;
            snapshot.m_cacheCapacity = list.m_capacity;
            snapshot.m_cacheSize = list.m_count;
        }
    }

    public void start() {
        long delay;
        if (this.m_resizerPeriod > 0L) {
            this.m_resizer = new ResizerTask(this.m_resizerPeriod);
            delay = (long)(Math.random() * (double)this.m_resizerPeriod);
            tasksTimer.schedule(this.m_resizer, delay, this.m_resizerPeriod);
        }
        if (this.m_overagerPeriod > 0L) {
            this.m_overager = new OveragerTask(this.m_overagerPeriod);
            delay = (long)(Math.random() * (double)this.m_overagerPeriod);
            tasksTimer.schedule(this.m_overager, delay, this.m_overagerPeriod);
        }
    }

    public void stop() {
        if (this.m_resizer != null) {
            this.m_resizer.cancel();
        }
        if (this.m_overager != null) {
            this.m_overager.cancel();
        }
        super.stop();
    }

    public void destroy() {
        this.m_overager = null;
        this.m_resizer = null;
        this.m_cache = null;
        super.destroy();
    }

    public void importXml(Element element) throws DeploymentException {
        String min = MetaData.getElementContent(MetaData.getOptionalChild(element, "min-capacity"));
        String max = MetaData.getElementContent(MetaData.getOptionalChild(element, "max-capacity"));
        String op = MetaData.getElementContent(MetaData.getOptionalChild(element, "overager-period"));
        String rp = MetaData.getElementContent(MetaData.getOptionalChild(element, "resizer-period"));
        String ma = MetaData.getElementContent(MetaData.getOptionalChild(element, "max-bean-age"));
        String map = MetaData.getElementContent(MetaData.getOptionalChild(element, "max-cache-miss-period"));
        String mip = MetaData.getElementContent(MetaData.getOptionalChild(element, "min-cache-miss-period"));
        String fa = MetaData.getElementContent(MetaData.getOptionalChild(element, "cache-load-factor"));
        try {
            int p;
            int s;
            if (min != null) {
                s = Integer.parseInt(min);
                if (s <= 0) {
                    throw new DeploymentException("Min cache capacity can't be <= 0");
                }
                this.m_minCapacity = s;
            }
            if (max != null) {
                s = Integer.parseInt(max);
                if (s <= 0) {
                    throw new DeploymentException("Max cache capacity can't be <= 0");
                }
                this.m_maxCapacity = s;
            }
            if (op != null) {
                p = Integer.parseInt(op);
                if (p <= 0) {
                    throw new DeploymentException("Overager period can't be <= 0");
                }
                this.m_overagerPeriod = p * 1000;
            }
            if (rp != null) {
                p = Integer.parseInt(rp);
                if (p <= 0) {
                    throw new DeploymentException("Resizer period can't be <= 0");
                }
                this.m_resizerPeriod = p * 1000;
            }
            if (ma != null) {
                int a = Integer.parseInt(ma);
                if (a <= 0) {
                    throw new DeploymentException("Max bean age can't be <= 0");
                }
                this.m_maxBeanAge = a * 1000;
            }
            if (map != null) {
                p = Integer.parseInt(map);
                if (p <= 0) {
                    throw new DeploymentException("Max cache miss period can't be <= 0");
                }
                this.m_maxPeriod = p * 1000;
            }
            if (mip != null) {
                p = Integer.parseInt(mip);
                if (p <= 0) {
                    throw new DeploymentException("Min cache miss period can't be <= 0");
                }
                this.m_minPeriod = p * 1000;
            }
            if (fa != null) {
                double f = Double.parseDouble(fa);
                if (f <= 0.0) {
                    throw new DeploymentException("Cache load factor can't be <= 0");
                }
                this.m_factor = f;
            }
        }
        catch (NumberFormatException x) {
            throw new DeploymentException("Can't parse policy configuration", x);
        }
    }

    public void flush() {
        int i = this.size();
        LRUCachePolicy.LRUCacheEntry entry = null;
        while (i-- > 0 && (entry = this.m_list.m_tail) != null) {
            this.ageOut(entry);
        }
    }

    protected LRUCachePolicy.LRUList createList() {
        return new ContextLRUList();
    }

    protected void ageOut(LRUCachePolicy.LRUCacheEntry entry) {
        if (this.m_cache == null) {
            return;
        }
        if (entry == null) {
            throw new IllegalArgumentException("Cannot remove a null cache entry");
        }
        if (log.isTraceEnabled()) {
            this.m_buffer.setLength(0);
            this.m_buffer.append("Aging out from cache bean ");
            this.m_buffer.append(this.m_cache.getContainer().getBeanMetaData().getEjbName());
            this.m_buffer.append("with id = ");
            this.m_buffer.append(entry.m_key);
            this.m_buffer.append("; cache size = ");
            this.m_buffer.append(this.getList().m_count);
            log.trace(this.m_buffer.toString());
        }
        this.m_cache.release((EnterpriseContext)entry.m_object);
    }

    protected void cacheMiss() {
        LRUCachePolicy.LRUList list = this.getList();
        ++list.m_cacheMiss;
    }

    private LRUCachePolicy.LRUList getList() {
        return this.m_list;
    }

    static {
        log.debug("Cache policy timer started, tasksTimer=" + tasksTimer);
    }

    protected class ContextLRUList
    extends LRUCachePolicy.LRUList {
        boolean trace = log.isTraceEnabled();

        protected ContextLRUList() {
        }

        protected void entryPromotion(LRUCachePolicy.LRUCacheEntry entry) {
            if (this.trace) {
                log.trace("entryPromotion, entry=" + entry);
            }
            if (this.m_count == this.m_capacity && this.m_capacity >= this.m_maxCapacity) {
                ++this.m_capacity;
                log.warn("Cache has reached maximum capacity for container " + LRUEnterpriseContextCachePolicy.this.m_cache.getContainer().getJmxName() + " - probably because all instances are in use. " + "Temporarily increasing the size to " + this.m_capacity);
            }
        }

        protected void entryAdded(LRUCachePolicy.LRUCacheEntry entry) {
            if (this.trace) {
                log.trace("entryAdded, entry=" + entry);
            }
        }

        protected void entryRemoved(LRUCachePolicy.LRUCacheEntry entry) {
            if (this.trace) {
                log.trace("entryRemoved, entry=" + entry);
            }
        }

        protected void capacityChanged(int oldCapacity) {
            if (this.trace) {
                log.trace("capacityChanged, oldCapacity=" + oldCapacity);
            }
        }
    }

    protected class OveragerTask
    extends TimerTask {
        private String m_message;
        private StringBuffer m_buffer;

        protected OveragerTask(long period) {
            this.m_message = this.getTaskLogMessage() + " " + LRUEnterpriseContextCachePolicy.this.m_cache.getContainer().getBeanMetaData().getEjbName() + " with id = ";
            this.m_buffer = new StringBuffer();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            LRUCachePolicy.LRUCacheEntry entry;
            if (LRUEnterpriseContextCachePolicy.this.m_cache == null) {
                this.cancel();
                return;
            }
            LRUCachePolicy.LRUList list = LRUEnterpriseContextCachePolicy.this.getList();
            long now = System.currentTimeMillis();
            ArrayList<LRUCachePolicy.LRUCacheEntry> passivateEntries = null;
            Object object = LRUEnterpriseContextCachePolicy.this.m_cache.getCacheLock();
            synchronized (object) {
                entry = list.m_tail;
                while (entry != null && now - entry.m_time >= this.getMaxAge()) {
                    if (passivateEntries == null) {
                        passivateEntries = new ArrayList<LRUCachePolicy.LRUCacheEntry>();
                    }
                    passivateEntries.add(entry);
                    entry = entry.m_prev;
                }
            }
            if (passivateEntries != null) {
                for (int i = 0; i < passivateEntries.size(); ++i) {
                    entry = (LRUCachePolicy.LRUCacheEntry)passivateEntries.get(i);
                    try {
                        LRUEnterpriseContextCachePolicy.this.m_cache.tryToPassivate((EnterpriseContext)entry.m_object);
                        continue;
                    }
                    catch (Throwable t) {
                        log.debug("Ignored error while trying to passivate ctx", t);
                    }
                }
            }
        }

        private void log(Object key, int count) {
            if (log.isTraceEnabled()) {
                this.m_buffer.setLength(0);
                this.m_buffer.append(this.m_message);
                this.m_buffer.append(key);
                this.m_buffer.append(" - Cache size = ");
                this.m_buffer.append(count);
                log.trace(this.m_buffer.toString());
            }
        }

        protected String getTaskLogMessage() {
            return "Scheduling for passivation overaged bean";
        }

        protected String getJMSTaskType() {
            return "OVERAGER";
        }

        protected long getMaxAge() {
            return LRUEnterpriseContextCachePolicy.this.m_maxBeanAge;
        }
    }

    protected class ResizerTask
    extends TimerTask {
        private String m_message;
        private StringBuffer m_buffer;
        private long resizerPeriod;

        protected ResizerTask(long resizerPeriod) {
            this.resizerPeriod = resizerPeriod;
            this.m_message = "Resized cache for bean " + LRUEnterpriseContextCachePolicy.this.m_cache.getContainer().getBeanMetaData().getEjbName() + ": old capacity = ";
            this.m_buffer = new StringBuffer();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (LRUEnterpriseContextCachePolicy.this.m_cache == null) {
                this.cancel();
                return;
            }
            LRUCachePolicy.LRUList list = LRUEnterpriseContextCachePolicy.this.getList();
            Object object = LRUEnterpriseContextCachePolicy.this.m_cache.getCacheLock();
            synchronized (object) {
                int period = list.m_cacheMiss == 0 ? Integer.MAX_VALUE : (int)(this.resizerPeriod / (long)list.m_cacheMiss);
                int cap = list.m_capacity;
                if ((long)period <= LRUEnterpriseContextCachePolicy.this.m_minPeriod && cap < list.m_maxCapacity) {
                    double factor = 1.0 + (double)LRUEnterpriseContextCachePolicy.this.m_minPeriod / (double)period * (1.0 - LRUEnterpriseContextCachePolicy.this.m_factor);
                    int newCap = (int)((double)cap * factor);
                    list.m_capacity = newCap < list.m_maxCapacity ? newCap : list.m_maxCapacity;
                    this.log(cap, list.m_capacity);
                } else if ((long)period >= LRUEnterpriseContextCachePolicy.this.m_maxPeriod && cap > list.m_minCapacity && (double)list.m_count < (double)cap * LRUEnterpriseContextCachePolicy.this.m_factor) {
                    int newCap = (int)((double)list.m_count / LRUEnterpriseContextCachePolicy.this.m_factor);
                    list.m_capacity = newCap > list.m_minCapacity ? newCap : list.m_minCapacity;
                    this.log(cap, list.m_capacity);
                }
                list.m_cacheMiss = 0;
            }
        }

        private void log(int oldCapacity, int newCapacity) {
            if (log.isTraceEnabled()) {
                this.m_buffer.setLength(0);
                this.m_buffer.append(this.m_message);
                this.m_buffer.append(oldCapacity);
                this.m_buffer.append(", new capacity = ");
                this.m_buffer.append(newCapacity);
                log.trace(this.m_buffer.toString());
            }
        }
    }
}

