/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.vdf.plugins;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.jboss.deployers.vdf.spi.VDFComponent;
import org.jboss.deployers.vdf.spi.VDFPathNameFilter;
import org.jboss.deployers.vdf.spi.VDFRuntimeException;
import org.jboss.logging.Logger;
import org.jboss.util.JBossObject;
import org.jboss.util.file.Files;
import org.jboss.util.file.JarUtils;
import org.jboss.util.stream.Streams;

public abstract class AbstractVDFComponent
extends JBossObject
implements VDFComponent {
    protected static final VDFComponent[] EMPTY_ARRAY = new VDFComponent[0];
    protected static final VDFPathNameFilter DEFAULT_FILTER = new VDFPathNameFilter(){

        public boolean accept(String pathname) {
            return true;
        }
    };
    protected URI uri;
    protected Object ctx;

    public AbstractVDFComponent(URI uri, Logger log) {
        super(log);
        if (uri == null) {
            throw new VDFRuntimeException("null URI");
        }
        this.uri = uri;
    }

    public static void copy(URL src, File dest) throws IOException {
        File srcFile;
        boolean deleted;
        if (dest.exists() && !(deleted = Files.delete(dest))) {
            throw new IOException("delete of previous content failed for: " + dest.getAbsolutePath());
        }
        if (src.getProtocol().equals("file") && (srcFile = new File(src.getFile())).isDirectory()) {
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(dest));
            JarUtils.jar((OutputStream)out, srcFile.listFiles());
            ((OutputStream)out).close();
            return;
        }
        BufferedInputStream in = new BufferedInputStream(src.openStream());
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(dest));
        Streams.copy(in, out);
        ((OutputStream)out).flush();
        ((OutputStream)out).close();
        ((InputStream)in).close();
    }

    public static Manifest getManifest(File file) {
        Manifest manifest = null;
        try {
            if (file.isDirectory()) {
                FileInputStream fis = new FileInputStream(new File(file, "META-INF/MANIFEST.MF"));
                manifest = new Manifest(fis);
                fis.close();
            } else {
                manifest = new JarFile(file).getManifest();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return manifest;
    }

    public URI getURI() {
        return this.uri;
    }

    public String getScheme() {
        return this.uri.getScheme();
    }

    public void setContext(Object ctx) {
        this.ctx = ctx;
    }

    public Object getContext() {
        return this.ctx;
    }

    public void toShortString(StringBuffer buffer) {
        buffer.append(this.uri.toString());
    }

    protected void toString(StringBuffer buffer) {
        buffer.append(this.uri.toString());
    }

    protected int getHashCode() {
        return this.uri.hashCode();
    }

    public boolean equals(Object other) {
        if (other instanceof AbstractVDFComponent) {
            return ((AbstractVDFComponent)other).uri.equals(this.uri);
        }
        return false;
    }
}

