/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.plugins.scanner;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.jboss.deployers.spi.Deployment;
import org.jboss.deployers.spi.MainDeployer;
import org.jboss.deployment.IncompleteDeploymentException;
import org.jboss.deployment.scanner.VFSDeploymentScanner;
import org.jboss.util.JBossObject;
import org.jboss.util.StringPropertyReplacer;
import org.jboss.vfs.VFSFactory;
import org.jboss.vfs.spi.ReadOnlyVFS;
import org.jboss.vfs.spi.VirtualFile;
import org.jboss.vfs.spi.VirtualFileFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VFSDeploymentScannerImpl
extends JBossObject
implements VFSDeploymentScanner,
Runnable {
    private MainDeployer mainDeployer;
    private VFSFactory factory;
    private VirtualFileFilter filter;
    private ScheduledExecutorService scanExecutor;
    private ScheduledFuture activeScan;
    private URI serverHomeURI;
    private List<URI> uriList = Collections.synchronizedList(new ArrayList());
    private List<VirtualFile> vdfList = Collections.synchronizedList(new ArrayList());
    private boolean doRecursiveSearch = true;
    private long scanPeriod = 5000L;
    private int scanCount;
    private Map<VirtualFile, Deployment> deployedMap = Collections.synchronizedMap(new HashMap());
    private IncompleteDeploymentException lastIncompleteDeploymentException;

    public void setMainDeployer(MainDeployer deployer) {
        this.mainDeployer = deployer;
    }

    @Override
    public VFSFactory getVFSFactory() {
        return this.factory;
    }

    public VirtualFileFilter getFilter() {
        return this.filter;
    }

    public void setFilter(VirtualFileFilter filter) {
        this.filter = filter;
    }

    @Override
    public void setVFSFactory(VFSFactory factory) {
        this.factory = factory;
    }

    public ScheduledExecutorService getScanExecutor() {
        return this.scanExecutor;
    }

    public void setScanExecutor(ScheduledExecutorService scanExecutor) {
        this.scanExecutor = scanExecutor;
    }

    @Override
    public long getScanPeriod() {
        return this.scanPeriod;
    }

    @Override
    public void setScanPeriod(long period) {
        this.scanPeriod = period;
    }

    @Override
    public boolean isScanEnabled() {
        return this.activeScan != null;
    }

    @Override
    public synchronized int getScanCount() {
        return this.scanCount;
    }

    @Override
    public synchronized void resetScanCount() {
        this.scanCount = 0;
    }

    @Override
    public synchronized void setScanEnabled(boolean scanEnabled) {
        if (scanEnabled && this.activeScan == null) {
            this.activeScan = this.scanExecutor.scheduleWithFixedDelay(this, 0L, this.scanPeriod, TimeUnit.MILLISECONDS);
        } else if (!scanEnabled && this.activeScan != null) {
            this.activeScan.cancel(true);
            this.activeScan = null;
        }
    }

    public void setURIs(String listspec) throws URISyntaxException, IOException {
        if (listspec == null) {
            this.uriList.clear();
            return;
        }
        LinkedList<URI> list = new LinkedList<URI>();
        StringTokenizer stok = new StringTokenizer(listspec, ",");
        while (stok.hasMoreTokens()) {
            String urispec = stok.nextToken().trim();
            this.log.debug("Adding URI from spec: " + urispec);
            URI uri = this.makeURI(urispec);
            this.log.debug("URI: " + uri);
            list.add(uri);
        }
        this.setURIList(list);
    }

    public void setURIList(List<URI> list) throws IOException {
        if (list == null) {
            return;
        }
        this.uriList.clear();
        for (int n = 0; n < list.size(); ++n) {
            URI uri = list.get(n);
            if (uri == null) {
                throw new IllegalArgumentException("list element[" + n + "] is null");
            }
            this.addURI(uri);
        }
        this.log.debug("URI list: " + this.uriList);
    }

    public List<URI> getURIList() {
        return new ArrayList<URI>(this.uriList);
    }

    public void setRecursiveSearch(boolean recurse) {
        this.doRecursiveSearch = recurse;
    }

    public boolean getRecursiveSearch() {
        return this.doRecursiveSearch;
    }

    public void addURI(URI uri) throws IOException {
        if (uri == null) {
            throw new NullPointerException("uri argument cannot be null");
        }
        if (this.uriList.add(uri)) {
            this.log.debug("Added URI: " + uri);
            if (this.factory != null) {
                URL rootURL = uri.toURL();
                ReadOnlyVFS vfs = this.factory.getVFS(rootURL);
                VirtualFile vf = vfs.resolveFile("");
                this.vdfList.add(vf);
            }
        }
    }

    public void removeURI(URI uri) throws IOException {
        boolean success;
        if (uri == null) {
            throw new NullPointerException("uri argument cannot be null");
        }
        if (this.factory != null) {
            VirtualFile vf = this.getVFforURI(uri);
            this.vdfList.remove(vf);
        }
        if (success = this.uriList.remove(uri)) {
            this.log.debug("Removed URI: " + uri);
        }
    }

    public boolean hasURI(URI uri) {
        if (uri == null) {
            throw new NullPointerException("uri argument cannot be null");
        }
        return this.uriList.contains(uri);
    }

    public void start() throws Exception {
        if (this.factory != null) {
            this.vdfList.clear();
            for (URI uri : this.uriList) {
                VirtualFile vf = this.getVFforURI(uri);
                this.vdfList.add(vf);
            }
        }
        if (this.scanExecutor == null) {
            this.scanExecutor = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

                public Thread newThread(Runnable r) {
                    return new Thread(r, "VFSDeploymentScanner");
                }
            });
        }
        this.activeScan = this.scanExecutor.scheduleWithFixedDelay(this, 0L, this.scanPeriod, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.scan();
        }
        catch (Throwable e) {
            this.log.warn("Scan failed", e);
        }
        finally {
            this.incScanCount();
        }
    }

    public void stop() {
        if (this.activeScan != null) {
            this.activeScan.cancel(true);
            this.activeScan = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void scan() throws Exception {
        VirtualFile vf;
        int i;
        if (this.vdfList == null) {
            throw new IllegalStateException("not initialized");
        }
        boolean trace = this.log.isTraceEnabled();
        this.lastIncompleteDeploymentException = null;
        if (trace) {
            this.log.trace("Scanning for new deployments");
        }
        LinkedList<VirtualFile> toDeployList = new LinkedList<VirtualFile>();
        List<VirtualFile> list = this.vdfList;
        synchronized (list) {
            for (VirtualFile virtualFile : this.vdfList) {
                this.log.debug("Checking file: " + virtualFile);
                if (virtualFile.isFile()) {
                    toDeployList.add(virtualFile);
                    continue;
                }
                if (!virtualFile.isDirectory()) continue;
                this.addDeployments(toDeployList, virtualFile);
            }
        }
        if (trace) {
            this.log.trace("toDeployList");
            Iterator i2 = toDeployList.iterator();
            while (i2.hasNext()) {
                this.log.trace(i2.next());
            }
        }
        LinkedList<VirtualFile> toRemoveList = new LinkedList<VirtualFile>();
        LinkedList<VirtualFile> toCheckForUpdateList = new LinkedList<VirtualFile>();
        Map<VirtualFile, Deployment> map = this.deployedMap;
        synchronized (map) {
            for (VirtualFile vf3 : this.deployedMap.keySet()) {
                if (toDeployList.contains(vf3)) {
                    toCheckForUpdateList.add(vf3);
                    continue;
                }
                toRemoveList.add(vf3);
            }
        }
        for (VirtualFile deployedComponent : toRemoveList) {
            this.undeploy(deployedComponent);
        }
        ArrayList<VirtualFile> arrayList = new ArrayList<VirtualFile>(toCheckForUpdateList.size());
        for (VirtualFile deployedComponent : toCheckForUpdateList) {
            if (!this.isModified(deployedComponent)) continue;
            if (trace) {
                this.log.trace("Re-deploying " + deployedComponent);
            }
            arrayList.add(deployedComponent);
        }
        for (i = arrayList.size() - 1; i >= 0; --i) {
            vf = (VirtualFile)arrayList.get(i);
            this.undeploy(vf);
        }
        for (i = 0; i < arrayList.size(); ++i) {
            vf = (VirtualFile)arrayList.get(i);
            this.deploy(vf);
        }
        Iterator i3 = toDeployList.iterator();
        while (i3.hasNext()) {
            vf = (VirtualFile)i3.next();
            if (!this.deployedMap.containsKey(vf)) {
                this.deploy(vf);
            }
            i3.remove();
        }
    }

    protected synchronized void incScanCount() {
        ++this.scanCount;
        this.notifyAll();
    }

    private URI makeURI(String urispec) throws URISyntaxException {
        urispec = StringPropertyReplacer.replaceProperties(urispec);
        return this.serverHomeURI.resolve(urispec);
    }

    private void addDeployments(List<VirtualFile> list, VirtualFile root) throws IOException {
        VirtualFile[] components = root.getChildren();
        for (int i = 0; i < components.length; ++i) {
            VirtualFile vf = components[i];
            if (vf.isFile()) {
                if (this.filter != null && !this.filter.accepts(vf)) continue;
                list.add(vf);
                continue;
            }
            if (!vf.isDirectory()) continue;
            if (vf.getName().indexOf(46) == -1 && this.doRecursiveSearch) {
                this.addDeployments(list, vf);
                continue;
            }
            list.add(vf);
        }
    }

    private void deploy(VirtualFile vf) {
        this.log.debug("Deploying: " + vf);
        Deployment deployment = null;
        try {
            URL componentUrl = vf.toURL();
            deployment = this.mainDeployer.parse(componentUrl);
            this.mainDeployer.deploy(deployment);
        }
        catch (MalformedURLException e) {
            this.log.warn("Cannot convert to URL", e);
            return;
        }
        catch (Exception e) {
            this.log.debug("Failed to deploy: " + vf, e);
        }
        String watchPath = this.getWatchURL(deployment);
        VirtualFile watchComponent = null;
        long deployedLastModified = -1L;
        try {
            if (watchPath != null) {
                watchComponent = vf.findChild(watchPath);
                deployedLastModified = watchComponent.getLastModified();
            } else {
                deployedLastModified = vf.getLastModified();
            }
        }
        catch (IOException e) {
            this.log.warn(e);
        }
        if (!this.deployedMap.containsKey(vf)) {
            this.deployedMap.put(vf, deployment);
        }
    }

    private void undeploy(VirtualFile vf) {
        try {
            this.log.debug("Undeploying: " + vf);
            Deployment deployment = this.deployedMap.remove(vf);
            this.mainDeployer.undeploy(deployment);
        }
        catch (Exception e) {
            this.log.error("Failed to undeploy: " + vf, e);
        }
    }

    private String getWatchURL(Deployment deployment) {
        String watchPath = (String)((Object)deployment.getRootContext().getContextData().get(""));
        return watchPath;
    }

    public boolean isModified(VirtualFile vf) {
        Object cc = null;
        long deployedLastModified = cc.deployedLastModified;
        long lastModified = cc.watchComponent != null ? cc.watchComponent.getLastModified() : vf.getLastModified();
        return deployedLastModified != lastModified;
    }

    private VirtualFile getVFforURI(URI uri) throws IOException {
        VirtualFile vf = null;
        if (this.factory != null) {
            URL rootURL = uri.toURL();
            ReadOnlyVFS vfs = this.factory.getVFS(rootURL);
            vf = vfs.resolveFile("");
        }
        return vf;
    }

    private static class ComponentContext {
        public VirtualFile watchComponent;
        public long deployedLastModified;

        public ComponentContext(VirtualFile watchComponent, long deployedLastModified) {
            this.watchComponent = watchComponent;
            this.deployedLastModified = deployedLastModified;
        }
    }
}

