/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.plugins;

import java.util.List;
import org.jboss.deployers.spi.AspectDeployer;
import org.jboss.deployers.spi.DeploymentContext;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.util.graph.Edge;
import org.jboss.util.graph.Graph;
import org.jboss.util.graph.Vertex;
import org.jboss.util.graph.VisitorEX;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeploymentGraphVisitor
implements VisitorEX<DeploymentContext, DeploymentException> {
    private List<AspectDeployer> deployers;
    private MODE mode;

    public DeploymentGraphVisitor(List<AspectDeployer> deployers, MODE mode) {
        this.deployers = deployers;
        this.mode = mode;
    }

    @Override
    public void visit(Graph<DeploymentContext> g, Vertex<DeploymentContext> v) throws DeploymentException {
        for (AspectDeployer deployer : this.deployers) {
            String type = deployer.getType();
            DeploymentContext ctx = v.getData();
            if (!ctx.isDeploymentType(type)) continue;
            switch (this.mode) {
                case Deploy: {
                    deployer.deploy(ctx);
                    break;
                }
                case Redeploy: {
                    deployer.redeploy(ctx);
                    break;
                }
                case Undeploy: {
                    deployer.undeploy(ctx);
                }
            }
        }
    }

    public void visit(Graph<DeploymentContext> g, Vertex<DeploymentContext> v, Edge<DeploymentContext> e) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MODE {
        Deploy,
        Redeploy,
        Undeploy;

    }
}

