/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.beans.metadata.plugins;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.beans.metadata.plugins.AbstractFeatureMetaData;
import org.jboss.beans.metadata.plugins.AbstractPropertyMetaData;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.BeanMetaDataFactory;
import org.jboss.beans.metadata.spi.ClassLoaderMetaData;
import org.jboss.beans.metadata.spi.ConstructorMetaData;
import org.jboss.beans.metadata.spi.DemandMetaData;
import org.jboss.beans.metadata.spi.InstallMetaData;
import org.jboss.beans.metadata.spi.LifecycleMetaData;
import org.jboss.beans.metadata.spi.MetaDataVisitorNode;
import org.jboss.beans.metadata.spi.PropertyMetaData;
import org.jboss.beans.metadata.spi.SupplyMetaData;
import org.jboss.dependency.spi.ControllerMode;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.util.JBossObject;
import org.jboss.util.JBossStringBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractBeanMetaData
extends AbstractFeatureMetaData
implements BeanMetaData,
BeanMetaDataFactory {
    protected String bean;
    protected String name;
    protected ControllerMode mode = null;
    private Set<PropertyMetaData> properties;
    protected ClassLoaderMetaData classLoader;
    protected ConstructorMetaData constructor;
    protected LifecycleMetaData create;
    protected LifecycleMetaData start;
    protected LifecycleMetaData stop;
    protected LifecycleMetaData destroy;
    protected Set<DemandMetaData> demands;
    protected Set<SupplyMetaData> supplies;
    protected List<InstallMetaData> installs;
    protected List<InstallMetaData> uninstalls;

    public AbstractBeanMetaData() {
    }

    public AbstractBeanMetaData(String bean) {
        this.bean = bean;
    }

    public AbstractBeanMetaData(String name, String bean) {
        this.name = name;
        this.bean = bean;
    }

    @Override
    public List<BeanMetaData> getBeans() {
        return Collections.singletonList(this);
    }

    @Override
    public String getBean() {
        return this.bean;
    }

    public void setBean(String bean) {
        this.bean = bean;
        this.flushJBossObjectCache();
    }

    public PropertyMetaData getProperty(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        if (this.properties != null && this.properties.size() > 0) {
            for (AbstractPropertyMetaData abstractPropertyMetaData : this.properties) {
                if (!name.equals(abstractPropertyMetaData.getName())) continue;
                return abstractPropertyMetaData;
            }
        }
        return null;
    }

    public void addProperty(PropertyMetaData property) {
        if (property == null) {
            throw new IllegalArgumentException("Null property");
        }
        if (this.properties == null) {
            this.properties = new HashSet<PropertyMetaData>();
        }
        this.properties.add(property);
        this.flushJBossObjectCache();
    }

    public void setProperties(Set<PropertyMetaData> properties) {
        this.properties = properties;
        this.flushJBossObjectCache();
    }

    @Override
    public ClassLoaderMetaData getClassLoader() {
        return this.classLoader;
    }

    @Override
    public void setClassLoader(ClassLoaderMetaData classLoader) {
        this.classLoader = classLoader;
    }

    public void setConstructor(ConstructorMetaData constructor) {
        this.constructor = constructor;
    }

    public void setDemands(Set<DemandMetaData> demands) {
        this.demands = demands;
        this.flushJBossObjectCache();
    }

    public void setSupplies(Set<SupplyMetaData> supplies) {
        this.supplies = supplies;
        this.flushJBossObjectCache();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
        this.flushJBossObjectCache();
    }

    @Override
    public ControllerMode getMode() {
        return this.mode;
    }

    @Override
    public void setMode(ControllerMode mode) {
        this.mode = mode;
        this.flushJBossObjectCache();
    }

    @Override
    public Set<PropertyMetaData> getProperties() {
        return this.properties;
    }

    @Override
    public ConstructorMetaData getConstructor() {
        return this.constructor;
    }

    @Override
    public LifecycleMetaData getCreate() {
        return this.create;
    }

    public void setCreate(LifecycleMetaData lifecycle) {
        lifecycle.setState(ControllerState.CREATE);
        this.create = lifecycle;
    }

    @Override
    public LifecycleMetaData getStart() {
        return this.start;
    }

    public void setStart(LifecycleMetaData lifecycle) {
        lifecycle.setState(ControllerState.START);
        this.start = lifecycle;
    }

    @Override
    public LifecycleMetaData getStop() {
        return this.stop;
    }

    public void setStop(LifecycleMetaData lifecycle) {
        lifecycle.setState(ControllerState.START);
        this.stop = lifecycle;
    }

    @Override
    public LifecycleMetaData getDestroy() {
        return this.destroy;
    }

    public void setDestroy(LifecycleMetaData lifecycle) {
        lifecycle.setState(ControllerState.CREATE);
        this.destroy = lifecycle;
    }

    @Override
    public Set<DemandMetaData> getDemands() {
        return this.demands;
    }

    @Override
    public Set<SupplyMetaData> getSupplies() {
        return this.supplies;
    }

    @Override
    public List<InstallMetaData> getInstalls() {
        return this.installs;
    }

    public void setInstalls(List<InstallMetaData> installs) {
        this.installs = installs;
        this.flushJBossObjectCache();
    }

    @Override
    public List<InstallMetaData> getUninstalls() {
        return this.uninstalls;
    }

    public void setUninstalls(List<InstallMetaData> uninstalls) {
        this.uninstalls = uninstalls;
        this.flushJBossObjectCache();
    }

    @Override
    protected void addChildren(Set<MetaDataVisitorNode> children) {
        super.addChildren(children);
        if (this.classLoader != null) {
            children.add(this.classLoader);
        }
        if (this.constructor != null) {
            children.add(this.constructor);
        }
        if (this.properties != null) {
            children.addAll(this.properties);
        }
        if (this.create != null) {
            children.add(this.create);
        }
        if (this.start != null) {
            children.add(this.start);
        }
        if (this.stop != null) {
            children.add(this.stop);
        }
        if (this.destroy != null) {
            children.add(this.destroy);
        }
        if (this.demands != null) {
            children.addAll(this.demands);
        }
        if (this.supplies != null) {
            children.addAll(this.supplies);
        }
        if (this.installs != null) {
            children.addAll(this.installs);
        }
        if (this.uninstalls != null) {
            children.addAll(this.uninstalls);
        }
    }

    @Override
    public void toString(JBossStringBuilder buffer) {
        buffer.append("name=").append(this.name);
        buffer.append(" bean=").append(this.bean);
        buffer.append(" properties=");
        JBossObject.list(buffer, this.properties);
        if (this.classLoader != null) {
            buffer.append(" classLoader=").append(this.classLoader);
        }
        buffer.append(" constructor=").append(this.constructor);
        if (this.create != null) {
            buffer.append(" create=").append(this.create);
        }
        if (this.start != null) {
            buffer.append(" start=").append(this.start);
        }
        if (this.stop != null) {
            buffer.append(" stop=").append(this.stop);
        }
        if (this.destroy != null) {
            buffer.append(" destroy=").append(this.destroy);
        }
        if (this.demands != null) {
            buffer.append(" demands=");
            JBossObject.list(buffer, this.demands);
        }
        super.toString(buffer);
        if (this.supplies != null) {
            buffer.append(" supplies=");
            JBossObject.list(buffer, this.supplies);
        }
        if (this.installs != null) {
            buffer.append(" installs=");
            JBossObject.list(buffer, this.installs);
        }
        if (this.uninstalls != null) {
            buffer.append(" uninstalls=");
            JBossObject.list(buffer, this.uninstalls);
        }
    }

    @Override
    public void toShortString(JBossStringBuilder buffer) {
        buffer.append(this.bean);
        buffer.append('/');
        buffer.append(this.name);
    }
}

