/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aspects.dbc;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.jboss.aop.joinpoint.ConstructorCalledByConstructorInvocation;
import org.jboss.aop.joinpoint.ConstructorCalledByMethodInvocation;
import org.jboss.aop.joinpoint.ConstructorInvocation;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.MethodCalledByConstructorInvocation;
import org.jboss.aop.joinpoint.MethodCalledByMethodInvocation;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.aspects.dbc.condition.ConstructorConditionManager;
import org.jboss.aspects.dbc.condition.ExecutableCondition;
import org.jboss.aspects.dbc.condition.InvariantCondition;
import org.jboss.aspects.dbc.condition.MethodConditionManager;

public class DesignByContractAspect {
    public static boolean verbose;
    ExecutableCondition[] preconditions;
    ExecutableCondition[] postconditions;
    InvariantCondition[] invariants;
    Method method;
    Constructor constructor;
    boolean isPublic;
    boolean isStatic;
    boolean isSynchronized;
    boolean initialised;
    ThreadLocal done = new ThreadLocal();

    public DesignByContractAspect() {
        this.done.set(Boolean.FALSE);
    }

    public void setVerbose(boolean vbs) {
        verbose = vbs;
    }

    public boolean getVerbose() {
        return verbose;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        if (!this.initialised) {
            this.initialise(invocation.getMethod());
        }
        Object[] args = invocation.getArguments();
        return this.invoke(invocation, args);
    }

    public Object invoke(MethodCalledByMethodInvocation invocation) throws Throwable {
        if (!this.initialised) {
            this.initialise(invocation.getCalledMethod());
        }
        Object[] args = invocation.getArguments();
        return this.invoke(invocation, args);
    }

    public Object invoke(MethodCalledByConstructorInvocation invocation) throws Throwable {
        if (!this.initialised) {
            this.initialise(invocation.getCalledMethod());
        }
        Object[] args = invocation.getArguments();
        return this.invoke(invocation, args);
    }

    public Object invoke(ConstructorInvocation invocation) throws Throwable {
        if (!this.initialised) {
            this.initialise(invocation.getConstructor());
        }
        Object[] args = invocation.getArguments();
        return this.invoke(invocation, args);
    }

    public Object invoke(ConstructorCalledByMethodInvocation invocation) throws Throwable {
        if (!this.initialised) {
            this.initialise(invocation.getCalledConstructor());
        }
        Object[] args = invocation.getArguments();
        return this.invoke(invocation, args);
    }

    public Object invoke(ConstructorCalledByConstructorInvocation invocation) throws Throwable {
        if (!this.initialised) {
            this.initialise(invocation.getCalledConstructor());
        }
        Object[] args = invocation.getArguments();
        return this.invoke(invocation, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object invoke(Invocation invocation, Object[] args) throws Throwable {
        if (this.isSynchronized) {
            if (this.isStatic) {
                Class<?> clazz = this.method.getDeclaringClass();
                synchronized (clazz) {
                    return this.doInvoke(invocation, args);
                }
            }
            Object object = invocation.getTargetObject();
            synchronized (object) {
                return this.doInvoke(invocation, args);
            }
        }
        return this.doInvoke(invocation, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object doInvoke(Invocation invocation, Object[] args) throws Throwable {
        this.logStart();
        Object ret = null;
        boolean wasDone = (Boolean)this.done.get();
        try {
            this.done.set(Boolean.TRUE);
            if (!wasDone && this.isPublic && this.constructor == null) {
                this.checkInvariants(invocation, null);
            }
            if (!wasDone) {
                this.checkPreConditions(invocation, args);
            }
            ret = invocation.invokeNext();
            if (!wasDone && this.isPublic) {
                this.checkInvariants(invocation, ret);
                this.checkPostConditions(invocation, args, ret);
            }
        }
        finally {
            if (!wasDone) {
                this.done.set(Boolean.FALSE);
            }
        }
        this.logEnd();
        return ret;
    }

    private void logStart() {
        if (verbose) {
            if (this.method != null) {
                System.out.println("[dbc] ======= Invoking method: " + this.method);
            } else {
                System.out.println("[dbc] ======= Invoking constructor: " + this.constructor);
            }
        }
    }

    private void logEnd() {
        if (verbose) {
            if (this.method != null) {
                System.out.println("[dbc] ======= Invoked method: " + this.method);
            } else {
                System.out.println("[dbc] ======= Invoked constructor: " + this.constructor);
            }
        }
    }

    private void initialise(Method m) {
        this.method = m;
        int modifiers = m.getModifiers();
        this.initialise(modifiers);
        this.preconditions = MethodConditionManager.getPreConditions(m);
        this.postconditions = MethodConditionManager.getPostConditions(m);
        if (this.isPublic) {
            this.invariants = MethodConditionManager.getInvariants(m);
        }
    }

    private void initialise(Constructor c) {
        this.constructor = c;
        int modifiers = c.getModifiers();
        this.initialise(modifiers);
        this.preconditions = ConstructorConditionManager.getPreConditions(c);
        this.postconditions = ConstructorConditionManager.getPostConditions(c);
        if (this.isPublic) {
            this.invariants = ConstructorConditionManager.getInvariants(c);
        }
    }

    private void initialise(int modifiers) {
        this.isSynchronized = Modifier.isSynchronized(modifiers);
        this.isStatic = Modifier.isStatic(modifiers);
        this.isPublic = Modifier.isPublic(modifiers);
        this.initialised = true;
    }

    private void checkPreConditions(Invocation invocation, Object[] args) {
        if (verbose) {
            System.out.println("[dbc] === checkPreconditions() for " + (this.method != null ? this.method.toString() : this.constructor.toString()));
        }
        for (int i = 0; i < this.preconditions.length; ++i) {
            this.preconditions[i].evaluateCondition(this, invocation, args, null);
        }
    }

    private void checkPostConditions(Invocation invocation, Object[] args, Object ret) {
        if (verbose) {
            System.out.println("[dbc] === checkPostconditions() for " + (this.method != null ? this.method.toString() : this.constructor.toString()));
        }
        for (int i = 0; i < this.postconditions.length; ++i) {
            this.postconditions[i].evaluateCondition(this, invocation, args, ret);
        }
    }

    private void checkInvariants(Invocation invocation, Object ret) {
        if (verbose) {
            System.out.println("[dbc] === checkInvariants() for " + (this.method != null ? this.method.toString() : this.constructor.toString()));
        }
        boolean isConstructor = this.constructor != null;
        for (int i = 0; i < this.invariants.length; ++i) {
            this.invariants[i].evaluateCondition(invocation, this.isStatic, isConstructor, ret);
        }
    }
}

