/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aspects.concurrent;

import java.util.concurrent.Semaphore;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aspects.concurrent.LockAcquisitionFailureException;
import org.jboss.aspects.concurrent.SemaphoredMethod;

public class SemaphoredMethodAspect {
    protected Semaphore semaphore;
    protected SemaphoredMethod props;

    public SemaphoredMethodAspect(SemaphoredMethod m) {
        this.props = m;
        this.semaphore = new Semaphore(m.permits(), m.isFair());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object acquire(Invocation invocation) throws Throwable {
        if (this.props.timeout() == -1L) {
            this.blockIndefinately();
        } else if (this.props.timeout() == 0L) {
            this.tryLock();
        } else {
            this.tryLockWithTimeout();
        }
        try {
            Object object = invocation.invokeNext();
            return object;
        }
        finally {
            this.semaphore.release();
        }
    }

    protected void blockIndefinately() {
        try {
            this.semaphore.acquire();
        }
        catch (InterruptedException e) {
            throw new LockAcquisitionFailureException("Failed to acquire permit for @SemaphoredMethod", e);
        }
    }

    protected void tryLock() {
        if (!this.semaphore.tryAcquire()) {
            throw new LockAcquisitionFailureException("Failed to acquire permit for @SemaphoredMethod");
        }
    }

    protected void tryLockWithTimeout() {
        try {
            if (!this.semaphore.tryAcquire(this.props.permits(), this.props.timeout(), this.props.unit())) {
                throw new LockAcquisitionFailureException("Failed to acquire permit for @SemaphoredMethod.  Timeout reached.");
            }
        }
        catch (InterruptedException e) {
            throw new LockAcquisitionFailureException("Failed to acquire permit for @Semaphored class", e);
        }
    }
}

