/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.contrib;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import javassist.CannotCompileException;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.LoaderClassPath;
import javassist.scopedpool.ScopedClassPool;
import javassist.scopedpool.ScopedClassPoolFactory;
import javassist.scopedpool.ScopedClassPoolRepository;
import org.jboss.aop.classpool.AOPClassPool;

public class IDEClassPoolFactory
implements ScopedClassPoolFactory {
    private ArrayList classPaths = new ArrayList();

    public ScopedClassPool create(ClassLoader loader, ClassPool pool, ScopedClassPoolRepository repository) {
        SimpleClassPool classPool = new SimpleClassPool(loader, pool, repository);
        return classPool;
    }

    public ScopedClassPool create(ClassPool pool, ScopedClassPoolRepository repository) {
        SimpleClassPool classPool = new SimpleClassPool(pool, repository);
        return classPool;
    }

    public void insertClasspath(String path) {
        try {
            this.classPaths.add(new URL(path));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ClassLoader getTCLIfScoped() {
        return null;
    }

    private class Loader
    extends URLClassLoader {
        public Loader(URL[] urls, ClassLoader src) {
            super(urls, src);
        }

        public Class loadClass(String name, byte[] classfile) throws ClassFormatError {
            Class<?> c = this.defineClass(name, classfile, 0, classfile.length);
            this.resolveClass(c);
            return c;
        }
    }

    private class SimpleClassPool
    extends AOPClassPool {
        private Loader loader;

        public SimpleClassPool(ClassLoader loader, ClassPool pool, ScopedClassPoolRepository repository) {
            super(loader, pool, repository);
            this.loadClasspath();
        }

        public SimpleClassPool(ClassPool pool, ScopedClassPoolRepository repository) {
            super(pool, repository);
            this.loadClasspath();
        }

        private void loadClasspath() {
            this.childFirstLookup = true;
            URL[] urlPaths = IDEClassPoolFactory.this.classPaths.toArray(new URL[IDEClassPoolFactory.this.classPaths.size()]);
            this.loader = new Loader(urlPaths, Thread.currentThread().getContextClassLoader());
            this.setClassLoader(this.loader);
            Thread.currentThread().setContextClassLoader(this.loader);
            this.classPath = new LoaderClassPath((ClassLoader)this.loader);
            this.insertClassPath((ClassPath)this.classPath);
        }

        public Class toClass(CtClass cc) throws CannotCompileException {
            try {
                return this.loader.loadClass(cc.getName());
            }
            catch (Exception e) {
                try {
                    return this.loader.loadClass(cc.getName(), cc.toBytecode());
                }
                catch (IOException e2) {
                    throw new CannotCompileException((Throwable)e2);
                }
            }
        }
    }
}

