/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.jboss.aop.Advisor;
import org.jboss.aop.JoinPointInfo;
import org.jboss.aop.joinpoint.FieldJoinpoint;
import org.jboss.aop.joinpoint.Joinpoint;
import org.jboss.aop.util.MethodHashing;

public class FieldInfo
extends JoinPointInfo {
    private int index;
    private Field advisedField;
    private Method wrapper;
    private boolean read;

    public FieldInfo() {
    }

    public FieldInfo(Class clazz, int index, String fieldName, long wrapperHash, Advisor advisor, boolean read) {
        super(advisor);
        try {
            this.index = index;
            this.advisedField = System.getSecurityManager() == null ? GetDeclaredFieldAction.NON_PRIVILEGED.get(clazz, fieldName) : GetDeclaredFieldAction.PRIVILEGED.get(clazz, fieldName);
            this.wrapper = MethodHashing.findMethodByHash(clazz, wrapperHash);
            this.setAdvisor(advisor);
            this.read = read;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private FieldInfo(FieldInfo other) {
        super(other);
        this.index = other.index;
        this.advisedField = other.advisedField;
        this.wrapper = other.wrapper;
        this.read = other.read;
    }

    protected Joinpoint internalGetJoinpoint() {
        return new FieldJoinpoint(this.advisedField);
    }

    public JoinPointInfo copy() {
        return new FieldInfo(this);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Field ");
        sb.append(this.read ? " Read" : "Write");
        sb.append("[");
        sb.append("field=" + this.advisedField);
        sb.append("]");
        return sb.toString();
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public int getIndex() {
        return this.index;
    }

    public void setAdvisedField(Field advisedField) {
        this.advisedField = advisedField;
    }

    public Field getAdvisedField() {
        return this.advisedField;
    }

    public void setWrapper(Method wrapper) {
        this.wrapper = wrapper;
    }

    public Method getWrapper() {
        return this.wrapper;
    }

    public void setRead(boolean read) {
        this.read = read;
    }

    public boolean isRead() {
        return this.read;
    }

    static interface GetDeclaredFieldAction {
        public static final GetDeclaredFieldAction PRIVILEGED = new GetDeclaredFieldAction(){

            public Field get(final Class clazz, final String name) throws NoSuchFieldException {
                try {
                    return (Field)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            return clazz.getDeclaredField(name);
                        }
                    });
                }
                catch (PrivilegedActionException e) {
                    Exception ex = e.getException();
                    if (ex instanceof NoSuchFieldException) {
                        throw (NoSuchFieldException)ex;
                    }
                    throw new RuntimeException(ex);
                }
            }
        };
        public static final GetDeclaredFieldAction NON_PRIVILEGED = new GetDeclaredFieldAction(){

            public Field get(Class clazz, String name) throws NoSuchFieldException {
                return clazz.getDeclaredField(name);
            }
        };

        public Field get(Class var1, String var2) throws NoSuchFieldException;
    }
}

