/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.annotation.factory.javassist;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javassist.bytecode.annotation.Annotation;
import javassist.bytecode.annotation.AnnotationMemberValue;
import javassist.bytecode.annotation.ArrayMemberValue;
import javassist.bytecode.annotation.BooleanMemberValue;
import javassist.bytecode.annotation.ByteMemberValue;
import javassist.bytecode.annotation.CharMemberValue;
import javassist.bytecode.annotation.ClassMemberValue;
import javassist.bytecode.annotation.DoubleMemberValue;
import javassist.bytecode.annotation.EnumMemberValue;
import javassist.bytecode.annotation.FloatMemberValue;
import javassist.bytecode.annotation.IntegerMemberValue;
import javassist.bytecode.annotation.LongMemberValue;
import javassist.bytecode.annotation.MemberValue;
import javassist.bytecode.annotation.MemberValueVisitor;
import javassist.bytecode.annotation.ShortMemberValue;
import javassist.bytecode.annotation.StringMemberValue;
import org.jboss.annotation.factory.javassist.AnnotationProxy;

public class ProxyMapCreator
implements MemberValueVisitor {
    public Object value;
    private Class type;

    public ProxyMapCreator(Class type) {
        this.type = type;
    }

    public void visitAnnotationMemberValue(AnnotationMemberValue annotationMemberValue) {
        try {
            this.value = AnnotationProxy.createProxy(annotationMemberValue.getValue());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void visitArrayMemberValue(ArrayMemberValue arrayMemberValue) {
        Class<?> baseType = this.type.getComponentType();
        int size = 0;
        size = arrayMemberValue.getValue() == null || arrayMemberValue.getValue().length == 0 ? 0 : arrayMemberValue.getValue().length;
        this.value = Array.newInstance(baseType, size);
        MemberValue[] elements = arrayMemberValue.getValue();
        for (int i = 0; i < size; ++i) {
            ProxyMapCreator creator = new ProxyMapCreator(baseType);
            elements[i].accept((MemberValueVisitor)creator);
            Array.set(this.value, i, creator.value);
        }
    }

    public void visitBooleanMemberValue(BooleanMemberValue booleanMemberValue) {
        this.value = new Boolean(booleanMemberValue.getValue());
    }

    public void visitByteMemberValue(ByteMemberValue byteMemberValue) {
        this.value = new Byte(byteMemberValue.getValue());
    }

    public void visitCharMemberValue(CharMemberValue charMemberValue) {
        this.value = new Character(charMemberValue.getValue());
    }

    public void visitDoubleMemberValue(DoubleMemberValue doubleMemberValue) {
        this.value = new Double(doubleMemberValue.getValue());
    }

    public void visitEnumMemberValue(EnumMemberValue enumMemberValue) {
        try {
            Field enumVal = this.type.getField(enumMemberValue.getValue());
            this.value = enumVal.get(null);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public void visitFloatMemberValue(FloatMemberValue floatMemberValue) {
        this.value = new Float(floatMemberValue.getValue());
    }

    public void visitIntegerMemberValue(IntegerMemberValue integerMemberValue) {
        this.value = new Integer(integerMemberValue.getValue());
    }

    public void visitLongMemberValue(LongMemberValue longMemberValue) {
        this.value = new Long(longMemberValue.getValue());
    }

    public void visitShortMemberValue(ShortMemberValue shortMemberValue) {
        this.value = new Short(shortMemberValue.getValue());
    }

    public void visitStringMemberValue(StringMemberValue stringMemberValue) {
        this.value = stringMemberValue.getValue();
    }

    public void visitClassMemberValue(ClassMemberValue classMemberValue) {
        try {
            String classname = classMemberValue.getValue();
            this.value = classname.equals("void") ? Void.TYPE : (classname.equals("int") ? Integer.TYPE : (classname.equals("byte") ? Byte.TYPE : (classname.equals("long") ? Long.TYPE : (classname.equals("double") ? Double.TYPE : (classname.equals("float") ? Float.TYPE : (classname.equals("char") ? Character.TYPE : (classname.equals("short") ? Short.TYPE : (classname.equals("boolean") ? Boolean.TYPE : Thread.currentThread().getContextClassLoader().loadClass(classMemberValue.getValue())))))))));
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static Class getMemberType(Class annotation, String member) {
        Method[] methods = annotation.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equals(member)) continue;
            return methods[i].getReturnType();
        }
        throw new RuntimeException("unable to determine member type for annotation: " + annotation.getName() + "." + member);
    }

    public static Map createProxyMap(Class annotation, Annotation info) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (info.getMemberNames() == null) {
            return map;
        }
        Set members = info.getMemberNames();
        for (String name : members) {
            MemberValue mv = info.getMemberValue(name);
            ProxyMapCreator creator = new ProxyMapCreator(ProxyMapCreator.getMemberType(annotation, name));
            mv.accept((MemberValueVisitor)creator);
            map.put(name, creator.value);
        }
        return map;
    }
}

