/*
 * Decompiled with CFR 0.152.
 */
package javax.management.relation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.MBeanServerNotification;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.relation.InvalidRelationIdException;
import javax.management.relation.InvalidRelationServiceException;
import javax.management.relation.InvalidRelationTypeException;
import javax.management.relation.InvalidRoleValueException;
import javax.management.relation.MBeanServerNotificationFilter;
import javax.management.relation.Relation;
import javax.management.relation.RelationNotFoundException;
import javax.management.relation.RelationNotification;
import javax.management.relation.RelationServiceMBean;
import javax.management.relation.RelationServiceNotRegisteredException;
import javax.management.relation.RelationSupport;
import javax.management.relation.RelationType;
import javax.management.relation.RelationTypeNotFoundException;
import javax.management.relation.RelationTypeSupport;
import javax.management.relation.Role;
import javax.management.relation.RoleInfo;
import javax.management.relation.RoleInfoNotFoundException;
import javax.management.relation.RoleList;
import javax.management.relation.RoleNotFoundException;
import javax.management.relation.RoleResult;
import javax.management.relation.RoleValidator;
import org.jboss.logging.Logger;

public class RelationService
extends NotificationBroadcasterSupport
implements RelationServiceMBean,
MBeanRegistration,
NotificationListener {
    private static final Logger log = Logger.getLogger(RelationService.class);
    private HashMap idsByRelation = new HashMap();
    private ObjectName relationService;
    private long notificationSequence = 0L;
    private boolean purgeFlag;
    private HashMap relationsById = new HashMap();
    private MBeanServer server;
    private HashMap typesByName = new HashMap();
    private HashMap typeNamesById = new HashMap();
    private MBeanServerNotificationFilter filter;
    private Stack unregistered = new Stack();
    private HashMap idRolesMapByMBean = new HashMap();
    private ObjectName delegate;

    public RelationService(boolean purgeFlag) {
        this.setPurgeFlag(purgeFlag);
    }

    public synchronized void addRelation(ObjectName relation) throws IllegalArgumentException, NoSuchMethodException, RelationServiceNotRegisteredException, InvalidRelationIdException, InvalidRelationServiceException, RelationTypeNotFoundException, InvalidRoleValueException, RoleNotFoundException, InstanceNotFoundException {
        if (relation == null) {
            throw new IllegalArgumentException("null relation");
        }
        this.isActive();
        ObjectName otherService = null;
        String relationId = null;
        String relationTypeName = null;
        RoleList roleList = null;
        try {
            this.server.isInstanceOf(relation, Relation.class.getName());
            otherService = (ObjectName)this.server.getAttribute(relation, "RelationServiceName");
            relationId = (String)this.server.getAttribute(relation, "RelationId");
            relationTypeName = (String)this.server.getAttribute(relation, "RelationTypeName");
            roleList = (RoleList)this.server.invoke(relation, "retrieveAllRoles", new Object[0], new String[0]);
        }
        catch (InstanceNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new NoSuchMethodException("Not a relation or not registered");
        }
        if (relationId == null) {
            throw new InvalidRelationIdException("Null relation id");
        }
        if (otherService == null || !otherService.equals(this.relationService)) {
            throw new InvalidRelationServiceException(otherService + " != " + this.relationService);
        }
        RoleList copy = new RoleList(roleList);
        this.createMissingRoles(relationTypeName, copy);
        RoleValidator.validateRoles(this.relationService, this.server, relationTypeName, copy, false);
        this.validateAndAddRelation(relationId, relation, relationTypeName);
        this.filter.enableObjectName(relation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addRelationType(RelationType relationType) throws IllegalArgumentException, InvalidRelationTypeException {
        if (relationType == null) {
            throw new IllegalArgumentException("null relation type");
        }
        HashMap hashMap = this.typesByName;
        synchronized (hashMap) {
            String name = relationType.getRelationTypeName();
            if (name == null) {
                throw new IllegalArgumentException("Null relation type name in relation type");
            }
            if (this.typesByName.containsKey(name)) {
                throw new InvalidRelationTypeException("duplicate relation id: " + name);
            }
            this.validateRelationType(relationType);
            this.typesByName.put(name, relationType);
        }
    }

    public Integer checkRoleReading(String roleName, String relationTypeName) throws IllegalArgumentException, RelationTypeNotFoundException {
        if (roleName == null) {
            throw new IllegalArgumentException("Null role name");
        }
        RelationType relationType = this.retrieveRelationTypeForName(relationTypeName);
        RoleInfo roleInfo = null;
        try {
            roleInfo = relationType.getRoleInfo(roleName);
        }
        catch (RoleInfoNotFoundException e) {
            return new Integer(1);
        }
        if (!roleInfo.isReadable()) {
            return new Integer(2);
        }
        return new Integer(0);
    }

    public Integer checkRoleWriting(Role role, String relationTypeName, Boolean initFlag) throws IllegalArgumentException, RelationTypeNotFoundException {
        if (role == null) {
            throw new IllegalArgumentException("Null role name");
        }
        if (initFlag == null) {
            throw new IllegalArgumentException("Null init flag");
        }
        RelationType relationType = this.retrieveRelationTypeForName(relationTypeName);
        RoleInfo roleInfo = null;
        try {
            roleInfo = relationType.getRoleInfo(role.getRoleName());
        }
        catch (RoleInfoNotFoundException e) {
            return new Integer(1);
        }
        if (!initFlag.booleanValue() && !roleInfo.isWritable()) {
            return new Integer(3);
        }
        ArrayList mbeans = (ArrayList)role.getRoleValue();
        int beanCount = mbeans.size();
        int minimum = roleInfo.getMinDegree();
        if (minimum != RoleInfo.ROLE_CARDINALITY_INFINITY && minimum > beanCount) {
            return new Integer(4);
        }
        int maximum = roleInfo.getMaxDegree();
        if (maximum != RoleInfo.ROLE_CARDINALITY_INFINITY && maximum < beanCount) {
            return new Integer(5);
        }
        String className = roleInfo.getRefMBeanClassName();
        Iterator iterator = mbeans.iterator();
        while (iterator.hasNext()) {
            try {
                ObjectName objectName = (ObjectName)iterator.next();
                if (this.server.isInstanceOf(objectName, className)) continue;
                return new Integer(6);
            }
            catch (Exception e) {
                return new Integer(7);
            }
        }
        return new Integer(0);
    }

    public synchronized void createRelation(String relationId, String relationTypeName, RoleList roleList) throws IllegalArgumentException, RelationServiceNotRegisteredException, InvalidRelationIdException, RelationTypeNotFoundException, InvalidRoleValueException, RoleNotFoundException {
        RoleList copy = null;
        copy = roleList != null ? new RoleList(roleList) : new RoleList();
        this.isActive();
        RelationSupport relation = new RelationSupport(relationId, this.relationService, this.server, relationTypeName, copy);
        this.createMissingRoles(relationTypeName, copy);
        RoleValidator.validateRoles(this.relationService, this.server, relationTypeName, copy, false);
        this.validateAndAddRelation(relationId, relation, relationTypeName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void createRelationType(String relationTypeName, RoleInfo[] roleInfos) throws IllegalArgumentException, InvalidRelationTypeException {
        if (relationTypeName == null) {
            throw new IllegalArgumentException("null relation type name");
        }
        HashMap hashMap = this.typesByName;
        synchronized (hashMap) {
            if (this.typesByName.containsKey(relationTypeName)) {
                throw new InvalidRelationTypeException("duplicate relation id: " + relationTypeName);
            }
            RelationTypeSupport relationType = new RelationTypeSupport(relationTypeName, roleInfos);
            this.typesByName.put(relationTypeName, relationType);
        }
    }

    public Map findAssociatedMBeans(ObjectName mbeanName, String relationTypeName, String roleName) throws IllegalArgumentException {
        HashMap referencing = (HashMap)this.findReferencingRelations(mbeanName, relationTypeName, roleName);
        HashMap result = new HashMap();
        Iterator relationIterator = referencing.entrySet().iterator();
        while (relationIterator.hasNext()) {
            Map.Entry referencingEntry = relationIterator.next();
            String relationId = (String)referencingEntry.getKey();
            HashMap referenced = null;
            try {
                referenced = (HashMap)this.getReferencedMBeans(relationId);
            }
            catch (RelationNotFoundException e) {
                throw new RuntimeException(e.toString());
            }
            Iterator mbeanIterator = referenced.entrySet().iterator();
            while (mbeanIterator.hasNext()) {
                Map.Entry referencedEntry = mbeanIterator.next();
                ObjectName objectName = (ObjectName)referencedEntry.getKey();
                if (objectName.equals(mbeanName)) continue;
                ArrayList<String> resultList = (ArrayList<String>)result.get(objectName);
                if (resultList == null) {
                    resultList = new ArrayList<String>();
                    resultList.add(relationId);
                    result.put(objectName, resultList);
                    continue;
                }
                if (resultList.contains(relationId)) continue;
                resultList.add(relationId);
            }
        }
        return result;
    }

    public Map findReferencingRelations(ObjectName mbeanName, String relationTypeName, String roleName) throws IllegalArgumentException {
        if (mbeanName == null) {
            throw new IllegalArgumentException("null object name");
        }
        HashMap result = new HashMap();
        HashMap idRolesMap = (HashMap)this.idRolesMapByMBean.get(mbeanName);
        if (idRolesMap == null) {
            return result;
        }
        Iterator iterator = idRolesMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String relationId = (String)entry.getKey();
            HashSet roleNames = (HashSet)entry.getValue();
            if (relationTypeName != null && !this.typeNamesById.get(relationId).equals(relationTypeName)) continue;
            ArrayList<String> resultRoleNames = new ArrayList<String>();
            if (roleName == null) {
                resultRoleNames.addAll(roleNames);
            } else if (roleNames.contains(roleName) && !resultRoleNames.contains(roleName)) {
                resultRoleNames.add(roleName);
            }
            if (resultRoleNames.size() <= 0) continue;
            result.put(relationId, resultRoleNames);
        }
        return result;
    }

    public List findRelationsOfType(String relationTypeName) throws IllegalArgumentException, RelationTypeNotFoundException {
        if (relationTypeName == null) {
            throw new IllegalArgumentException("null relation type name");
        }
        if (!this.typesByName.containsKey(relationTypeName)) {
            throw new RelationTypeNotFoundException("relation type name not found");
        }
        ArrayList result = new ArrayList();
        Iterator iterator = this.typeNamesById.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String typeName = (String)entry.getValue();
            if (!typeName.equals(relationTypeName)) continue;
            result.add(entry.getKey());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getAllRelationIds() {
        ArrayList result = new ArrayList(this.relationsById.size());
        HashMap hashMap = this.relationsById;
        synchronized (hashMap) {
            Iterator iterator = this.relationsById.keySet().iterator();
            while (iterator.hasNext()) {
                result.add(iterator.next());
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getAllRelationTypeNames() {
        ArrayList result = new ArrayList(this.typesByName.size());
        HashMap hashMap = this.typesByName;
        synchronized (hashMap) {
            Iterator iterator = this.typesByName.keySet().iterator();
            while (iterator.hasNext()) {
                result.add(iterator.next());
            }
        }
        return result;
    }

    public RoleResult getAllRoles(String relationId) throws IllegalArgumentException, RelationNotFoundException, RelationServiceNotRegisteredException {
        this.isActive();
        Object relation = this.retrieveRelationForId(relationId);
        if (relation instanceof RelationSupport) {
            return ((RelationSupport)relation).getAllRoles();
        }
        ObjectName objectName = (ObjectName)relation;
        try {
            return (RoleResult)this.server.getAttribute(objectName, "AllRoles");
        }
        catch (InstanceNotFoundException e) {
            throw new RelationNotFoundException(objectName.toString());
        }
        catch (Exception e) {
            throw new RuntimeException(e.toString());
        }
    }

    public boolean getPurgeFlag() {
        return this.purgeFlag;
    }

    public Map getReferencedMBeans(String relationId) throws IllegalArgumentException, RelationNotFoundException {
        Object relation = this.retrieveRelationForId(relationId);
        if (relation instanceof RelationSupport) {
            return ((RelationSupport)relation).getReferencedMBeans();
        }
        ObjectName objectName = (ObjectName)relation;
        try {
            return (Map)this.server.getAttribute(objectName, "ReferencedMBeans");
        }
        catch (InstanceNotFoundException e) {
            throw new RelationNotFoundException(objectName.toString());
        }
        catch (Exception e) {
            throw new RuntimeException(e.toString());
        }
    }

    public String getRelationTypeName(String relationId) throws IllegalArgumentException, RelationNotFoundException {
        return this.retrieveTypeNameForId(relationId);
    }

    public List getRole(String relationId, String roleName) throws IllegalArgumentException, RelationNotFoundException, RelationServiceNotRegisteredException, RoleNotFoundException {
        if (roleName == null) {
            throw new IllegalArgumentException("null role");
        }
        this.isActive();
        Object relation = this.retrieveRelationForId(relationId);
        if (relation instanceof RelationSupport) {
            return ((RelationSupport)relation).getRole(roleName);
        }
        ObjectName objectName = (ObjectName)relation;
        try {
            List result = (List)this.server.invoke(objectName, "getRole", new Object[]{roleName}, new String[]{"java.lang.String"});
            return result;
        }
        catch (InstanceNotFoundException e) {
            throw new RelationNotFoundException(objectName.toString());
        }
        catch (MBeanException mbe) {
            Exception e = mbe.getTargetException();
            if (e instanceof RoleNotFoundException) {
                throw (RoleNotFoundException)e;
            }
            throw new RuntimeException(e.toString());
        }
        catch (ReflectionException e) {
            throw new RuntimeException(e.toString());
        }
    }

    public Integer getRoleCardinality(String relationId, String roleName) throws IllegalArgumentException, RelationNotFoundException, RoleNotFoundException {
        if (roleName == null) {
            throw new IllegalArgumentException("null role");
        }
        Object relation = this.retrieveRelationForId(relationId);
        if (relation instanceof RelationSupport) {
            return ((RelationSupport)relation).getRoleCardinality(roleName);
        }
        ObjectName objectName = (ObjectName)relation;
        try {
            Integer result = (Integer)this.server.invoke(objectName, "getRoleCardinality", new Object[]{roleName}, new String[]{"java.lang.String"});
            return result;
        }
        catch (InstanceNotFoundException e) {
            throw new RelationNotFoundException(objectName.toString());
        }
        catch (MBeanException mbe) {
            Exception e = mbe.getTargetException();
            if (e instanceof RoleNotFoundException) {
                throw (RoleNotFoundException)e;
            }
            throw new RuntimeException(e.toString());
        }
        catch (ReflectionException e) {
            throw new RuntimeException(e.toString());
        }
    }

    public RoleInfo getRoleInfo(String relationTypeName, String roleInfoName) throws IllegalArgumentException, RelationTypeNotFoundException, RoleInfoNotFoundException {
        RelationType relationType = this.retrieveRelationTypeForName(relationTypeName);
        return relationType.getRoleInfo(roleInfoName);
    }

    public List getRoleInfos(String relationTypeName) throws IllegalArgumentException, RelationTypeNotFoundException {
        RelationType relationType = this.retrieveRelationTypeForName(relationTypeName);
        return relationType.getRoleInfos();
    }

    public RoleResult getRoles(String relationId, String[] roleNames) throws IllegalArgumentException, RelationNotFoundException, RelationServiceNotRegisteredException {
        if (roleNames == null) {
            throw new IllegalArgumentException("null role names");
        }
        this.isActive();
        Object relation = this.retrieveRelationForId(relationId);
        if (relation instanceof RelationSupport) {
            return ((RelationSupport)relation).getRoles(roleNames);
        }
        ObjectName objectName = (ObjectName)relation;
        try {
            RoleResult result = (RoleResult)this.server.invoke(objectName, "getRoles", new Object[]{roleNames}, new String[]{new String[0].getClass().getName()});
            return result;
        }
        catch (InstanceNotFoundException e) {
            throw new RelationNotFoundException(objectName.toString());
        }
        catch (MBeanException e) {
            throw new RuntimeException(e.toString());
        }
        catch (ReflectionException e) {
            throw new RuntimeException(e.toString());
        }
    }

    public Boolean hasRelation(String relationId) throws IllegalArgumentException {
        if (relationId == null) {
            throw new IllegalArgumentException("null relation id");
        }
        return new Boolean(this.relationsById.get(relationId) != null);
    }

    public void isActive() throws RelationServiceNotRegisteredException {
        if (this.server == null) {
            throw new RelationServiceNotRegisteredException("Not registered");
        }
    }

    public String isRelation(ObjectName objectName) throws IllegalArgumentException {
        if (objectName == null) {
            throw new IllegalArgumentException("null object name");
        }
        return (String)this.idsByRelation.get(objectName);
    }

    public ObjectName isRelationMBean(String relationId) throws IllegalArgumentException, RelationNotFoundException {
        if (relationId == null) {
            throw new IllegalArgumentException("null relation id");
        }
        Object result = this.relationsById.get(relationId);
        if (result == null) {
            throw new RelationNotFoundException(relationId);
        }
        if (result instanceof ObjectName) {
            return (ObjectName)result;
        }
        return null;
    }

    public void purgeRelations() throws RelationServiceNotRegisteredException {
        this.isActive();
        while (!this.unregistered.empty()) {
            String relationId;
            Map.Entry entry;
            ObjectName mbean = (ObjectName)this.unregistered.pop();
            HashMap<String, String> relationRoles = new HashMap<String, String>();
            HashMap idRolesMap = (HashMap)this.idRolesMapByMBean.get(mbean);
            Iterator iterator = idRolesMap.entrySet().iterator();
            while (iterator.hasNext()) {
                entry = iterator.next();
                relationId = (String)entry.getKey();
                HashSet roleNames = (HashSet)entry.getValue();
                Iterator inner = roleNames.iterator();
                while (inner.hasNext()) {
                    String roleName = (String)inner.next();
                    relationRoles.put(relationId, roleName);
                }
            }
            iterator = relationRoles.entrySet().iterator();
            while (iterator.hasNext()) {
                int minDegree;
                RoleInfo roleInfo;
                Integer cardinality;
                entry = iterator.next();
                relationId = (String)entry.getKey();
                String roleName = (String)entry.getValue();
                Object relation = this.relationsById.get(relationId);
                String typeName = (String)this.typeNamesById.get(relationId);
                RelationType relationType = (RelationType)this.typesByName.get(typeName);
                if (relation instanceof RelationSupport) {
                    RelationSupport support = (RelationSupport)relation;
                    try {
                        cardinality = support.getRoleCardinality(roleName);
                        roleInfo = relationType.getRoleInfo(roleName);
                        minDegree = roleInfo.getMinDegree();
                        if (cardinality == minDegree) {
                            this.removeRelation(relationId);
                            continue;
                        }
                        support.handleMBeanUnregistration(mbean, roleName);
                    }
                    catch (Exception e) {
                        log.debug("Error during purge", e);
                    }
                    continue;
                }
                try {
                    ObjectName objectName = (ObjectName)relation;
                    cardinality = (Integer)this.server.invoke(objectName, "getRoleCardinality", new Object[]{roleName}, new String[]{"java.lang.String"});
                    roleInfo = relationType.getRoleInfo(roleName);
                    minDegree = roleInfo.getMinDegree();
                    if (cardinality == minDegree) {
                        this.removeRelation(relationId);
                        continue;
                    }
                    this.server.invoke(objectName, "handleMBeanUnregistration", new Object[]{mbean, roleName}, new String[]{"java.lang.String", "java.lang.String "});
                }
                catch (MBeanException mbe) {
                    log.debug("Error during purge", mbe.getTargetException());
                }
                catch (Exception e) {
                    log.debug("Error during purge", e);
                }
            }
        }
    }

    public synchronized void removeRelation(String relationId) throws IllegalArgumentException, RelationNotFoundException, RelationServiceNotRegisteredException {
        this.isActive();
        ArrayList unregMBeans = new ArrayList(this.getReferencedMBeans(relationId).keySet());
        Iterator iterator = unregMBeans.iterator();
        while (iterator.hasNext()) {
            ObjectName mbean = (ObjectName)iterator.next();
            HashMap idRolesMap = (HashMap)this.idRolesMapByMBean.get(mbean);
            idRolesMap.remove(relationId);
            if (idRolesMap.size() == 0) {
                this.idRolesMapByMBean.remove(mbean);
            }
            if (this.idsByRelation.containsKey(mbean)) continue;
            iterator.remove();
        }
        this.sendRelationRemovalNotification(relationId, unregMBeans);
        Object relation = this.retrieveRelationForId(relationId);
        this.relationsById.remove(relationId);
        this.idsByRelation.remove(relation);
        this.typeNamesById.remove(relationId);
        if (relation instanceof ObjectName) {
            try {
                Attribute attribute = new Attribute("RelationServiceManagementFlag", new Boolean(false));
                this.server.setAttribute((ObjectName)relation, attribute);
            }
            catch (Exception doesntImplementRelationSupportMBean) {
                // empty catch block
            }
            this.filter.disableObjectName((ObjectName)relation);
        }
    }

    public synchronized void removeRelationType(String relationTypeName) throws IllegalArgumentException, RelationTypeNotFoundException, RelationServiceNotRegisteredException {
        if (relationTypeName == null) {
            throw new IllegalArgumentException("null relation type name");
        }
        this.isActive();
        if (!this.typesByName.containsKey(relationTypeName)) {
            throw new RelationTypeNotFoundException("relation type name not found");
        }
        ArrayList ids = new ArrayList();
        Iterator iterator = this.typeNamesById.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (!entry.getValue().equals(relationTypeName)) continue;
            ids.add(entry.getKey());
        }
        iterator = ids.iterator();
        while (iterator.hasNext()) {
            try {
                this.removeRelation((String)((Object)iterator.next()));
            }
            catch (RelationNotFoundException ignored) {}
        }
        this.typesByName.remove(relationTypeName);
    }

    public void sendRelationCreationNotification(String relationId) throws IllegalArgumentException, RelationNotFoundException {
        String type = null;
        String description = null;
        if (this.relationsById.get(relationId) instanceof RelationSupport) {
            type = "jmx.relation.creation.basic";
            description = "Creation of internal relation.";
        } else {
            type = "jmx.relation.creation.mbean";
            description = "Creation of external relation.";
        }
        this.sendNotification(type, description, relationId, null, null, null);
    }

    public void sendRelationRemovalNotification(String relationId, List unregMBeans) throws IllegalArgumentException, RelationNotFoundException {
        String type = null;
        String description = null;
        if (this.relationsById.get(relationId) instanceof RelationSupport) {
            type = "jmx.relation.removal.basic";
            description = "Removal of internal relation.";
        } else {
            type = "jmx.relation.removal.mbean";
            description = "Removal of external relation.";
        }
        this.sendNotification(type, description, relationId, unregMBeans, null, null);
    }

    public void sendRoleUpdateNotification(String relationId, Role newRole, List oldRoleValue) throws IllegalArgumentException, RelationNotFoundException {
        String type = null;
        String description = null;
        if (this.relationsById.get(relationId) instanceof RelationSupport) {
            type = "jmx.relation.update.basic";
            description = "Update of internal relation.";
        } else {
            type = "jmx.relation.update.mbean";
            description = "Update of external relation.";
        }
        if (newRole == null) {
            throw new IllegalArgumentException("null role");
        }
        if (oldRoleValue == null) {
            throw new IllegalArgumentException("null old role value");
        }
        this.sendNotification(type, description, relationId, null, newRole, oldRoleValue);
    }

    public void setPurgeFlag(boolean value) {
        this.purgeFlag = value;
    }

    public void setRole(String relationId, Role role) throws RelationServiceNotRegisteredException, IllegalArgumentException, RelationNotFoundException, RoleNotFoundException, InvalidRoleValueException {
        if (role == null) {
            throw new IllegalArgumentException("null role");
        }
        this.isActive();
        Object relation = this.retrieveRelationForId(relationId);
        if (relation instanceof RelationSupport) {
            try {
                ((RelationSupport)relation).setRole(role);
            }
            catch (RelationTypeNotFoundException e) {
                RelationNotFoundException rnfe = new RelationNotFoundException(e.getMessage());
                rnfe.initCause(e);
                throw rnfe;
            }
        }
        ObjectName objectName = (ObjectName)relation;
        try {
            this.server.setAttribute(objectName, new Attribute("Role", role));
        }
        catch (InstanceNotFoundException e) {
            throw new RelationNotFoundException(objectName.toString());
        }
        catch (MBeanException mbe) {
            Exception e = mbe.getTargetException();
            if (e instanceof RoleNotFoundException) {
                throw (RoleNotFoundException)e;
            }
            if (e instanceof InvalidRoleValueException) {
                throw (InvalidRoleValueException)e;
            }
            throw new RuntimeException(e.toString());
        }
        catch (AttributeNotFoundException e) {
            throw new RuntimeException(e.toString());
        }
        catch (InvalidAttributeValueException e) {
            throw new RuntimeException(e.toString());
        }
        catch (ReflectionException e) {
            throw new RuntimeException(e.toString());
        }
    }

    public RoleResult setRoles(String relationId, RoleList roles) throws IllegalArgumentException, RelationServiceNotRegisteredException, RelationNotFoundException {
        if (roles == null) {
            throw new IllegalArgumentException("null roles");
        }
        this.isActive();
        Object relation = this.retrieveRelationForId(relationId);
        if (relation instanceof RelationSupport) {
            try {
                return ((RelationSupport)relation).setRoles(roles);
            }
            catch (RelationTypeNotFoundException e) {
                throw new RuntimeException(e.toString());
            }
        }
        ObjectName objectName = (ObjectName)relation;
        try {
            RoleResult result = (RoleResult)this.server.invoke(objectName, "setRoles", new Object[]{roles}, new String[]{"javax.management.relation.RoleList"});
            return result;
        }
        catch (InstanceNotFoundException e) {
            throw new RelationNotFoundException(objectName.toString());
        }
        catch (MBeanException e) {
            throw new RuntimeException(e.getTargetException().toString());
        }
        catch (ReflectionException e) {
            throw new RuntimeException(e.toString());
        }
    }

    public void updateRoleMap(String relationId, Role newRole, List oldRoleValue) throws IllegalArgumentException, RelationServiceNotRegisteredException, RelationNotFoundException {
        HashSet<String> roleNames;
        HashMap idRolesMap;
        ObjectName objectName;
        if (relationId == null) {
            throw new IllegalArgumentException("null relation id");
        }
        if (newRole == null) {
            throw new IllegalArgumentException("null role");
        }
        if (oldRoleValue == null) {
            throw new IllegalArgumentException("null old role value");
        }
        this.isActive();
        if (!this.relationsById.containsKey(relationId)) {
            throw new RelationNotFoundException("Invalid relation id: " + relationId);
        }
        String roleName = newRole.getRoleName();
        ArrayList newRoleValue = (ArrayList)newRole.getRoleValue();
        Iterator iterator = oldRoleValue.iterator();
        while (iterator.hasNext()) {
            objectName = (ObjectName)iterator.next();
            if (newRoleValue.contains(objectName)) continue;
            idRolesMap = (HashMap)this.idRolesMapByMBean.get(objectName);
            roleNames = (HashSet<String>)idRolesMap.get(relationId);
            roleNames.remove(roleName);
            if (roleNames.size() != 0) continue;
            idRolesMap.remove(relationId);
            if (idRolesMap.size() != 0) continue;
            this.idRolesMapByMBean.remove(objectName);
            this.filter.disableObjectName(objectName);
        }
        iterator = newRoleValue.iterator();
        while (iterator.hasNext()) {
            objectName = (ObjectName)iterator.next();
            idRolesMap = (HashMap)this.idRolesMapByMBean.get(objectName);
            if (idRolesMap == null) {
                idRolesMap = new HashMap();
                this.idRolesMapByMBean.put(objectName, idRolesMap);
                this.filter.enableObjectName(objectName);
            }
            if ((roleNames = (HashSet)idRolesMap.get(relationId)) == null) {
                roleNames = new HashSet<String>();
                idRolesMap.put(relationId, roleNames);
            }
            if (roleNames.contains(roleName)) continue;
            roleNames.add(roleName);
        }
    }

    public ObjectName preRegister(MBeanServer server, ObjectName objectName) throws Exception {
        this.server = server;
        this.relationService = objectName;
        this.filter = new MBeanServerNotificationFilter();
        this.filter.enableType("JMX.mbean.unregistered");
        this.filter.disableAllObjectNames();
        this.delegate = new ObjectName("JMImplementation:type=MBeanServerDelegate");
        server.addNotificationListener(this.delegate, this, (NotificationFilter)this.filter, null);
        return objectName;
    }

    public void postRegister(Boolean registered) {
    }

    public void preDeregister() throws Exception {
    }

    public void postDeregister() {
        try {
            this.server.removeNotificationListener(this.delegate, this);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.server = null;
    }

    public void handleNotification(Notification notification, Object handback) {
        if (notification == null || !(notification instanceof MBeanServerNotification)) {
            return;
        }
        MBeanServerNotification mbsn = (MBeanServerNotification)notification;
        if (!mbsn.getType().equals("JMX.mbean.unregistered")) {
            return;
        }
        ObjectName objectName = mbsn.getMBeanName();
        this.unregistered.push(objectName);
        try {
            if (this.purgeFlag) {
                this.purgeRelations();
            }
        }
        catch (Exception ignored) {
            // empty catch block
        }
        try {
            String relationId = (String)this.idsByRelation.get(objectName);
            if (relationId != null) {
                this.removeRelation(relationId);
            }
        }
        catch (Exception ignored) {
            // empty catch block
        }
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        MBeanNotificationInfo[] result = new MBeanNotificationInfo[1];
        String[] types = new String[]{"jmx.relation.creation.basic", "jmx.relation.removal.basic", "jmx.relation.update.basic", "jmx.relation.creation.mbean", "jmx.relation.removal.mbean", "jmx.relation.update.mbean"};
        result[0] = new MBeanNotificationInfo(types, "javax.management.relation.RelationNotification", "Notifications sent by the Relation Service MBean");
        return result;
    }

    private void createMissingRoles(String relationTypeName, RoleList roleList) throws RelationTypeNotFoundException {
        if (relationTypeName == null) {
            throw new RelationTypeNotFoundException("RelationType name null not found");
        }
        RelationType relationType = this.retrieveRelationTypeForName(relationTypeName);
        ArrayList roleInfos = (ArrayList)relationType.getRoleInfos();
        Iterator iterator = roleInfos.iterator();
        while (iterator.hasNext()) {
            RoleInfo roleInfo = (RoleInfo)iterator.next();
            boolean found = false;
            Iterator inner = roleList.iterator();
            while (inner.hasNext()) {
                Role role = (Role)inner.next();
                if (!role.getRoleName().equals(roleInfo.getName())) continue;
                found = true;
                break;
            }
            if (found) continue;
            roleList.add(new Role(roleInfo.getName(), new RoleList()));
        }
    }

    private Object retrieveRelationForId(String relationId) throws IllegalArgumentException, RelationNotFoundException {
        if (relationId == null) {
            throw new IllegalArgumentException("null relation id");
        }
        Object result = this.relationsById.get(relationId);
        if (result == null) {
            throw new RelationNotFoundException(relationId);
        }
        return result;
    }

    private String retrieveTypeNameForId(String relationId) throws IllegalArgumentException, RelationNotFoundException {
        if (relationId == null) {
            throw new IllegalArgumentException("null relation id");
        }
        String result = (String)this.typeNamesById.get(relationId);
        if (result == null) {
            throw new RelationNotFoundException(relationId);
        }
        return result;
    }

    private RelationType retrieveRelationTypeForName(String relationTypeName) throws IllegalArgumentException, RelationTypeNotFoundException {
        if (relationTypeName == null) {
            throw new IllegalArgumentException("Null relation type name");
        }
        RelationType result = (RelationType)this.typesByName.get(relationTypeName);
        if (result == null) {
            throw new RelationTypeNotFoundException(relationTypeName);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendNotification(String type, String description, String relationId, List unregMBeans, Role newRole, List oldRoleValue) throws IllegalArgumentException, RelationNotFoundException {
        long sequence;
        if (type == null) {
            throw new IllegalArgumentException("null notification type");
        }
        String typeName = this.retrieveTypeNameForId(relationId);
        Object relation = this.retrieveRelationForId(relationId);
        ObjectName relationName = null;
        if (relation instanceof ObjectName) {
            relationName = (ObjectName)relation;
        }
        RelationService relationService = this;
        synchronized (relationService) {
            sequence = ++this.notificationSequence;
        }
        if (type.equals("jmx.relation.update.basic") || type.equals("jmx.relation.update.mbean")) {
            this.sendNotification(new RelationNotification(type, this.relationService, sequence, System.currentTimeMillis(), description, relationId, typeName, relationName, newRole.getRoleName(), newRole.getRoleValue(), oldRoleValue));
        } else {
            this.sendNotification(new RelationNotification(type, this.relationService, sequence, System.currentTimeMillis(), description, relationId, typeName, relationName, unregMBeans));
        }
    }

    private synchronized void validateAndAddRelation(String relationId, Object relation, String relationTypeName) throws InvalidRelationIdException {
        if (this.relationsById.containsKey(relationId)) {
            throw new InvalidRelationIdException(relationId);
        }
        this.relationsById.put(relationId, relation);
        this.idsByRelation.put(relation, relationId);
        this.typeNamesById.put(relationId, relationTypeName);
        RoleList roles = null;
        if (relation instanceof RelationSupport) {
            RelationSupport support = (RelationSupport)relation;
            roles = support.retrieveAllRoles();
        } else {
            try {
                roles = (RoleList)this.server.invoke((ObjectName)relation, "retrieveAllRoles", new Object[0], new String[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e.toString());
            }
        }
        Iterator iterator = roles.iterator();
        while (iterator.hasNext()) {
            Role role = (Role)iterator.next();
            try {
                this.updateRoleMap(relationId, role, role.getRoleValue());
            }
            catch (Exception e) {
                throw new RuntimeException(e.toString());
            }
        }
        if (relation instanceof RelationSupport) {
            RelationSupport support = (RelationSupport)relation;
            support.setRelationServiceManagementFlag(new Boolean(true));
        } else {
            try {
                Attribute attribute = new Attribute("RelationServiceManagementFlag", new Boolean(true));
                this.server.setAttribute((ObjectName)relation, attribute);
            }
            catch (Exception doesntImplementRelationSupportMBean) {
                // empty catch block
            }
        }
        try {
            this.sendRelationCreationNotification(relationId);
        }
        catch (RelationNotFoundException e) {
            throw new RuntimeException(e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateRelationType(RelationType relationType) throws InvalidRelationTypeException {
        HashSet<String> roleNames = new HashSet<String>();
        ArrayList roleInfos = (ArrayList)relationType.getRoleInfos();
        if (roleInfos == null) {
            throw new InvalidRelationTypeException("Null role infos");
        }
        if (roleInfos.size() == 0) {
            throw new InvalidRelationTypeException("No role infos");
        }
        ArrayList arrayList = roleInfos;
        synchronized (arrayList) {
            Iterator iterator = roleInfos.iterator();
            while (iterator.hasNext()) {
                RoleInfo roleInfo = (RoleInfo)iterator.next();
                if (roleInfo == null) {
                    throw new InvalidRelationTypeException("Null role");
                }
                if (roleNames.contains(roleInfo.getName())) {
                    throw new InvalidRelationTypeException("Duplicate role name" + roleInfo.getName());
                }
                roleNames.add(roleInfo.getName());
            }
        }
    }
}

