/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reflection.java;

import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityListeners;
import javax.persistence.NamedNativeQuery;
import javax.persistence.NamedQuery;
import javax.persistence.SequenceGenerator;
import javax.persistence.SqlResultSetMapping;
import javax.persistence.TableGenerator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Element;
import org.hibernate.reflection.ReflectionManager;
import org.hibernate.reflection.XClass;
import org.hibernate.reflection.XMethod;
import org.hibernate.reflection.XPackage;
import org.hibernate.reflection.XProperty;
import org.hibernate.reflection.java.EJB3OverridenAnnotationReader;
import org.hibernate.reflection.java.JavaXAnnotatedElement;
import org.hibernate.reflection.java.JavaXArrayType;
import org.hibernate.reflection.java.JavaXClass;
import org.hibernate.reflection.java.JavaXCollectionType;
import org.hibernate.reflection.java.JavaXMethod;
import org.hibernate.reflection.java.JavaXPackage;
import org.hibernate.reflection.java.JavaXProperty;
import org.hibernate.reflection.java.JavaXSimpleType;
import org.hibernate.reflection.java.JavaXType;
import org.hibernate.reflection.java.Pair;
import org.hibernate.reflection.java.generics.IdentityTypeEnvironment;
import org.hibernate.reflection.java.generics.TypeEnvironment;
import org.hibernate.reflection.java.generics.TypeEnvironmentFactory;
import org.hibernate.reflection.java.generics.TypeSwitch;
import org.hibernate.reflection.java.generics.TypeUtils;
import org.hibernate.reflection.java.xml.XMLContext;
import org.hibernate.util.ReflectHelper;

public class JavaXFactory
implements ReflectionManager {
    private static Log log = LogFactory.getLog(JavaXFactory.class);
    private XMLContext xmlContext;
    private HashMap defaults;
    private final Map<TypeKey, JavaXClass> xClasses = new HashMap<TypeKey, JavaXClass>();
    private final Map<Package, JavaXPackage> packagesToXPackages = new HashMap<Package, JavaXPackage>();
    private final Map<MemberKey, JavaXProperty> xProperties = new HashMap<MemberKey, JavaXProperty>();
    private final Map<MemberKey, JavaXMethod> xMethods = new HashMap<MemberKey, JavaXMethod>();
    private final TypeEnvironmentFactory typeEnvs = new TypeEnvironmentFactory();

    public JavaXFactory() {
        this.reset();
    }

    public void reset() {
        this.xmlContext = new XMLContext();
        this.xClasses.clear();
        this.packagesToXPackages.clear();
        this.xProperties.clear();
        this.xMethods.clear();
        this.defaults = null;
    }

    public XClass toXClass(Class clazz) {
        return this.toXClass(clazz, IdentityTypeEnvironment.INSTANCE);
    }

    public Class toClass(XClass xClazz) {
        if (!(xClazz instanceof JavaXClass)) {
            throw new IllegalArgumentException("XClass not coming from this ReflectionManager implementation");
        }
        return (Class)((JavaXClass)xClazz).toAnnotatedElement();
    }

    public Method toMethod(XMethod xMethod) {
        if (!(xMethod instanceof JavaXMethod)) {
            throw new IllegalArgumentException("XMethod not coming from this ReflectionManager implementation");
        }
        return (Method)((JavaXAnnotatedElement)((Object)xMethod)).toAnnotatedElement();
    }

    public XClass classForName(String name, Class caller) throws ClassNotFoundException {
        return this.toXClass(ReflectHelper.classForName(name, caller));
    }

    public XPackage packageForName(String packageName) throws ClassNotFoundException {
        return this.getXAnnotatedElement(ReflectHelper.classForName(packageName + ".package-info").getPackage());
    }

    public Map getDefaults() {
        if (this.defaults == null) {
            this.defaults = new HashMap();
            XMLContext.Default xmlDefaults = this.xmlContext.getDefault(null);
            ArrayList<Class> entityListeners = new ArrayList<Class>();
            for (String className : this.xmlContext.getDefaultEntityListeners()) {
                try {
                    entityListeners.add(ReflectHelper.classForName(className, this.getClass()));
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalStateException("Default entity listener class not found: " + className);
                }
            }
            this.defaults.put(EntityListeners.class, entityListeners);
            for (Element element : this.xmlContext.getAllDocuments()) {
                List elements = element.elements("sequence-generator");
                ArrayList<SequenceGenerator> sequenceGenerators = (ArrayList<SequenceGenerator>)this.defaults.get(SequenceGenerator.class);
                if (sequenceGenerators == null) {
                    sequenceGenerators = new ArrayList<SequenceGenerator>();
                    this.defaults.put(SequenceGenerator.class, sequenceGenerators);
                }
                for (Element subelement : elements) {
                    sequenceGenerators.add(EJB3OverridenAnnotationReader.buildSequenceGeneratorAnnotation(subelement));
                }
                elements = element.elements("table-generator");
                ArrayList<TableGenerator> tableGenerators = (ArrayList<TableGenerator>)this.defaults.get(TableGenerator.class);
                if (tableGenerators == null) {
                    tableGenerators = new ArrayList<TableGenerator>();
                    this.defaults.put(TableGenerator.class, tableGenerators);
                }
                for (Element subelement : elements) {
                    tableGenerators.add(EJB3OverridenAnnotationReader.buildTableGeneratorAnnotation(subelement, xmlDefaults));
                }
                ArrayList namedQueries = (ArrayList)this.defaults.get(NamedQuery.class);
                if (namedQueries == null) {
                    namedQueries = new ArrayList();
                    this.defaults.put(NamedQuery.class, namedQueries);
                }
                List currentNamedQueries = EJB3OverridenAnnotationReader.buildNamedQueries(element, false);
                namedQueries.addAll(currentNamedQueries);
                ArrayList namedNativeQueries = (ArrayList)this.defaults.get(NamedNativeQuery.class);
                if (namedNativeQueries == null) {
                    namedNativeQueries = new ArrayList();
                    this.defaults.put(NamedNativeQuery.class, namedNativeQueries);
                }
                List currentNamedNativeQueries = EJB3OverridenAnnotationReader.buildNamedQueries(element, true);
                namedNativeQueries.addAll(currentNamedNativeQueries);
                ArrayList<SqlResultSetMapping> sqlResultSetMappings = (ArrayList<SqlResultSetMapping>)this.defaults.get(SqlResultSetMapping.class);
                if (sqlResultSetMappings == null) {
                    sqlResultSetMappings = new ArrayList<SqlResultSetMapping>();
                    this.defaults.put(SqlResultSetMapping.class, sqlResultSetMappings);
                }
                List<SqlResultSetMapping> currentSqlResultSetMappings = EJB3OverridenAnnotationReader.buildSqlResultsetMappings(element, xmlDefaults);
                sqlResultSetMappings.addAll(currentSqlResultSetMappings);
            }
        }
        return this.defaults;
    }

    XClass toXClass(Type t, final TypeEnvironment context) {
        return (XClass)new TypeSwitch<XClass>(){

            @Override
            public XClass caseClass(Class classType) {
                TypeKey key = new TypeKey(classType, context);
                JavaXClass result = (JavaXClass)JavaXFactory.this.xClasses.get(key);
                if (result == null) {
                    result = new JavaXClass(classType, context, JavaXFactory.this);
                    JavaXFactory.this.xClasses.put(key, result);
                }
                return result;
            }

            @Override
            public XClass caseParameterizedType(ParameterizedType parameterizedType) {
                return JavaXFactory.this.toXClass(parameterizedType.getRawType(), context);
            }
        }.doSwitch(context.bind(t));
    }

    XPackage getXAnnotatedElement(Package pkg) {
        JavaXPackage xPackage = this.packagesToXPackages.get(pkg);
        if (xPackage == null) {
            xPackage = new JavaXPackage(pkg, this);
            this.packagesToXPackages.put(pkg, xPackage);
        }
        return xPackage;
    }

    XProperty getXProperty(Member member, JavaXClass owner) {
        MemberKey key = new MemberKey(member, owner.toClass(), owner.getTypeEnvironment());
        JavaXProperty xProperty = this.xProperties.get(key);
        if (!this.xProperties.containsKey(key)) {
            xProperty = JavaXProperty.create(member, owner.getTypeEnvironment(), this);
            this.xProperties.put(key, xProperty);
        }
        return xProperty;
    }

    XMethod getXMethod(Member member, JavaXClass owner) {
        MemberKey key = new MemberKey(member, owner.toClass(), owner.getTypeEnvironment());
        JavaXMethod xMethod = this.xMethods.get(key);
        if (!this.xMethods.containsKey(key)) {
            xMethod = JavaXMethod.create(member, owner.getTypeEnvironment(), this);
            this.xMethods.put(key, xMethod);
        }
        return xMethod;
    }

    TypeEnvironment getTypeEnvironment(Type t) {
        return (TypeEnvironment)new TypeSwitch<TypeEnvironment>(){

            @Override
            public TypeEnvironment caseClass(Class classType) {
                return JavaXFactory.this.typeEnvs.getEnvironment(classType);
            }

            @Override
            public TypeEnvironment caseParameterizedType(ParameterizedType parameterizedType) {
                return JavaXFactory.this.typeEnvs.getEnvironment(parameterizedType);
            }

            @Override
            public TypeEnvironment defaultCase(Type type) {
                return IdentityTypeEnvironment.INSTANCE;
            }
        }.doSwitch(t);
    }

    public JavaXType toXType(TypeEnvironment context, Type propType) {
        Type boundType = this.toApproximatingEnvironment(context).bind(propType);
        if (TypeUtils.isArray(boundType)) {
            return new JavaXArrayType(propType, context, this);
        }
        if (TypeUtils.isCollection(boundType)) {
            return new JavaXCollectionType(propType, context, this);
        }
        if (TypeUtils.isSimple(boundType)) {
            return new JavaXSimpleType(propType, context, this);
        }
        throw new IllegalArgumentException("No PropertyTypeExtractor available for type void ");
    }

    public boolean equals(XClass class1, Class class2) {
        if (class1 == null) {
            return class2 == null;
        }
        return ((JavaXClass)class1).toClass().equals(class2);
    }

    public TypeEnvironment toApproximatingEnvironment(TypeEnvironment context) {
        return this.typeEnvs.toApproximatingEnvironment(context);
    }

    public XMLContext getXMLContext() {
        return this.xmlContext;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MemberKey
    extends Pair<Member, TypeKey> {
        MemberKey(Member member, Type owner, TypeEnvironment context) {
            super(member, new TypeKey(owner, context));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TypeKey
    extends Pair<Type, TypeEnvironment> {
        TypeKey(Type t, TypeEnvironment context) {
            super(t, context);
        }
    }
}

