/*
 * Decompiled with CFR 0.152.
 */
package brave.kafka.clients;

import brave.Span;
import brave.SpanCustomizer;
import brave.Tracing;
import brave.kafka.clients.KafkaPropagation;
import brave.kafka.clients.TracingConsumer;
import brave.kafka.clients.TracingProducer;
import brave.propagation.Propagation;
import brave.propagation.TraceContext;
import brave.propagation.TraceContextOrSamplingFlags;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;

public final class KafkaTracing {
    final Tracing tracing;
    final TraceContext.Extractor<Headers> extractor;
    final TraceContext.Injector<Headers> injector;
    final Set<String> propagationKeys;
    final String remoteServiceName;

    public static KafkaTracing create(Tracing tracing) {
        return new Builder(tracing).build();
    }

    public static Builder newBuilder(Tracing tracing) {
        return new Builder(tracing);
    }

    KafkaTracing(Builder builder) {
        this.tracing = builder.tracing;
        this.extractor = this.tracing.propagation().extractor(KafkaPropagation.GETTER);
        List keyList = builder.tracing.propagation().keys();
        if (builder.writeB3SingleFormat || keyList.equals(Propagation.B3_SINGLE_STRING.keys())) {
            TraceContext testExtraction = this.extractor.extract((Object)KafkaPropagation.B3_SINGLE_TEST_HEADERS).context();
            if (!KafkaPropagation.TEST_CONTEXT.equals((Object)testExtraction)) {
                throw new IllegalArgumentException("KafkaTracing.Builder.writeB3SingleFormat set, but Tracing.Builder.propagationFactory cannot parse this format!");
            }
            this.injector = KafkaPropagation.B3_SINGLE_INJECTOR;
        } else {
            this.injector = this.tracing.propagation().injector(KafkaPropagation.SETTER);
        }
        this.propagationKeys = new LinkedHashSet<String>(keyList);
        this.remoteServiceName = builder.remoteServiceName;
    }

    public <K, V> Consumer<K, V> consumer(Consumer<K, V> consumer) {
        return new TracingConsumer<K, V>(consumer, this);
    }

    public <K, V> Producer<K, V> producer(Producer<K, V> producer) {
        return new TracingProducer<K, V>(producer, this);
    }

    public Span nextSpan(ConsumerRecord<?, ?> record) {
        TraceContextOrSamplingFlags extracted = this.extractAndClearHeaders(record.headers());
        Span result = this.tracing.tracer().nextSpan(extracted);
        if (extracted.context() == null && !result.isNoop()) {
            KafkaTracing.addTags(record, (SpanCustomizer)result);
        }
        return result;
    }

    TraceContextOrSamplingFlags extractAndClearHeaders(Headers headers) {
        TraceContextOrSamplingFlags extracted = this.extractor.extract((Object)headers);
        if (!extracted.equals((Object)TraceContextOrSamplingFlags.EMPTY)) {
            this.clearHeaders(headers);
        }
        return extracted;
    }

    void clearHeaders(Headers headers) {
        Iterator i = headers.iterator();
        while (i.hasNext()) {
            Header next = (Header)i.next();
            if (!this.propagationKeys.contains(next.key())) continue;
            i.remove();
        }
    }

    static void addTags(ConsumerRecord<?, ?> record, SpanCustomizer result) {
        if (record.key() instanceof String && !"".equals(record.key())) {
            result.tag("kafka.key", record.key().toString());
        }
        result.tag("kafka.topic", record.topic());
    }

    public static final class Builder {
        final Tracing tracing;
        String remoteServiceName = "kafka";
        boolean writeB3SingleFormat;

        Builder(Tracing tracing) {
            if (tracing == null) {
                throw new NullPointerException("tracing == null");
            }
            this.tracing = tracing;
        }

        public Builder remoteServiceName(String remoteServiceName) {
            this.remoteServiceName = remoteServiceName;
            return this;
        }

        public Builder writeB3SingleFormat(boolean writeB3SingleFormat) {
            this.writeB3SingleFormat = writeB3SingleFormat;
            return this;
        }

        public KafkaTracing build() {
            return new KafkaTracing(this);
        }
    }
}

