/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.httpproxy.impl;

import io.vertx.core.Future;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.httpproxy.Body;
import io.vertx.httpproxy.ProxyContext;
import io.vertx.httpproxy.ProxyInterceptor;
import io.vertx.httpproxy.ProxyRequest;
import io.vertx.httpproxy.ProxyResponse;
import io.vertx.httpproxy.impl.BufferingReadStream;
import io.vertx.httpproxy.impl.CacheControl;
import io.vertx.httpproxy.impl.ParseUtils;
import io.vertx.httpproxy.impl.Resource;
import io.vertx.httpproxy.spi.cache.Cache;
import java.time.Instant;
import java.util.function.BiFunction;

class CachingFilter
implements ProxyInterceptor {
    private static final BiFunction<String, Resource, Resource> CACHE_GET_AND_VALIDATE = (key, resource) -> {
        long val = resource.timestamp + resource.maxAge;
        long now = System.currentTimeMillis();
        return val < now ? null : resource;
    };
    private final Cache<String, Resource> cache;

    public CachingFilter(Cache<String, Resource> cache) {
        this.cache = cache;
    }

    @Override
    public Future<ProxyResponse> handleProxyRequest(ProxyContext context) {
        Future<ProxyResponse> future = this.tryHandleProxyRequestFromCache(context);
        if (future != null) {
            return future;
        }
        return context.sendRequest();
    }

    @Override
    public Future<Void> handleProxyResponse(ProxyContext context) {
        return this.sendAndTryCacheProxyResponse(context);
    }

    private Future<Void> sendAndTryCacheProxyResponse(ProxyContext context) {
        ProxyResponse response = context.response();
        Resource cached = context.get("cached_resource", Resource.class);
        if (cached != null && response.getStatusCode() == 304) {
            response.release();
            cached.init(response);
            return context.sendResponse();
        }
        ProxyRequest request = response.request();
        if (response.publicCacheControl() && response.maxAge() > 0L) {
            Resource resource;
            if (request.getMethod() == HttpMethod.GET) {
                String absoluteUri = request.absoluteURI();
                Resource res = new Resource(absoluteUri, response.getStatusCode(), response.getStatusMessage(), response.headers(), System.currentTimeMillis(), response.maxAge());
                Body body = response.getBody();
                response.setBody(Body.body(new BufferingReadStream(body.stream(), res.content), body.length()));
                Future<Void> fut = context.sendResponse();
                fut.onSuccess(v -> this.cache.put(absoluteUri, res));
                return fut;
            }
            if (request.getMethod() == HttpMethod.HEAD && (resource = (Resource)this.cache.get(request.absoluteURI())) != null && !CachingFilter.revalidateResource(response, resource)) {
                this.cache.remove(request.absoluteURI());
            }
            return context.sendResponse();
        }
        return context.sendResponse();
    }

    private static boolean revalidateResource(ProxyResponse response, Resource resource) {
        if (resource.etag != null && response.etag() != null) {
            return resource.etag.equals(response.etag());
        }
        return true;
    }

    private Future<ProxyResponse> tryHandleProxyRequestFromCache(ProxyContext context) {
        Instant ifModifiedSince;
        long now;
        long currentAge;
        CacheControl cacheControl;
        Resource resource;
        ProxyRequest proxyRequest = context.request();
        HttpServerRequest response = proxyRequest.proxiedRequest();
        HttpMethod method = response.method();
        if (method == HttpMethod.GET || method == HttpMethod.HEAD) {
            String cacheKey = proxyRequest.absoluteURI();
            resource = this.cache.computeIfPresent(cacheKey, CACHE_GET_AND_VALIDATE);
            if (resource == null) {
                return null;
            }
        } else {
            return null;
        }
        String cacheControlHeader = response.getHeader(HttpHeaders.CACHE_CONTROL);
        if (cacheControlHeader != null && (cacheControl = new CacheControl().parse(cacheControlHeader)).maxAge() >= 0 && (currentAge = (now = System.currentTimeMillis()) - resource.timestamp) > (long)(cacheControl.maxAge() * 1000)) {
            String etag = resource.headers.get(HttpHeaders.ETAG);
            if (etag != null) {
                proxyRequest.headers().set(HttpHeaders.IF_NONE_MATCH, (CharSequence)resource.etag);
                context.set("cached_resource", resource);
                return context.sendRequest();
            }
            return null;
        }
        String ifModifiedSinceHeader = response.getHeader(HttpHeaders.IF_MODIFIED_SINCE);
        if (!(response.method() != HttpMethod.GET && response.method() != HttpMethod.HEAD || ifModifiedSinceHeader == null || resource.lastModified == null || (ifModifiedSince = ParseUtils.parseHeaderDate(ifModifiedSinceHeader)).isAfter(resource.lastModified))) {
            response.response().setStatusCode(304).end();
            return Future.succeededFuture();
        }
        proxyRequest.release();
        ProxyResponse proxyResponse = proxyRequest.response();
        resource.init(proxyResponse);
        return Future.succeededFuture((Object)proxyResponse);
    }
}

