/*
 * Decompiled with CFR 0.152.
 */
package io.takari.maven.plugins.compile.javac;

import io.takari.incrementalbuild.BuildContext;
import io.takari.incrementalbuild.spi.DefaultBuildContext;
import io.takari.incrementalbuild.spi.DefaultOutputMetadata;
import io.takari.maven.plugins.compile.AbstractCompileMojo;
import io.takari.maven.plugins.compile.AbstractCompiler;
import io.takari.maven.plugins.compile.javac.ProjectClasspathDigester;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbstractCompilerJavac
extends AbstractCompiler {
    private final ProjectClasspathDigester digester;
    protected final List<BuildContext.InputMetadata<File>> sources = new ArrayList<BuildContext.InputMetadata<File>>();
    private String classpath;

    protected AbstractCompilerJavac(DefaultBuildContext<?> context, ProjectClasspathDigester digester) {
        super(context);
        this.digester = digester;
    }

    protected List<String> getCompilerOptions() {
        Set<AbstractCompileMojo.Debug> debug;
        ArrayList<String> options = new ArrayList<String>();
        options.add("-d");
        options.add(this.getOutputDirectory().getAbsolutePath());
        options.add("-source");
        options.add(this.getSource());
        if (this.getTarget() != null) {
            options.add("-target");
            options.add(this.getTarget());
        }
        options.add("-classpath");
        options.add(this.classpath);
        options.add("-implicit:none");
        switch (this.getProc()) {
            case only: {
                options.add("-proc:only");
                break;
            }
            case proc: {
                break;
            }
            case none: {
                options.add("-proc:none");
            }
        }
        if (this.getProc() != AbstractCompileMojo.Proc.none) {
            options.add("-s");
            options.add(this.getGeneratedSourcesDirectory().getAbsolutePath());
            if (this.getAnnotationProcessors() != null) {
                options.add("-processor");
                StringBuilder processors = new StringBuilder();
                String[] stringArray = this.getAnnotationProcessors();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String processor = stringArray[n2];
                    if (processors.length() > 0) {
                        processors.append(',');
                    }
                    processors.append(processor);
                    ++n2;
                }
                options.add(processors.toString());
            }
            if (this.getAnnotationProcessorOptions() != null) {
                for (Map.Entry<String, String> option : this.getAnnotationProcessorOptions().entrySet()) {
                    options.add("-A" + option.getKey() + "=" + option.getValue());
                }
            }
        }
        if (this.isVerbose()) {
            options.add("-verbose");
        }
        if ((debug = this.getDebug()) == null || debug.contains((Object)AbstractCompileMojo.Debug.all)) {
            options.add("-g");
        } else if (debug.contains((Object)AbstractCompileMojo.Debug.none)) {
            options.add("-g:none");
        } else {
            StringBuilder keywords = new StringBuilder();
            for (AbstractCompileMojo.Debug keyword : debug) {
                if (keywords.length() > 0) {
                    keywords.append(',');
                }
                keywords.append(keyword.name());
            }
            options.add("-g:" + keywords.toString());
        }
        if (this.isShowWarnings()) {
            options.add("-Xlint:all");
        } else {
            options.add("-Xlint:none");
        }
        return options;
    }

    @Override
    public boolean setClasspath(List<File> dependencies, File mainClasses, Set<File> directDependencies) throws IOException {
        ArrayList<File> classpath = new ArrayList<File>();
        if (mainClasses != null) {
            classpath.add(mainClasses);
        }
        classpath.addAll(dependencies);
        if (this.log.isDebugEnabled()) {
            StringBuilder msg = new StringBuilder();
            for (File element : classpath) {
                msg.append("\n\u2002\u2002 ").append(element);
            }
            this.log.debug("Compile classpath: {} entries{}", (Object)classpath.size(), (Object)msg.toString());
        }
        StringBuilder cp = new StringBuilder();
        cp.append(this.getOutputDirectory().getAbsolutePath());
        for (File dependency : classpath) {
            if (dependency == null) continue;
            if (cp.length() > 0) {
                cp.append(File.pathSeparatorChar);
            }
            cp.append(dependency.getAbsolutePath());
        }
        this.classpath = cp.toString();
        return this.digester.digestDependencies(classpath);
    }

    @Override
    public boolean setSources(List<BuildContext.InputMetadata<File>> sources) {
        this.sources.addAll(sources);
        this.context.registerInput(this.getPom());
        ArrayList<BuildContext.InputMetadata<File>> modifiedSources = new ArrayList<BuildContext.InputMetadata<File>>();
        ArrayList<BuildContext.InputMetadata<File>> inputs = new ArrayList<BuildContext.InputMetadata<File>>();
        for (BuildContext.InputMetadata<File> input : sources) {
            inputs.add(input);
            if (input.getStatus() == BuildContext.ResourceStatus.UNMODIFIED) continue;
            modifiedSources.add(input);
        }
        Set deletedSources = this.context.getRemovedInputs(File.class);
        HashSet<DefaultOutputMetadata> modifiedOutputs = new HashSet<DefaultOutputMetadata>();
        for (DefaultOutputMetadata output : this.context.getProcessedOutputs()) {
            BuildContext.ResourceStatus resourceStatus = output.getStatus();
            if (resourceStatus != BuildContext.ResourceStatus.MODIFIED && resourceStatus != BuildContext.ResourceStatus.REMOVED) continue;
            modifiedOutputs.add(output);
        }
        if (!this.context.isEscalated() && this.log.isDebugEnabled()) {
            StringBuilder inputsMsg = new StringBuilder("Modified inputs:");
            for (BuildContext.InputMetadata inputMetadata : modifiedSources) {
                inputsMsg.append("\n   ").append(inputMetadata.getStatus()).append(" ").append(inputMetadata.getResource());
            }
            for (BuildContext.InputMetadata inputMetadata : deletedSources) {
                inputsMsg.append("\n   ").append(inputMetadata.getStatus()).append(" ").append(inputMetadata.getResource());
            }
            this.log.debug(inputsMsg.toString());
            if (!modifiedOutputs.isEmpty()) {
                StringBuilder stringBuilder = new StringBuilder("Modified outputs:");
                for (BuildContext.OutputMetadata outputMetadata : modifiedOutputs) {
                    stringBuilder.append("\n   ").append(outputMetadata.getStatus()).append(" ").append(outputMetadata.getResource());
                }
                this.log.debug(stringBuilder.toString());
            }
        }
        return !modifiedSources.isEmpty() || !deletedSources.isEmpty() || !modifiedOutputs.isEmpty();
    }

    @Override
    public void skipCompilation() {
        for (BuildContext.OutputMetadata output : this.context.getProcessedOutputs()) {
            if (output.getAssociatedInputs(File.class).iterator().hasNext()) continue;
            this.context.markOutputAsUptodate((File)output.getResource());
        }
    }

    protected Collection<File> getSourceFiles() {
        ArrayList<File> files = new ArrayList<File>(this.sources.size());
        for (BuildContext.InputMetadata<File> input : this.sources) {
            files.add((File)input.getResource());
        }
        return files;
    }

    @Override
    public void setPrivatePackageReference(AbstractCompileMojo.AccessRulesViolation accessRulesViolation) {
        if (accessRulesViolation == AbstractCompileMojo.AccessRulesViolation.error) {
            String msg = String.format("Compiler %s does not support privatePackageReference=error, use compilerId=%s", this.getCompilerId(), "jdt");
            throw new IllegalArgumentException(msg);
        }
    }

    @Override
    public void setTransitiveDependencyReference(AbstractCompileMojo.AccessRulesViolation accessRulesViolation) {
        if (accessRulesViolation == AbstractCompileMojo.AccessRulesViolation.error) {
            String msg = String.format("Compiler %s does not support transitiveDependencyReference=error, use compilerId=%s", this.getCompilerId(), "jdt");
            throw new IllegalArgumentException(msg);
        }
    }

    protected abstract String getCompilerId();
}

