/*
 * Decompiled with CFR 0.152.
 */
package io.takari.incrementalbuild.spi;

import io.takari.incrementalbuild.spi.Plexus_MatchPattern;
import java.io.File;
import java.util.ArrayList;

class Plexus_MatchPatterns {
    private final Plexus_MatchPattern[] patterns;

    private Plexus_MatchPatterns(Plexus_MatchPattern[] patterns) {
        this.patterns = patterns;
    }

    public boolean matches(String name, boolean isCaseSensitive) {
        String[] tokenized = Plexus_MatchPattern.tokenizePathToString(name, File.separator);
        return this.matches(name, tokenized, isCaseSensitive);
    }

    public boolean matches(String name, String[] tokenizedName, boolean isCaseSensitive) {
        char[][] tokenizedNameChar = new char[tokenizedName.length][];
        int i = 0;
        while (i < tokenizedName.length) {
            tokenizedNameChar[i] = tokenizedName[i].toCharArray();
            ++i;
        }
        Plexus_MatchPattern[] plexus_MatchPatternArray = this.patterns;
        int n = this.patterns.length;
        int n2 = 0;
        while (n2 < n) {
            Plexus_MatchPattern pattern = plexus_MatchPatternArray[n2];
            if (pattern.matchPath(name, tokenizedNameChar, isCaseSensitive)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean matchesPatternStart(String name, boolean isCaseSensitive) {
        Plexus_MatchPattern[] plexus_MatchPatternArray = this.patterns;
        int n = this.patterns.length;
        int n2 = 0;
        while (n2 < n) {
            Plexus_MatchPattern includesPattern = plexus_MatchPatternArray[n2];
            if (includesPattern.matchPatternStart(name, isCaseSensitive)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static Plexus_MatchPatterns from(String ... sources) {
        int length = sources.length;
        Plexus_MatchPattern[] result = new Plexus_MatchPattern[length];
        int i = 0;
        while (i < length) {
            result[i] = Plexus_MatchPattern.fromString(sources[i]);
            ++i;
        }
        return new Plexus_MatchPatterns(result);
    }

    public static Plexus_MatchPatterns from(Iterable<String> strings) {
        return new Plexus_MatchPatterns(Plexus_MatchPatterns.getMatchPatterns(strings));
    }

    private static Plexus_MatchPattern[] getMatchPatterns(Iterable<String> items) {
        ArrayList<Plexus_MatchPattern> result = new ArrayList<Plexus_MatchPattern>();
        for (String string : items) {
            result.add(Plexus_MatchPattern.fromString(string));
        }
        return result.toArray(new Plexus_MatchPattern[result.size()]);
    }
}

