/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.languages.html;

import io.swagger.codegen.CliOption;
import io.swagger.codegen.CodegenConfig;
import io.swagger.codegen.CodegenModel;
import io.swagger.codegen.CodegenOperation;
import io.swagger.codegen.CodegenParameter;
import io.swagger.codegen.CodegenProperty;
import io.swagger.codegen.CodegenResponse;
import io.swagger.codegen.CodegenType;
import io.swagger.codegen.SupportingFile;
import io.swagger.codegen.languages.DefaultCodegenConfig;
import io.swagger.codegen.utils.Markdown;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.MapSchema;
import io.swagger.v3.oas.models.media.Schema;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class StaticHtmlCodegen
extends DefaultCodegenConfig
implements CodegenConfig {
    protected String invokerPackage = "io.swagger.client";
    protected String groupId = "io.swagger";
    protected String artifactId = "swagger-client";
    protected String artifactVersion = "1.0.0";
    private Markdown markdownConverter = new Markdown();

    public StaticHtmlCodegen() {
        this.outputFolder = "docs";
        this.defaultIncludes = new HashSet();
        this.cliOptions.add(new CliOption("appName", "short name of the application"));
        this.cliOptions.add(new CliOption("appDescription", "description of the application"));
        this.cliOptions.add(new CliOption("infoUrl", "a URL where users can get more information about the application"));
        this.cliOptions.add(new CliOption("infoEmail", "an email address to contact for inquiries about the application"));
        this.cliOptions.add(new CliOption("licenseInfo", "a short description of the license"));
        this.cliOptions.add(new CliOption("licenseUrl", "a URL pointing to the full license"));
        this.cliOptions.add(new CliOption("invokerPackage", "root package for generated code"));
        this.cliOptions.add(new CliOption("groupId", "groupId in generated pom.xml"));
        this.cliOptions.add(new CliOption("artifactId", "artifactId in generated pom.xml"));
        this.cliOptions.add(new CliOption("artifactVersion", "artifact version in generated pom.xml"));
        this.additionalProperties.put("appName", "Swagger Sample");
        this.additionalProperties.put("appDescription", "A sample swagger server");
        this.additionalProperties.put("infoUrl", "https://helloreverb.com");
        this.additionalProperties.put("infoEmail", "hello@helloreverb.com");
        this.additionalProperties.put("licenseInfo", "All rights reserved");
        this.additionalProperties.put("licenseUrl", "http://apache.org/licenses/LICENSE-2.0.html");
        this.additionalProperties.put("invokerPackage", this.invokerPackage);
        this.additionalProperties.put("groupId", this.groupId);
        this.additionalProperties.put("artifactId", this.artifactId);
        this.additionalProperties.put("artifactVersion", this.artifactVersion);
        this.supportingFiles.add(new SupportingFile("index.mustache", "", "index.html"));
        this.reservedWords = new HashSet();
        this.languageSpecificPrimitives = new HashSet();
        this.importMapping = new HashMap();
    }

    @Override
    public String escapeText(String input) {
        return this.toHtml(input);
    }

    public CodegenType getTag() {
        return CodegenType.DOCUMENTATION;
    }

    @Override
    public String getArgumentsLocation() {
        return "";
    }

    public String getName() {
        return "html";
    }

    public String getHelp() {
        return "Generates a static HTML file.";
    }

    @Override
    public String getTypeDeclaration(Schema propertySchema) {
        if (propertySchema instanceof ArraySchema) {
            Schema inner = ((ArraySchema)propertySchema).getItems();
            return String.format("%s[%s]", this.getSchemaType(propertySchema), this.getTypeDeclaration(inner));
        }
        if (propertySchema instanceof MapSchema) {
            Schema inner = (Schema)propertySchema.getAdditionalProperties();
            return String.format("%s[String, %s]", this.getSchemaType(propertySchema), this.getTypeDeclaration(inner));
        }
        return super.getTypeDeclaration(propertySchema);
    }

    @Override
    public Map<String, Object> postProcessOperations(Map<String, Object> objs) {
        Map operations = (Map)objs.get("operations");
        List operationList = (List)operations.get("operation");
        for (CodegenOperation op : operationList) {
            op.httpMethod = op.httpMethod.toLowerCase();
            for (CodegenResponse response : op.responses) {
                if (!"0".equals(response.code)) continue;
                response.code = "default";
            }
        }
        return objs;
    }

    @Override
    public void processOpts() {
        super.processOpts();
        String templateVersion = this.getTemplateVersion();
        this.embeddedTemplateDir = StringUtils.isNotBlank((CharSequence)templateVersion) ? (this.templateDir = String.format("%s/htmlDocs", templateVersion)) : (this.templateDir = String.format("%s/htmlDocs", "v2"));
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input;
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input;
    }

    public String toHtml(String input) {
        if (input == null) {
            return "";
        }
        return this.markdownConverter.toHtml(input);
    }

    @Override
    public String toModelName(String name) {
        return name;
    }

    @Override
    public void preprocessOpenAPI(OpenAPI openAPI) {
        Info info = openAPI.getInfo();
        info.setDescription(this.toHtml(info.getDescription()));
        info.setTitle(this.toHtml(info.getTitle()));
        if (openAPI.getComponents() == null || openAPI.getComponents().getSchemas() == null) {
            return;
        }
        Map schemas = openAPI.getComponents().getSchemas();
        for (Schema schema : schemas.values()) {
            schema.setDescription(this.toHtml(schema.getDescription()));
            schema.setTitle(this.toHtml(schema.getTitle()));
        }
    }

    @Override
    public void postProcessParameter(CodegenParameter parameter) {
        parameter.description = this.toHtml(parameter.description);
        parameter.unescapedDescription = this.toHtml(parameter.unescapedDescription);
    }

    @Override
    public void postProcessModelProperty(CodegenModel model, CodegenProperty property) {
        property.description = this.toHtml(property.description);
        property.unescapedDescription = this.toHtml(property.unescapedDescription);
    }
}

