/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.util;

import java.util.ArrayList;
import java.util.stream.Stream;
import org.jboss.jandex.ArrayType;
import org.jboss.jandex.ClassType;
import org.jboss.jandex.DotName;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.Type;
import org.jboss.jandex.WildcardType;

public class TypeParser {
    private static final WildcardType UNBOUNDED_WILDCARD = WildcardType.createUpperBound((Type)null);
    private String signature;
    private int pos;

    public static Type parse(String signature) {
        return new TypeParser(signature).parse();
    }

    private TypeParser(String signature) {
        this.signature = signature;
        this.pos = 0;
    }

    private Type parse() {
        return this.parseReferenceType();
    }

    private Type parseClassTypeSignature() {
        DotName name = this.parseName();
        Type[] types = this.parseTypeArguments();
        ClassType type = null;
        if (types.length > 0) {
            type = ParameterizedType.create((DotName)name, (Type[])types, null);
        }
        return type != null ? type : ClassType.create((DotName)name);
    }

    private Type[] parseTypeArguments() {
        Type t;
        if (this.pos >= this.signature.length() || this.signature.charAt(this.pos) != '<') {
            return Type.EMPTY_ARRAY;
        }
        ++this.pos;
        ArrayList<Type> types = new ArrayList<Type>();
        while ((t = this.parseTypeArgument()) != null) {
            this.advanceNot(',');
            types.add(t);
        }
        return types.toArray(new Type[types.size()]);
    }

    private Type parseTypeArgument() {
        this.requireIncomplete();
        char c = this.signature.charAt(this.pos++);
        if (c == '>') {
            return null;
        }
        if (c == '?') {
            if (this.signature.startsWith(" extends ", this.pos)) {
                this.pos += " extends ".length();
                return this.parseWildCard(true);
            }
            if (this.signature.startsWith(" super ", this.pos)) {
                this.pos += " super ".length();
                return this.parseWildCard(false);
            }
            this.requireIncomplete();
            if (this.signature.charAt(this.pos) != '>') {
                throw new IllegalStateException();
            }
            return UNBOUNDED_WILDCARD;
        }
        --this.pos;
        return this.parseReferenceType();
    }

    private Type parseWildCard(boolean isExtends) {
        Type bound = this.parseReferenceType();
        return isExtends ? WildcardType.createUpperBound((Type)bound) : WildcardType.createLowerBound((Type)bound);
    }

    private Type parseReferenceType() {
        int mark = this.pos;
        int typeArgsStart = this.signature.indexOf(60, mark);
        int typeArgsEnd = this.signature.indexOf(62, mark);
        int arrayStart = this.signature.indexOf(91, mark);
        return Stream.of(typeArgsEnd, typeArgsStart, arrayStart).filter(v -> v > -1).min(Integer::compare).map(firstDelimiter -> {
            Type type = null;
            if (firstDelimiter == arrayStart) {
                type = this.parsePrimitive();
            }
            if (type == null) {
                type = this.parseClassTypeSignature();
            }
            if (this.pos < this.signature.length() && this.signature.charAt(this.pos) == '[') {
                type = this.parseArrayType(type);
            }
            return type;
        }).orElseGet(() -> {
            Type primitive = this.parsePrimitive();
            if (primitive != null) {
                return primitive;
            }
            return this.parseClassTypeSignature();
        });
    }

    private Type parseArrayType(Type type) {
        int dimensions = 0;
        while (this.pos < this.signature.length() && this.signature.charAt(this.pos) == '[') {
            ++this.pos;
            this.requireIncomplete();
            if (this.signature.charAt(this.pos++) == ']') {
                ++dimensions;
                continue;
            }
            throw new IllegalArgumentException();
        }
        return ArrayType.create((Type)type, (int)dimensions);
    }

    private Type parsePrimitive() {
        int mark = this.pos;
        DotName name = this.parseName();
        Type type = Type.create((DotName)name, (Type.Kind)Type.Kind.PRIMITIVE);
        if (type != null) {
            return type;
        }
        this.pos = mark;
        return null;
    }

    private int advanceNot(char c) {
        this.requireIncomplete();
        while (this.signature.charAt(this.pos) == c) {
            ++this.pos;
        }
        return this.pos;
    }

    private DotName parseName() {
        int start = this.pos;
        int end = this.advanceNameEnd();
        return DotName.createSimple((String)this.signature.substring(start, end));
    }

    private int advanceNameEnd() {
        int end;
        for (end = this.pos; end < this.signature.length(); ++end) {
            char c = this.signature.charAt(end);
            if (c != '[' && c != '<' && c != ',' && c != '>') continue;
            this.pos = end;
            return this.pos;
        }
        this.pos = end;
        return this.pos;
    }

    private void requireIncomplete() {
        if (this.pos >= this.signature.length()) {
            throw new IllegalStateException("Unexpected end of input");
        }
    }
}

