/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.io.definition;

import com.fasterxml.jackson.databind.JsonNode;
import io.smallrye.openapi.runtime.io.IoLogging;
import io.smallrye.openapi.runtime.io.JsonUtil;
import io.smallrye.openapi.runtime.io.components.ComponentsReader;
import io.smallrye.openapi.runtime.io.definition.DefinitionConstant;
import io.smallrye.openapi.runtime.io.extension.ExtensionReader;
import io.smallrye.openapi.runtime.io.externaldocs.ExternalDocsReader;
import io.smallrye.openapi.runtime.io.info.InfoReader;
import io.smallrye.openapi.runtime.io.paths.PathsReader;
import io.smallrye.openapi.runtime.io.securityrequirement.SecurityRequirementReader;
import io.smallrye.openapi.runtime.io.server.ServerReader;
import io.smallrye.openapi.runtime.io.tag.TagReader;
import io.smallrye.openapi.runtime.scanner.spi.AnnotationScannerContext;
import io.smallrye.openapi.runtime.util.JandexUtil;
import java.util.List;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;

public class DefinitionReader {
    private DefinitionReader() {
    }

    public static void processDefinition(AnnotationScannerContext context, OpenAPI openApi, AnnotationInstance annotationInstance) {
        IoLogging.logger.annotation("@OpenAPIDefinition");
        openApi.setInfo(InfoReader.readInfo(annotationInstance.value("info")));
        openApi.setTags((List)TagReader.readTags(context, annotationInstance.value("tags")).orElse(null));
        openApi.setServers((List)ServerReader.readServers(annotationInstance.value("servers")).orElse(null));
        openApi.setSecurity((List)SecurityRequirementReader.readSecurityRequirements(annotationInstance.value("security")).orElse(null));
        openApi.setExternalDocs(ExternalDocsReader.readExternalDocs(context, annotationInstance.value("externalDocs")));
        openApi.setComponents(ComponentsReader.readComponents(context, annotationInstance.value("components")));
        openApi.setExtensions(ExtensionReader.readExtensions(context, annotationInstance));
    }

    public static void processDefinition(OpenAPI openApi, JsonNode node) {
        IoLogging.logger.jsonNode("OpenAPIDefinition");
        openApi.setOpenapi(JsonUtil.stringProperty(node, "openapi"));
        openApi.setInfo(InfoReader.readInfo(node.get("info")));
        openApi.setTags((List)TagReader.readTags(node.get("tags")).orElse(null));
        openApi.setServers((List)ServerReader.readServers(node.get("servers")).orElse(null));
        openApi.setSecurity((List)SecurityRequirementReader.readSecurityRequirements(node.get("security")).orElse(null));
        openApi.setExternalDocs(ExternalDocsReader.readExternalDocs(node.get("externalDocs")));
        openApi.setComponents(ComponentsReader.readComponents(node.get("components")));
        openApi.setPaths(PathsReader.readPaths(node.get("paths")));
        ExtensionReader.readExtensions(node, openApi);
    }

    public static AnnotationInstance getDefinitionAnnotation(ClassInfo targetClass) {
        return JandexUtil.getClassAnnotation(targetClass, DefinitionConstant.DOTNAME_OPEN_API_DEFINITION);
    }
}

