/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.core.async.types;

import io.smallrye.faulttolerance.core.FaultToleranceStrategy;
import io.smallrye.faulttolerance.core.InvocationContext;
import io.smallrye.faulttolerance.core.async.types.AsyncTypeConverter;
import io.smallrye.faulttolerance.core.async.types.AsyncTypesLogger;
import io.smallrye.faulttolerance.core.util.SneakyThrow;
import java.util.concurrent.CompletionStage;

public class AsyncTypesConversion {

    public static class FromCompletionStage
    implements FaultToleranceStrategy {
        private final FaultToleranceStrategy delegate;
        private final AsyncTypeConverter converter;

        public FromCompletionStage(FaultToleranceStrategy delegate, AsyncTypeConverter converter) {
            this.delegate = delegate;
            this.converter = converter;
        }

        public Object apply(InvocationContext ctx) throws Exception {
            AsyncTypesLogger.LOG.trace("AsyncTypesConversion.FromCompletionStage started");
            try {
                Object AT = this.converter.fromCompletionStage(() -> {
                    try {
                        return this.delegate.apply(ctx);
                    }
                    catch (Exception e) {
                        throw SneakyThrow.sneakyThrow(e);
                    }
                });
                return AT;
            }
            finally {
                AsyncTypesLogger.LOG.trace("AsyncTypesConversion.FromCompletionStage finished");
            }
        }
    }

    public static class ToCompletionStage
    implements FaultToleranceStrategy {
        private final FaultToleranceStrategy delegate;
        private final AsyncTypeConverter converter;

        public ToCompletionStage(FaultToleranceStrategy delegate, AsyncTypeConverter converter) {
            this.delegate = delegate;
            this.converter = converter;
        }

        public Object apply(InvocationContext ctx) throws Exception {
            AsyncTypesLogger.LOG.trace("AsyncTypesConversion.ToCompletionStage started");
            try {
                CompletionStage completionStage = this.converter.toCompletionStage(this.delegate.apply(ctx));
                return completionStage;
            }
            finally {
                AsyncTypesLogger.LOG.trace("AsyncTypesConversion.ToCompletionStage finished");
            }
        }
    }
}

