package io.vertx.mutiny.ext.web.handler;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;

/**
 * An auth handler that's used to handle auth by redirecting user to a custom login page.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.handler.RedirectAuthHandler original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.ext.web.handler.RedirectAuthHandler.class)
public class RedirectAuthHandler implements io.smallrye.mutiny.vertx.MutinyDelegate, io.vertx.mutiny.ext.web.handler.AuthenticationHandler, io.vertx.core.Handler<io.vertx.mutiny.ext.web.RoutingContext>, java.util.function.Consumer<io.vertx.mutiny.ext.web.RoutingContext> {

  public static final io.smallrye.mutiny.vertx.TypeArg<RedirectAuthHandler> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new RedirectAuthHandler((io.vertx.ext.web.handler.RedirectAuthHandler) obj),
    RedirectAuthHandler::getDelegate
  );

  private final io.vertx.ext.web.handler.RedirectAuthHandler delegate;
  
  public RedirectAuthHandler(io.vertx.ext.web.handler.RedirectAuthHandler delegate) {
    this.delegate = delegate;
  }

  public RedirectAuthHandler(Object delegate) {
    this.delegate = (io.vertx.ext.web.handler.RedirectAuthHandler)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  RedirectAuthHandler() {
    this.delegate = null;
  }

  @Override
  public io.vertx.ext.web.handler.RedirectAuthHandler getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RedirectAuthHandler that = (RedirectAuthHandler) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public void handle(io.vertx.mutiny.ext.web.RoutingContext arg0) { 
    delegate.handle(arg0.getDelegate());
  }

  /**
   * @param authProvider the auth service to use
   * @return the handler
   */
  public static io.vertx.mutiny.ext.web.handler.RedirectAuthHandler create(io.vertx.mutiny.ext.auth.authentication.AuthenticationProvider authProvider) { 
    io.vertx.mutiny.ext.web.handler.RedirectAuthHandler ret = io.vertx.mutiny.ext.web.handler.RedirectAuthHandler.newInstance((io.vertx.ext.web.handler.RedirectAuthHandler)io.vertx.ext.web.handler.RedirectAuthHandler.create(authProvider.getDelegate()));
    return ret;
  }

  /**
   * @param authProvider the auth service to use
   * @param loginRedirectURL the url to redirect the user to
   * @return the handler
   */
  public static io.vertx.mutiny.ext.web.handler.RedirectAuthHandler create(io.vertx.mutiny.ext.auth.authentication.AuthenticationProvider authProvider, String loginRedirectURL) { 
    io.vertx.mutiny.ext.web.handler.RedirectAuthHandler ret = io.vertx.mutiny.ext.web.handler.RedirectAuthHandler.newInstance((io.vertx.ext.web.handler.RedirectAuthHandler)io.vertx.ext.web.handler.RedirectAuthHandler.create(authProvider.getDelegate(), loginRedirectURL));
    return ret;
  }

  /**
   * @param authProvider the auth service to use
   * @param loginRedirectURL the url to redirect the user to
   * @param returnURLParam the name of param used to store return url information in session
   * @return the handler
   */
  public static io.vertx.mutiny.ext.web.handler.RedirectAuthHandler create(io.vertx.mutiny.ext.auth.authentication.AuthenticationProvider authProvider, String loginRedirectURL, String returnURLParam) { 
    io.vertx.mutiny.ext.web.handler.RedirectAuthHandler ret = io.vertx.mutiny.ext.web.handler.RedirectAuthHandler.newInstance((io.vertx.ext.web.handler.RedirectAuthHandler)io.vertx.ext.web.handler.RedirectAuthHandler.create(authProvider.getDelegate(), loginRedirectURL, returnURLParam));
    return ret;
  }

  /**
   * Default path the user will be redirected to
   */
  public static final String DEFAULT_LOGIN_REDIRECT_URL = io.vertx.ext.web.handler.RedirectAuthHandler.DEFAULT_LOGIN_REDIRECT_URL;
  /**
   * Default name of param used to store return url information in session
   */
  public static final String DEFAULT_RETURN_URL_PARAM = io.vertx.ext.web.handler.RedirectAuthHandler.DEFAULT_RETURN_URL_PARAM;
  public void accept(io.vertx.mutiny.ext.web.RoutingContext item) {
    handle(item);
  }
  public static  RedirectAuthHandler newInstance(io.vertx.ext.web.handler.RedirectAuthHandler arg) {
    return arg != null ? new RedirectAuthHandler(arg) : null;
  }

}
