package io.vertx.mutiny.core.streams;

import java.util.Map;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Publisher;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

/**
 * Represents a stream of items that can be read from.
 * <p>
 * Any class that implements this interface can be used by a {@link io.vertx.mutiny.core.streams.Pump} to pump data from it
 * to a {@link io.vertx.mutiny.core.streams.WriteStream}.
 * <p>
 * <h3>Streaming mode</h3>
 * The stream is either in <i>flowing</i> or <i>fetch</i> mode.
 * <ul>
 *   <i>Initially the stream is in <i>flowing</i> mode.</i>
 *   <li>When the stream is in <i>flowing</i> mode, elements are delivered to the <code>handler</code>.</li>
 *   <li>When the stream is in <i>fetch</i> mode, only the number of requested elements will be delivered to the <code>handler</code>.</li>
 * </ul>
 * The mode can be changed with the {@link io.vertx.mutiny.core.streams.ReadStream#pause}, {@link io.vertx.mutiny.core.streams.ReadStream#resume} and {@link io.vertx.mutiny.core.streams.ReadStream#fetch} methods:
 * <ul>
 *   <li>Calling {@link io.vertx.mutiny.core.streams.ReadStream#resume} sets the <i>flowing</i> mode</li>
 *   <li>Calling {@link io.vertx.mutiny.core.streams.ReadStream#pause} sets the <i>fetch</i> mode and resets the demand to <code>0</code></li>
 *   <li>Calling {@link io.vertx.mutiny.core.streams.ReadStream#fetch} requests a specific amount of elements and adds it to the actual demand</li>
 * </ul>
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.streams.ReadStream original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.core.streams.ReadStream.class)
public interface ReadStream<T> extends io.vertx.mutiny.core.streams.StreamBase {

  io.vertx.core.streams.ReadStream getDelegate();

  io.smallrye.mutiny.Multi<T> toMulti();

  /**
   * @param handler the exception handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.streams.ReadStream<T> exceptionHandler(Consumer<Throwable> handler);
  /**
   * @param handler 
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.streams.ReadStream<T> handler(Consumer<T> handler);
  /**
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.streams.ReadStream<T> pause();
  /**
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.streams.ReadStream<T> resume();
  /**
   * @param amount 
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.streams.ReadStream<T> fetch(long amount);
  /**
   * @param endHandler 
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.streams.ReadStream<T> endHandler(Consumer<Void> endHandler);
  /**
   * @return a pipe
   */
  public io.vertx.mutiny.core.streams.Pipe<T> pipe();
  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param dst the destination write stream
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  public Uni<Void> pipeTo(io.vertx.mutiny.core.streams.WriteStream<T> dst);
  /**
   * Blocking variant of {@link io.vertx.mutiny.core.streams.ReadStream#pipeTo(io.vertx.mutiny.core.streams.WriteStream<T>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param dst the destination write stream
   * @return the Void instance produced by the operation
   */
  public Void pipeToAndAwait(io.vertx.mutiny.core.streams.WriteStream<T> dst);
  public static <T>ReadStream<T> newInstance(io.vertx.core.streams.ReadStream arg) {
    return arg != null ? new ReadStreamImpl<T>(arg) : null;
  }


  public static <T>ReadStream<T> newInstance(io.vertx.core.streams.ReadStream arg, io.smallrye.mutiny.vertx.TypeArg<T> __typeArg_T) {
    return arg != null ? new ReadStreamImpl<T>(arg, __typeArg_T) : null;
  }

}

class ReadStreamImpl<T> implements ReadStream<T> {
  private final io.vertx.core.streams.ReadStream<T> delegate;
  public final io.smallrye.mutiny.vertx.TypeArg<T> __typeArg_0;
  
  public io.vertx.core.streams.ReadStream getDelegate() {
    return delegate;
  }

  /**
  * Empty constructor used by CDI, do not use this constructor directly.
  **/
  ReadStreamImpl() {    this.delegate = null;
    this.__typeArg_0 = io.smallrye.mutiny.vertx.TypeArg.unknown();  }

  public ReadStreamImpl(io.vertx.core.streams.ReadStream delegate) {
    this.delegate = delegate;
    this.__typeArg_0 = io.smallrye.mutiny.vertx.TypeArg.unknown();  }

  public ReadStreamImpl(io.vertx.core.streams.ReadStream delegate, io.smallrye.mutiny.vertx.TypeArg<T> typeArg_0) {
    this.delegate = delegate;
    this.__typeArg_0 = typeArg_0;
  }

  private Multi<T> multi;
  public synchronized Multi<T> toMulti() {
    if (multi == null) {
      java.util.function.Function<T, T> conv = (java.util.function.Function<T, T>) __typeArg_0.wrap;
      multi = io.smallrye.mutiny.vertx.MultiHelper.toMulti(delegate, conv);    }
    return multi;
  }

  public java.lang.Iterable<T> toBlockingIterable() {
    return toMulti().subscribe().asIterable();  }

  public java.util.stream.Stream<T> toBlockingStream() {
    return toMulti().subscribe().asStream();  }

  /**
   * @param handler the exception handler
   * @return a reference to this, so the API can be used fluently
   */
  private io.vertx.mutiny.core.streams.ReadStream<T> __exceptionHandler(Handler<Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  /**
   * @param handler the exception handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.streams.ReadStream<T> exceptionHandler(Consumer<Throwable> handler) {
    return __exceptionHandler(handler != null ? handler::accept : null);
  }

  /**
   * @param handler 
   * @return a reference to this, so the API can be used fluently
   */
  private io.vertx.mutiny.core.streams.ReadStream<T> __handler(Handler<T> handler) { 
    delegate.handler(new Handler<T>() {
      public void handle(T event) {
        handler.handle((T)__typeArg_0.wrap(event));
      }
    });
    return this;
  }

  /**
   * @param handler 
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.streams.ReadStream<T> handler(Consumer<T> handler) {
    return __handler(handler != null ? handler::accept : null);
  }

  /**
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.streams.ReadStream<T> pause() { 
    delegate.pause();
    return this;
  }

  /**
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.streams.ReadStream<T> resume() { 
    delegate.resume();
    return this;
  }

  /**
   * @param amount 
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.streams.ReadStream<T> fetch(long amount) { 
    delegate.fetch(amount);
    return this;
  }

  /**
   * @param endHandler 
   * @return a reference to this, so the API can be used fluently
   */
  private io.vertx.mutiny.core.streams.ReadStream<T> __endHandler(Handler<Void> endHandler) { 
    delegate.endHandler(endHandler);
    return this;
  }

  /**
   * @param endHandler 
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.streams.ReadStream<T> endHandler(Consumer<Void> endHandler) {
    return __endHandler(endHandler != null ? endHandler::accept : null);
  }

  /**
   * @return a pipe
   */
  public io.vertx.mutiny.core.streams.Pipe<T> pipe() { 
    io.vertx.mutiny.core.streams.Pipe<T> ret = io.vertx.mutiny.core.streams.Pipe.newInstance(delegate.pipe(), __typeArg_0);
    return ret;
  }

  /**
   * @param dst the destination write stream
   * @param handler 
   */
  private void __pipeTo(io.vertx.mutiny.core.streams.WriteStream<T> dst, Handler<AsyncResult<Void>> handler) { 
    delegate.pipeTo(dst.getDelegate(), handler);
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param dst the destination write stream
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  public Uni<Void> pipeTo(io.vertx.mutiny.core.streams.WriteStream<T> dst) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __pipeTo(dst, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.streams.ReadStream#pipeTo(io.vertx.mutiny.core.streams.WriteStream<T>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param dst the destination write stream
   * @return the Void instance produced by the operation
   */
  public Void pipeToAndAwait(io.vertx.mutiny.core.streams.WriteStream<T> dst) { 
    return (Void) pipeTo(dst).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.streams.ReadStream#pipeTo(io.vertx.mutiny.core.streams.WriteStream<T>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.streams.ReadStream#pipeTo(io.vertx.mutiny.core.streams.WriteStream<T>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.streams.ReadStream#pipeTo(io.vertx.mutiny.core.streams.WriteStream<T>)} but you don't need to compose it with other operations.
   * @param dst 
   */
  public void pipeToAndForget(io.vertx.mutiny.core.streams.WriteStream<T> dst) { 
    delegate.pipeTo(dst.getDelegate());
  }

}
