package io.vertx.mutiny.core.http;

import java.util.Map;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Publisher;
import io.vertx.core.http.StreamPriority;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

/**
 * Represents a server-side HTTP response.
 * <p>
 * An instance of this is created and associated to every instance of
 * {@link io.vertx.mutiny.core.http.HttpServerRequest} that.
 * <p>
 * It allows the developer to control the HTTP response that is sent back to the
 * client for a particular HTTP request.
 * <p>
 * It contains methods that allow HTTP headers and trailers to be set, and for a body to be written out to the response.
 * <p>
 * It also allows files to be streamed by the kernel directly from disk to the
 * outgoing HTTP connection, bypassing user space altogether (where supported by
 * the underlying operating system). This is a very efficient way of
 * serving files from the server since buffers do not have to be read one by one
 * from the file and written to the outgoing socket.
 * <p>
 * It implements {@link io.vertx.mutiny.core.streams.WriteStream} so it can be used with
 * {@link io.vertx.mutiny.core.streams.Pump} to pump data with flow control.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.http.HttpServerResponse original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.core.http.HttpServerResponse.class)
public class HttpServerResponse implements io.vertx.mutiny.core.streams.WriteStream<io.vertx.mutiny.core.buffer.Buffer> {

  public static final io.smallrye.mutiny.vertx.TypeArg<HttpServerResponse> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new HttpServerResponse((io.vertx.core.http.HttpServerResponse) obj),
    HttpServerResponse::getDelegate
  );

  private final io.vertx.core.http.HttpServerResponse delegate;
  
  public HttpServerResponse(io.vertx.core.http.HttpServerResponse delegate) {
    this.delegate = delegate;
  }

  /**
  * Empty constructor used by CDI, do not use this constructor directly.
  **/
  HttpServerResponse() {    this.delegate = null;
  }

  public io.vertx.core.http.HttpServerResponse getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    HttpServerResponse that = (HttpServerResponse) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  private io.smallrye.mutiny.vertx.WriteStreamSubscriber<io.vertx.mutiny.core.buffer.Buffer> subscriber;

  public synchronized io.smallrye.mutiny.vertx.WriteStreamSubscriber<io.vertx.mutiny.core.buffer.Buffer> toSubscriber() {
    if (subscriber == null) {
      java.util.function.Function<io.vertx.mutiny.core.buffer.Buffer, io.vertx.core.buffer.Buffer> conv = io.vertx.mutiny.core.buffer.Buffer::getDelegate;
      subscriber = io.smallrye.mutiny.vertx.MutinyHelper.toSubscriber(getDelegate(), conv);
    }
    return subscriber;
  }

  /**
   * @param handler 
   */
  private void __end(Handler<AsyncResult<Void>> handler) { 
    delegate.end(handler);
  }

  /**
   * Same as {@link io.vertx.mutiny.core.http.HttpServerResponse#end} but with an <code>handler</code> called when the operation completes
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  public Uni<Void> end() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __end(handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.streams.WriteStream#end}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Void instance produced by the operation
   */
  public Void endAndAwait() { 
    return (Void) end().await().indefinitely();
  }

  /**
   * @return true if write queue is full
   */
  public boolean writeQueueFull() { 
    boolean ret = delegate.writeQueueFull();
    return ret;
  }

  private io.vertx.mutiny.core.http.HttpServerResponse __exceptionHandler(Handler<Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  public io.vertx.mutiny.core.http.HttpServerResponse exceptionHandler(Consumer<Throwable> handler) {
    return __exceptionHandler(handler != null ? handler::accept : null);
  }

  /**
   * @param data 
   * @param handler 
   * @return 
   */
  private io.vertx.mutiny.core.http.HttpServerResponse __write(io.vertx.mutiny.core.buffer.Buffer data, Handler<AsyncResult<Void>> handler) { 
    delegate.write(data.getDelegate(), handler);
    return this;
  }

  /**
   * Same as {@link io.vertx.mutiny.core.http.HttpServerResponse#write} but with an <code>handler</code> called when the operation completes
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param data 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  public Uni<Void> write(io.vertx.mutiny.core.buffer.Buffer data) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __write(data, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.http.HttpServerResponse#write(io.vertx.mutiny.core.buffer.Buffer)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param data 
   * @return the Void instance produced by the operation
   */
  public Void writeAndAwait(io.vertx.mutiny.core.buffer.Buffer data) { 
    return (Void) write(data).await().indefinitely();
  }

  public io.vertx.mutiny.core.http.HttpServerResponse setWriteQueueMaxSize(int maxSize) { 
    delegate.setWriteQueueMaxSize(maxSize);
    return this;
  }

  private io.vertx.mutiny.core.http.HttpServerResponse __drainHandler(Handler<Void> handler) { 
    delegate.drainHandler(handler);
    return this;
  }

  public io.vertx.mutiny.core.http.HttpServerResponse drainHandler(Consumer<Void> handler) {
    return __drainHandler(handler != null ? handler::accept : null);
  }

  /**
   * @return the HTTP status code of the response. The default is <code>200</code> representing <code>OK</code>.
   */
  public int getStatusCode() { 
    int ret = delegate.getStatusCode();
    return ret;
  }

  /**
   * @param statusCode 
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.http.HttpServerResponse setStatusCode(int statusCode) { 
    delegate.setStatusCode(statusCode);
    return this;
  }

  /**
   * @return the HTTP status message of the response. If this is not specified a default value will be used depending on what {@link io.vertx.mutiny.core.http.HttpServerResponse#setStatusCode} has been set to.
   */
  public String getStatusMessage() { 
    String ret = delegate.getStatusMessage();
    return ret;
  }

  /**
   * @param statusMessage 
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.http.HttpServerResponse setStatusMessage(String statusMessage) { 
    delegate.setStatusMessage(statusMessage);
    return this;
  }

  /**
   * @param chunked 
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.http.HttpServerResponse setChunked(boolean chunked) { 
    delegate.setChunked(chunked);
    return this;
  }

  /**
   * @return is the response chunked?
   */
  public boolean isChunked() { 
    boolean ret = delegate.isChunked();
    return ret;
  }

  /**
   * @return The HTTP headers
   */
  public io.vertx.mutiny.core.MultiMap headers() { 
    if (cached_0 != null) {
      return cached_0;
    }
    io.vertx.mutiny.core.MultiMap ret = io.vertx.mutiny.core.MultiMap.newInstance(delegate.headers());
    cached_0 = ret;
    return ret;
  }

  /**
   * @param name the header name
   * @param value the header value.
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.http.HttpServerResponse putHeader(String name, String value) { 
    delegate.putHeader(name, value);
    return this;
  }

  /**
   * @return The HTTP trailers
   */
  public io.vertx.mutiny.core.MultiMap trailers() { 
    if (cached_1 != null) {
      return cached_1;
    }
    io.vertx.mutiny.core.MultiMap ret = io.vertx.mutiny.core.MultiMap.newInstance(delegate.trailers());
    cached_1 = ret;
    return ret;
  }

  /**
   * @param name the trailer name
   * @param value the trailer value
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.http.HttpServerResponse putTrailer(String name, String value) { 
    delegate.putTrailer(name, value);
    return this;
  }

  /**
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  private io.vertx.mutiny.core.http.HttpServerResponse __closeHandler(Handler<Void> handler) { 
    delegate.closeHandler(handler);
    return this;
  }

  /**
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.http.HttpServerResponse closeHandler(Consumer<Void> handler) {
    return __closeHandler(handler != null ? handler::accept : null);
  }

  /**
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  private io.vertx.mutiny.core.http.HttpServerResponse __endHandler(Handler<Void> handler) { 
    delegate.endHandler(handler);
    return this;
  }

  /**
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.http.HttpServerResponse endHandler(Consumer<Void> handler) {
    return __endHandler(handler != null ? handler::accept : null);
  }

  /**
   * @param chunk 
   * @param enc 
   * @param handler 
   * @return 
   */
  private io.vertx.mutiny.core.http.HttpServerResponse __write(String chunk, String enc, Handler<AsyncResult<Void>> handler) { 
    delegate.write(chunk, enc, handler);
    return this;
  }

  /**
   * Same as {@link io.vertx.mutiny.core.http.HttpServerResponse#write} but with an <code>handler</code> called when the operation completes
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param chunk 
   * @param enc 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  public Uni<Void> write(String chunk, String enc) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __write(chunk, enc, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.http.HttpServerResponse#write(String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param chunk 
   * @param enc 
   * @return the Void instance produced by the operation
   */
  public Void writeAndAwait(String chunk, String enc) { 
    return (Void) write(chunk, enc).await().indefinitely();
  }

  /**
   * @param chunk 
   * @param handler 
   * @return 
   */
  private io.vertx.mutiny.core.http.HttpServerResponse __write(String chunk, Handler<AsyncResult<Void>> handler) { 
    delegate.write(chunk, handler);
    return this;
  }

  /**
   * Same as {@link io.vertx.mutiny.core.http.HttpServerResponse#write} but with an <code>handler</code> called when the operation completes
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param chunk 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  public Uni<Void> write(String chunk) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __write(chunk, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.http.HttpServerResponse#write(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param chunk 
   * @return the Void instance produced by the operation
   */
  public Void writeAndAwait(String chunk) { 
    return (Void) write(chunk).await().indefinitely();
  }

  /**
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.http.HttpServerResponse writeContinue() { 
    delegate.writeContinue();
    return this;
  }

  /**
   * @param chunk 
   * @param handler 
   */
  private void __end(String chunk, Handler<AsyncResult<Void>> handler) { 
    delegate.end(chunk, handler);
  }

  /**
   * Same as {@link io.vertx.mutiny.core.http.HttpServerResponse#end} but with an <code>handler</code> called when the operation completes
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param chunk 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  public Uni<Void> end(String chunk) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __end(chunk, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.http.HttpServerResponse#end(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param chunk 
   * @return the Void instance produced by the operation
   */
  public Void endAndAwait(String chunk) { 
    return (Void) end(chunk).await().indefinitely();
  }

  /**
   * @param chunk 
   * @param enc 
   * @param handler 
   */
  private void __end(String chunk, String enc, Handler<AsyncResult<Void>> handler) { 
    delegate.end(chunk, enc, handler);
  }

  /**
   * Same as {@link io.vertx.mutiny.core.http.HttpServerResponse#end} but with an <code>handler</code> called when the operation completes
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param chunk 
   * @param enc 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  public Uni<Void> end(String chunk, String enc) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __end(chunk, enc, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.http.HttpServerResponse#end(String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param chunk 
   * @param enc 
   * @return the Void instance produced by the operation
   */
  public Void endAndAwait(String chunk, String enc) { 
    return (Void) end(chunk, enc).await().indefinitely();
  }

  /**
   * @param chunk 
   * @param handler 
   */
  private void __end(io.vertx.mutiny.core.buffer.Buffer chunk, Handler<AsyncResult<Void>> handler) { 
    delegate.end(chunk.getDelegate(), handler);
  }

  /**
   * Same as {@link io.vertx.mutiny.core.http.HttpServerResponse#end} but with an <code>handler</code> called when the operation completes
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param chunk 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  public Uni<Void> end(io.vertx.mutiny.core.buffer.Buffer chunk) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __end(chunk, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.http.HttpServerResponse#end(io.vertx.mutiny.core.buffer.Buffer)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param chunk 
   * @return the Void instance produced by the operation
   */
  public Void endAndAwait(io.vertx.mutiny.core.buffer.Buffer chunk) { 
    return (Void) end(chunk).await().indefinitely();
  }

  /**
   * @param filename path to the file to serve
   * @param resultHandler handler that will be called on completion
   * @return a reference to this, so the API can be used fluently
   */
  private io.vertx.mutiny.core.http.HttpServerResponse __sendFile(String filename, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.sendFile(filename, resultHandler);
    return this;
  }

  /**
   * Like {@link io.vertx.mutiny.core.http.HttpServerResponse#sendFile} but providing a handler which will be notified once the file has been completely
   * written to the wire.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param filename path to the file to serve
   * @return a reference to this, so the API can be used fluently
   */
  public Uni<Void> sendFile(String filename) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __sendFile(filename, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.http.HttpServerResponse#sendFile(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param filename path to the file to serve
   * @return a reference to this, so the API can be used fluently
   */
  public Void sendFileAndAwait(String filename) { 
    return (Void) sendFile(filename).await().indefinitely();
  }

  /**
   * @param filename path to the file to serve
   * @param offset the offset to serve from
   * @param resultHandler handler that will be called on completion
   * @return a reference to this, so the API can be used fluently
   */
  private io.vertx.mutiny.core.http.HttpServerResponse __sendFile(String filename, long offset, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.sendFile(filename, offset, resultHandler);
    return this;
  }

  /**
   * Like {@link io.vertx.mutiny.core.http.HttpServerResponse#sendFile} but providing a handler which will be notified once the file has been completely
   * written to the wire.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param filename path to the file to serve
   * @param offset the offset to serve from
   * @return a reference to this, so the API can be used fluently
   */
  public Uni<Void> sendFile(String filename, long offset) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __sendFile(filename, offset, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.http.HttpServerResponse#sendFile(String,long)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param filename path to the file to serve
   * @param offset the offset to serve from
   * @return a reference to this, so the API can be used fluently
   */
  public Void sendFileAndAwait(String filename, long offset) { 
    return (Void) sendFile(filename, offset).await().indefinitely();
  }

  /**
   * @param filename path to the file to serve
   * @param offset the offset to serve from
   * @param length the length to serve to
   * @param resultHandler handler that will be called on completion
   * @return a reference to this, so the API can be used fluently
   */
  private io.vertx.mutiny.core.http.HttpServerResponse __sendFile(String filename, long offset, long length, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.sendFile(filename, offset, length, resultHandler);
    return this;
  }

  /**
   * Like {@link io.vertx.mutiny.core.http.HttpServerResponse#sendFile} but providing a handler which will be notified once the file has been
   * completely written to the wire.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param filename path to the file to serve
   * @param offset the offset to serve from
   * @param length the length to serve to
   * @return a reference to this, so the API can be used fluently
   */
  public Uni<Void> sendFile(String filename, long offset, long length) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __sendFile(filename, offset, length, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.http.HttpServerResponse#sendFile(String,long,long)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param filename path to the file to serve
   * @param offset the offset to serve from
   * @param length the length to serve to
   * @return a reference to this, so the API can be used fluently
   */
  public Void sendFileAndAwait(String filename, long offset, long length) { 
    return (Void) sendFile(filename, offset, length).await().indefinitely();
  }

  /**
   */
  public void close() { 
    delegate.close();
  }

  /**
   * @return has the response already ended?
   */
  public boolean ended() { 
    boolean ret = delegate.ended();
    return ret;
  }

  /**
   * @return has the underlying TCP connection corresponding to the request already been closed?
   */
  public boolean closed() { 
    boolean ret = delegate.closed();
    return ret;
  }

  /**
   * @return have the headers for the response already been written?
   */
  public boolean headWritten() { 
    boolean ret = delegate.headWritten();
    return ret;
  }

  /**
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  private io.vertx.mutiny.core.http.HttpServerResponse __headersEndHandler(Handler<Void> handler) { 
    delegate.headersEndHandler(handler);
    return this;
  }

  /**
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.http.HttpServerResponse headersEndHandler(Consumer<Void> handler) {
    return __headersEndHandler(handler != null ? handler::accept : null);
  }

  /**
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  private io.vertx.mutiny.core.http.HttpServerResponse __bodyEndHandler(Handler<Void> handler) { 
    delegate.bodyEndHandler(handler);
    return this;
  }

  /**
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.http.HttpServerResponse bodyEndHandler(Consumer<Void> handler) {
    return __bodyEndHandler(handler != null ? handler::accept : null);
  }

  /**
   * @return the total number of bytes written for the body of the response.
   */
  public long bytesWritten() { 
    long ret = delegate.bytesWritten();
    return ret;
  }

  /**
   * @return the id of the stream of this response,  for HTTP/1.x
   */
  public int streamId() { 
    int ret = delegate.streamId();
    return ret;
  }

  /**
   * @param method 
   * @param host 
   * @param path 
   * @param handler 
   * @return 
   */
  private io.vertx.mutiny.core.http.HttpServerResponse __push(HttpMethod method, String host, String path, Handler<AsyncResult<io.vertx.mutiny.core.http.HttpServerResponse>> handler) { 
    delegate.push(method, host, path, new Handler<AsyncResult<io.vertx.core.http.HttpServerResponse>>() {
      public void handle(AsyncResult<io.vertx.core.http.HttpServerResponse> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.core.http.HttpServerResponse.newInstance(ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Like {@link io.vertx.mutiny.core.http.HttpServerResponse#push} with no headers.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param method 
   * @param host 
   * @param path 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  public Uni<io.vertx.mutiny.core.http.HttpServerResponse> push(HttpMethod method, String host, String path) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __push(method, host, path, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.http.HttpServerResponse#push(HttpMethod,String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param method 
   * @param host 
   * @param path 
   * @return the HttpServerResponse instance produced by the operation
   */
  public io.vertx.mutiny.core.http.HttpServerResponse pushAndAwait(HttpMethod method, String host, String path) { 
    return (io.vertx.mutiny.core.http.HttpServerResponse) push(method, host, path).await().indefinitely();
  }

  /**
   * @param method 
   * @param path 
   * @param headers 
   * @param handler 
   * @return 
   */
  private io.vertx.mutiny.core.http.HttpServerResponse __push(HttpMethod method, String path, io.vertx.mutiny.core.MultiMap headers, Handler<AsyncResult<io.vertx.mutiny.core.http.HttpServerResponse>> handler) { 
    delegate.push(method, path, headers.getDelegate(), new Handler<AsyncResult<io.vertx.core.http.HttpServerResponse>>() {
      public void handle(AsyncResult<io.vertx.core.http.HttpServerResponse> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.core.http.HttpServerResponse.newInstance(ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Like {@link io.vertx.mutiny.core.http.HttpServerResponse#push} with the host copied from the current request.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param method 
   * @param path 
   * @param headers 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  public Uni<io.vertx.mutiny.core.http.HttpServerResponse> push(HttpMethod method, String path, io.vertx.mutiny.core.MultiMap headers) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __push(method, path, headers, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.http.HttpServerResponse#push(HttpMethod,String,io.vertx.mutiny.core.MultiMap)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param method 
   * @param path 
   * @param headers 
   * @return the HttpServerResponse instance produced by the operation
   */
  public io.vertx.mutiny.core.http.HttpServerResponse pushAndAwait(HttpMethod method, String path, io.vertx.mutiny.core.MultiMap headers) { 
    return (io.vertx.mutiny.core.http.HttpServerResponse) push(method, path, headers).await().indefinitely();
  }

  /**
   * @param method 
   * @param path 
   * @param handler 
   * @return 
   */
  private io.vertx.mutiny.core.http.HttpServerResponse __push(HttpMethod method, String path, Handler<AsyncResult<io.vertx.mutiny.core.http.HttpServerResponse>> handler) { 
    delegate.push(method, path, new Handler<AsyncResult<io.vertx.core.http.HttpServerResponse>>() {
      public void handle(AsyncResult<io.vertx.core.http.HttpServerResponse> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.core.http.HttpServerResponse.newInstance(ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Like {@link io.vertx.mutiny.core.http.HttpServerResponse#push} with the host copied from the current request.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param method 
   * @param path 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  public Uni<io.vertx.mutiny.core.http.HttpServerResponse> push(HttpMethod method, String path) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __push(method, path, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.http.HttpServerResponse#push(HttpMethod,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param method 
   * @param path 
   * @return the HttpServerResponse instance produced by the operation
   */
  public io.vertx.mutiny.core.http.HttpServerResponse pushAndAwait(HttpMethod method, String path) { 
    return (io.vertx.mutiny.core.http.HttpServerResponse) push(method, path).await().indefinitely();
  }

  /**
   * @param method the method of the promised request
   * @param host the host of the promised request
   * @param path the path of the promised request
   * @param headers the headers of the promised request
   * @param handler the handler notified when the response can be written
   * @return a reference to this, so the API can be used fluently
   */
  private io.vertx.mutiny.core.http.HttpServerResponse __push(HttpMethod method, String host, String path, io.vertx.mutiny.core.MultiMap headers, Handler<AsyncResult<io.vertx.mutiny.core.http.HttpServerResponse>> handler) { 
    delegate.push(method, host, path, headers.getDelegate(), new Handler<AsyncResult<io.vertx.core.http.HttpServerResponse>>() {
      public void handle(AsyncResult<io.vertx.core.http.HttpServerResponse> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.core.http.HttpServerResponse.newInstance(ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Push a response to the client.<p/>
   *
   * The <code>handler</code> will be notified with a <i>success</i> when the push can be sent and with
   * a <i>failure</i> when the client has disabled push or reset the push before it has been sent.<p/>
   *
   * The <code>handler</code> may be queued if the client has reduced the maximum number of streams the server can push
   * concurrently.<p/>
   *
   * Push can be sent only for peer initiated streams and if the response is not ended.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param method the method of the promised request
   * @param host the host of the promised request
   * @param path the path of the promised request
   * @param headers the headers of the promised request
   * @return a reference to this, so the API can be used fluently
   */
  public Uni<io.vertx.mutiny.core.http.HttpServerResponse> push(HttpMethod method, String host, String path, io.vertx.mutiny.core.MultiMap headers) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __push(method, host, path, headers, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.http.HttpServerResponse#push(HttpMethod,String,String,io.vertx.mutiny.core.MultiMap)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param method the method of the promised request
   * @param host the host of the promised request
   * @param path the path of the promised request
   * @param headers the headers of the promised request
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.http.HttpServerResponse pushAndAwait(HttpMethod method, String host, String path, io.vertx.mutiny.core.MultiMap headers) { 
    return (io.vertx.mutiny.core.http.HttpServerResponse) push(method, host, path, headers).await().indefinitely();
  }

  /**
   */
  public void reset() { 
    delegate.reset();
  }

  /**
   * @param code the error code
   */
  public void reset(long code) { 
    delegate.reset(code);
  }

  /**
   * @param type the 8-bit frame type
   * @param flags the 8-bit frame flags
   * @param payload the frame payload
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.http.HttpServerResponse writeCustomFrame(int type, int flags, io.vertx.mutiny.core.buffer.Buffer payload) { 
    delegate.writeCustomFrame(type, flags, payload.getDelegate());
    return this;
  }

  /**
   * @param frame the frame to write
   * @return 
   */
  public io.vertx.mutiny.core.http.HttpServerResponse writeCustomFrame(io.vertx.mutiny.core.http.HttpFrame frame) { 
    delegate.writeCustomFrame(frame.getDelegate());
    return this;
  }

  /**
   * @param streamPriority the priority for this request's stream
   * @return 
   */
  public io.vertx.mutiny.core.http.HttpServerResponse setStreamPriority(StreamPriority streamPriority) { 
    delegate.setStreamPriority(streamPriority);
    return this;
  }

  /**
   * @param cookie the cookie
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.http.HttpServerResponse addCookie(io.vertx.mutiny.core.http.Cookie cookie) { 
    delegate.addCookie(cookie.getDelegate());
    return this;
  }

  /**
   * @param name the name of the cookie
   * @return the cookie, if it existed, or null
   */
  public io.vertx.mutiny.core.http.Cookie removeCookie(String name) { 
    io.vertx.mutiny.core.http.Cookie ret = io.vertx.mutiny.core.http.Cookie.newInstance(delegate.removeCookie(name));
    return ret;
  }

  /**
   * @param name the name of the cookie
   * @param invalidate 
   * @return the cookie, if it existed, or null
   */
  public io.vertx.mutiny.core.http.Cookie removeCookie(String name, boolean invalidate) { 
    io.vertx.mutiny.core.http.Cookie ret = io.vertx.mutiny.core.http.Cookie.newInstance(delegate.removeCookie(name, invalidate));
    return ret;
  }

  /**
   * @param name 
   * @param value 
   * @return 
   */
  public io.vertx.mutiny.core.http.HttpServerResponse putHeader(CharSequence name, CharSequence value) { 
    delegate.putHeader(name, value);
    return this;
  }

  /**
   * @param name 
   * @param values 
   * @return 
   */
  public io.vertx.mutiny.core.http.HttpServerResponse putHeader(String name, Iterable<String> values) { 
    delegate.putHeader(name, values);
    return this;
  }

  /**
   * @param name 
   * @param values 
   * @return 
   */
  public io.vertx.mutiny.core.http.HttpServerResponse putHeader(CharSequence name, Iterable<CharSequence> values) { 
    delegate.putHeader(name, values);
    return this;
  }

  /**
   * @param name 
   * @param value 
   * @return 
   */
  public io.vertx.mutiny.core.http.HttpServerResponse putTrailer(CharSequence name, CharSequence value) { 
    delegate.putTrailer(name, value);
    return this;
  }

  /**
   * @param name 
   * @param values 
   * @return 
   */
  public io.vertx.mutiny.core.http.HttpServerResponse putTrailer(String name, Iterable<String> values) { 
    delegate.putTrailer(name, values);
    return this;
  }

  /**
   * @param name 
   * @param value 
   * @return 
   */
  public io.vertx.mutiny.core.http.HttpServerResponse putTrailer(CharSequence name, Iterable<CharSequence> value) { 
    delegate.putTrailer(name, value);
    return this;
  }

  public io.vertx.mutiny.core.http.HttpServerResponse writeAndForget(io.vertx.mutiny.core.buffer.Buffer data) { 
    delegate.write(data.getDelegate());
    return this;
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.http.HttpServerResponse#write(String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.http.HttpServerResponse#write(String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.http.HttpServerResponse#write(String,String)} but you don't need to compose it with other operations.
   * @param chunk the string to write
   * @param enc the encoding to use
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.http.HttpServerResponse writeAndForget(String chunk, String enc) { 
    delegate.write(chunk, enc);
    return this;
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.http.HttpServerResponse#write(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.http.HttpServerResponse#write(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.http.HttpServerResponse#write(String)} but you don't need to compose it with other operations.
   * @param chunk the string to write
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.http.HttpServerResponse writeAndForget(String chunk) { 
    delegate.write(chunk);
    return this;
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.http.HttpServerResponse#end(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.http.HttpServerResponse#end(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.http.HttpServerResponse#end(String)} but you don't need to compose it with other operations.
   * @param chunk the string to write before ending the response
   */
  public void endAndForget(String chunk) { 
    delegate.end(chunk);
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.http.HttpServerResponse#end(String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.http.HttpServerResponse#end(String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.http.HttpServerResponse#end(String,String)} but you don't need to compose it with other operations.
   * @param chunk the string to write before ending the response
   * @param enc the encoding to use
   */
  public void endAndForget(String chunk, String enc) { 
    delegate.end(chunk, enc);
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.http.HttpServerResponse#end(io.vertx.mutiny.core.buffer.Buffer)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.http.HttpServerResponse#end(io.vertx.mutiny.core.buffer.Buffer)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.http.HttpServerResponse#end(io.vertx.mutiny.core.buffer.Buffer)} but you don't need to compose it with other operations.
   * @param chunk the buffer to write before ending the response
   */
  public void endAndForget(io.vertx.mutiny.core.buffer.Buffer chunk) { 
    delegate.end(chunk.getDelegate());
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.http.HttpServerResponse#end} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.http.HttpServerResponse#end}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.http.HttpServerResponse#end} but you don't need to compose it with other operations.
   */
  public void endAndForget() { 
    delegate.end();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.http.HttpServerResponse#sendFile(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.http.HttpServerResponse#sendFile(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.http.HttpServerResponse#sendFile(String)} but you don't need to compose it with other operations.
   * @param filename path to the file to serve
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.http.HttpServerResponse sendFileAndForget(String filename) { 
    delegate.sendFile(filename);
    return this;
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.http.HttpServerResponse#sendFile(String,long)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.http.HttpServerResponse#sendFile(String,long)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.http.HttpServerResponse#sendFile(String,long)} but you don't need to compose it with other operations.
   * @param filename path to the file to serve
   * @param offset offset to start serving from
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.http.HttpServerResponse sendFileAndForget(String filename, long offset) { 
    delegate.sendFile(filename, offset);
    return this;
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.http.HttpServerResponse#sendFile(String,long,long)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.http.HttpServerResponse#sendFile(String,long,long)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.http.HttpServerResponse#sendFile(String,long,long)} but you don't need to compose it with other operations.
   * @param filename path to the file to serve
   * @param offset offset to start serving from
   * @param length the number of bytes to send
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.http.HttpServerResponse sendFileAndForget(String filename, long offset, long length) { 
    delegate.sendFile(filename, offset, length);
    return this;
  }

  private io.vertx.mutiny.core.MultiMap cached_0;
  private io.vertx.mutiny.core.MultiMap cached_1;
  public static  HttpServerResponse newInstance(io.vertx.core.http.HttpServerResponse arg) {
    return arg != null ? new HttpServerResponse(arg) : null;
  }

}
