package io.vertx.mutiny.core.eventbus;

import java.util.Map;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Publisher;

/**
 *
 * Encapsulates a message being delivered by Vert.x as well as providing control over the message delivery.
 * <p/>
 * Used with event bus interceptors.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.eventbus.DeliveryContext original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.core.eventbus.DeliveryContext.class)
public class DeliveryContext<T> {

  public static final io.smallrye.mutiny.vertx.TypeArg<DeliveryContext> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new DeliveryContext((io.vertx.core.eventbus.DeliveryContext) obj),
    DeliveryContext::getDelegate
  );

  private final io.vertx.core.eventbus.DeliveryContext<T> delegate;
  public final io.smallrye.mutiny.vertx.TypeArg<T> __typeArg_0;
  
  public DeliveryContext(io.vertx.core.eventbus.DeliveryContext delegate) {
    this.delegate = delegate;
    this.__typeArg_0 = io.smallrye.mutiny.vertx.TypeArg.unknown();  }

  public DeliveryContext(io.vertx.core.eventbus.DeliveryContext delegate, io.smallrye.mutiny.vertx.TypeArg<T> typeArg_0) {
    this.delegate = delegate;
    this.__typeArg_0 = typeArg_0;
  }

  /**
  * Empty constructor used by CDI, do not use this constructor directly.
  **/
  DeliveryContext() {    this.delegate = null;
    this.__typeArg_0 = io.smallrye.mutiny.vertx.TypeArg.unknown();  }

  public io.vertx.core.eventbus.DeliveryContext getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    DeliveryContext that = (DeliveryContext) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @return The message being delivered
   */
  public io.vertx.mutiny.core.eventbus.Message<T> message() { 
    io.vertx.mutiny.core.eventbus.Message<T> ret = io.vertx.mutiny.core.eventbus.Message.newInstance(delegate.message(), __typeArg_0);
    return ret;
  }

  /**
   */
  public void next() { 
    delegate.next();
  }

  /**
   * @return true if the message is being sent (point to point) or False if the message is being published
   */
  public boolean send() { 
    boolean ret = delegate.send();
    return ret;
  }

  /**
   * @return the value delivered by the message (before or after being processed by the codec)
   */
  public Object body() { 
    Object ret = (Object) delegate.body();
    return ret;
  }

  public static <T>DeliveryContext<T> newInstance(io.vertx.core.eventbus.DeliveryContext arg) {
    return arg != null ? new DeliveryContext<T>(arg) : null;
  }


  public static <T>DeliveryContext<T> newInstance(io.vertx.core.eventbus.DeliveryContext arg, io.smallrye.mutiny.vertx.TypeArg<T> __typeArg_T) {
    return arg != null ? new DeliveryContext<T>(arg, __typeArg_T) : null;
  }

}
