package io.vertx.mutiny.core;

import java.util.Map;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Publisher;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

/**
 * An executor for executing blocking code in Vert.x .<p>
 *
 * It provides the same <code>executeBlocking</code> operation than {@link io.vertx.mutiny.core.Context} and
 * {@link io.vertx.mutiny.core.Vertx} but on a separate worker pool.<p>
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.WorkerExecutor original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.core.WorkerExecutor.class)
public class WorkerExecutor implements io.vertx.mutiny.core.metrics.Measured {

  public static final io.smallrye.mutiny.vertx.TypeArg<WorkerExecutor> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new WorkerExecutor((io.vertx.core.WorkerExecutor) obj),
    WorkerExecutor::getDelegate
  );

  private final io.vertx.core.WorkerExecutor delegate;
  
  public WorkerExecutor(io.vertx.core.WorkerExecutor delegate) {
    this.delegate = delegate;
  }

  /**
  * Empty constructor used by CDI, do not use this constructor directly.
  **/
  WorkerExecutor() {    this.delegate = null;
  }

  public io.vertx.core.WorkerExecutor getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    WorkerExecutor that = (WorkerExecutor) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @return <code>true</code> if metrics are enabled
   */
  public boolean isMetricsEnabled() { 
    boolean ret = delegate.isMetricsEnabled();
    return ret;
  }

  /**
   * @param blockingCodeHandler handler representing the blocking code to run
   * @param ordered if true then if executeBlocking is called several times on the same context, the executions for that context will be executed serially, not in parallel. if false then they will be no ordering guarantees
   * @param resultHandler handler that will be called when the blocking code is complete
   */
  private <T> void __executeBlocking(Handler<io.vertx.mutiny.core.Promise<T>> blockingCodeHandler, boolean ordered, Handler<AsyncResult<T>> resultHandler) { 
    delegate.executeBlocking(new Handler<io.vertx.core.Promise<T>>() {
      public void handle(io.vertx.core.Promise<T> event) {
        blockingCodeHandler.handle(io.vertx.mutiny.core.Promise.newInstance(event, io.smallrye.mutiny.vertx.TypeArg.unknown()));
      }
    }, ordered, resultHandler);
  }

  /**
   * Safely execute some blocking code.
   * <p>
   * Executes the blocking code in the handler <code>blockingCodeHandler</code> using a thread from the worker pool.
   * <p>
   * When the code is complete the handler <code>resultHandler</code> will be called with the result on the original context
   * (i.e. on the original event loop of the caller).
   * <p>
   * A <code>Future</code> instance is passed into <code>blockingCodeHandler</code>. When the blocking code successfully completes,
   * the handler should call the {@link io.vertx.mutiny.core.Promise#complete} or {@link io.vertx.mutiny.core.Promise#complete} method, or the {@link io.vertx.mutiny.core.Promise#fail}
   * method if it failed.
   * <p>
   * In the <code>blockingCodeHandler</code> the current context remains the original context and therefore any task
   * scheduled in the <code>blockingCodeHandler</code> will be executed on the this context and not on the worker thread.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param blockingCodeHandler handler representing the blocking code to run
   * @param ordered if true then if executeBlocking is called several times on the same context, the executions for that context will be executed serially, not in parallel. if false then they will be no ordering guarantees
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  public <T> Uni<T> executeBlocking(Handler<io.vertx.mutiny.core.Promise<T>> blockingCodeHandler, boolean ordered) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __executeBlocking(blockingCodeHandler, ordered, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.WorkerExecutor#executeBlocking(Handler<Promise<T>>,boolean)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param blockingCodeHandler handler representing the blocking code to run
   * @param ordered if true then if executeBlocking is called several times on the same context, the executions for that context will be executed serially, not in parallel. if false then they will be no ordering guarantees
   * @return the T instance produced by the operation
   */
  public <T> T executeBlockingAndAwait(Handler<io.vertx.mutiny.core.Promise<T>> blockingCodeHandler, boolean ordered) { 
    return (T) executeBlocking(blockingCodeHandler, ordered).await().indefinitely();
  }

  /**
   * @param blockingCodeHandler 
   * @param resultHandler 
   */
  private <T> void __executeBlocking(Handler<io.vertx.mutiny.core.Promise<T>> blockingCodeHandler, Handler<AsyncResult<T>> resultHandler) { 
    delegate.executeBlocking(new Handler<io.vertx.core.Promise<T>>() {
      public void handle(io.vertx.core.Promise<T> event) {
        blockingCodeHandler.handle(io.vertx.mutiny.core.Promise.newInstance(event, io.smallrye.mutiny.vertx.TypeArg.unknown()));
      }
    }, resultHandler);
  }

  /**
   * Like {@link io.vertx.mutiny.core.WorkerExecutor#executeBlocking} called with ordered = true.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param blockingCodeHandler 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  public <T> Uni<T> executeBlocking(Handler<io.vertx.mutiny.core.Promise<T>> blockingCodeHandler) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __executeBlocking(blockingCodeHandler, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.WorkerExecutor#executeBlocking(Handler<Promise<T>>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param blockingCodeHandler 
   * @return the T instance produced by the operation
   */
  public <T> T executeBlockingAndAwait(Handler<io.vertx.mutiny.core.Promise<T>> blockingCodeHandler) { 
    return (T) executeBlocking(blockingCodeHandler).await().indefinitely();
  }

  /**
   */
  public void close() { 
    delegate.close();
  }

  public static  WorkerExecutor newInstance(io.vertx.core.WorkerExecutor arg) {
    return arg != null ? new WorkerExecutor(arg) : null;
  }

}
