/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config;

import io.smallrye.common.annotation.Experimental;
import io.smallrye.config.AbstractLocationConfigSourceLoader;
import io.smallrye.config.ConfigLogging;
import io.smallrye.config.ConfigSourceContext;
import io.smallrye.config.ConfigSourceFactory;
import io.smallrye.config.ConfigValue;
import io.smallrye.config.Converters;
import java.util.Collections;
import java.util.List;
import org.eclipse.microprofile.config.spi.ConfigSource;

@Experimental(value="Loads additional config locations")
public abstract class AbstractLocationConfigSourceFactory
extends AbstractLocationConfigSourceLoader
implements ConfigSourceFactory {
    @Override
    public Iterable<ConfigSource> getConfigSources(ConfigSourceContext context) {
        ConfigValue value = context.getValue("smallrye.config.locations");
        if (value.getValue() == null) {
            return Collections.emptyList();
        }
        List<ConfigSource> configSources = this.loadConfigSources((String[])Converters.newArrayConverter(Converters.STRING_CONVERTER, String[].class).convert(value.getValue()), value.getConfigSourceOrdinal());
        if (configSources.isEmpty()) {
            ConfigLogging.log.configLocationsNotFound("smallrye.config.locations", value.getValue());
        }
        return configSources;
    }
}

