package io.smallrye.common.io;

import java.util.Locale;
import java.nio.file.Path;
import java.io.Serializable;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.BasicLogger;
import java.nio.file.FileSystem;
import org.jboss.logging.Logger;
import java.util.Arrays;
import java.lang.UnsupportedOperationException;

/**
 * Warning this class consists of generated code.
 */
public class Messages_$logger extends DelegatingBasicLogger implements Messages, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Messages_$logger.class.getName();
    public Messages_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    protected String secureDirectoryNotSupported$str() {
        return "SRCOM04000: Secure directory streams not supported by %s for path \"%s\"";
    }
    @Override
    public final UnsupportedOperationException secureDirectoryNotSupported(final FileSystem fileSystem, final Path path) {
        final UnsupportedOperationException result = new UnsupportedOperationException(String.format(getLoggingLocale(), secureDirectoryNotSupported$str(), fileSystem, path));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        if (st.length > 0) e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
}
