/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.beanbag.sisu;

import io.smallrye.beanbag.BeanBag;
import io.smallrye.beanbag.BeanSupplier;
import io.smallrye.beanbag.DependencyFilter;
import io.smallrye.beanbag.sisu.BeanLoadingTaskRunner;
import io.smallrye.common.constraint.Assert;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import javax.inject.Provider;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public final class Sisu {
    private final Map<Class<?>, Class<?>> visited = new ConcurrentHashMap();
    private final BeanBag.Builder builder;
    private static final ClassValue<Class<?>> arrayTypes = new ClassValue<Class<?>>(){

        @Override
        protected Class<?> computeValue(Class<?> type) {
            return Array.newInstance(type, 0).getClass();
        }
    };
    private static final ClassValue<Function<Annotation, String>> GET_NAMED_VALUE_FN = new ClassValue<Function<Annotation, String>>(){

        @Override
        protected Function<Annotation, String> computeValue(Class<?> type) {
            return new MethodFunction<String>(type, "javax.inject.Named");
        }
    };
    private static final ClassValue<Function<Annotation, Integer>> GET_PRIORITY_VALUE_FN = new ClassValue<Function<Annotation, Integer>>(){

        @Override
        protected Function<Annotation, Integer> computeValue(Class<?> type) {
            return new MethodFunction<Integer>(type, "org.eclipse.sisu.Priority");
        }
    };
    private static final ClassValue<Function<Annotation, Class<?>[]>> GET_TYPED_VALUE_FN = new ClassValue<Function<Annotation, Class<?>[]>>(){

        @Override
        protected Function<Annotation, Class<?>[]> computeValue(Class<?> type) {
            return new MethodFunction<Class<?>[]>(type, "org.eclipse.sisu.Typed");
        }
    };

    private Sisu(BeanBag.Builder builder) {
        this.builder = builder;
    }

    public void addClassLoader(ClassLoader classLoader, DependencyFilter filter) {
        Assert.checkNotNullParam((String)"classLoader", (Object)classLoader);
        Assert.checkNotNullParam((String)"filter", (Object)filter);
        BeanLoadingTaskRunner taskRunner = new BeanLoadingTaskRunner();
        this.loadBeans(classLoader, "META-INF/sisu/javax.inject.Named", url -> this.addNamed(classLoader, filter, url), taskRunner);
        this.loadBeans(classLoader, "META-INF/plexus/components.xml", url -> this.addPlexusComponents(classLoader, filter, url), taskRunner);
        taskRunner.waitForCompletion();
    }

    private void loadBeans(ClassLoader classLoader, String resource, BeanLoader beanLoader, BeanLoadingTaskRunner taskRunner) {
        taskRunner.run(() -> {
            Enumeration<URL> e = classLoader.getResources(resource);
            while (e.hasMoreElements()) {
                URL url = e.nextElement();
                taskRunner.run(() -> beanLoader.loadBeans(url));
            }
        });
    }

    private void addPlexusComponents(ClassLoader classLoader, DependencyFilter filter, URL url) throws IOException {
        URLConnection conn = url.openConnection();
        HashMap map = new HashMap();
        try (InputStream is = conn.getInputStream();
             InputStreamReader isr = new InputStreamReader(is, StandardCharsets.UTF_8);){
            try (BufferedReader br = new BufferedReader(isr);){
                XMLStreamReader xr = XMLInputFactory.newDefaultFactory().createXMLStreamReader(br);
                try (XMLCloser ignored = xr::close;){
                    while (xr.hasNext()) {
                        if (xr.next() != 1) continue;
                        if (xr.getLocalName().equals("component-set")) {
                            this.parseComponentSet(xr, map, classLoader, filter);
                            continue;
                        }
                        this.consume(xr);
                    }
                }
            }
            catch (XMLStreamException ex) {
                throw new RuntimeException(ex);
            }
        }
        for (Component component : map.values()) {
            try {
                this.addBeanFromXml(component, filter, classLoader);
            }
            catch (LinkageError linkageError) {}
        }
    }

    private void addNamed(ClassLoader classLoader, DependencyFilter filter, URL url) throws IOException {
        block21: {
            URLConnection conn = url.openConnection();
            try (InputStream is = conn.getInputStream();
                 InputStreamReader isr = new InputStreamReader(is, StandardCharsets.UTF_8);){
                BufferedReader br = new BufferedReader(isr);
                block17: while (true) {
                    String line;
                    while ((line = br.readLine()) != null) {
                        String className;
                        int idx = line.indexOf(35);
                        if (idx != -1) {
                            line = line.substring(0, idx);
                        }
                        if ((className = line.trim()).isBlank() || this.builder.isTypeFilteredOut(className)) continue;
                        try {
                            Class<?> clazz = Class.forName(className, false, classLoader);
                            this.addClass(clazz, filter);
                            continue block17;
                        }
                        catch (ClassNotFoundException | LinkageError throwable) {
                        }
                    }
                    break block21;
                    {
                        continue block17;
                        break;
                    }
                    break;
                }
                finally {
                    br.close();
                }
            }
        }
    }

    private void consume(XMLStreamReader xr) throws XMLStreamException {
        while (xr.hasNext()) {
            switch (xr.next()) {
                case 2: {
                    return;
                }
                case 1: {
                    this.consume(xr);
                }
            }
        }
    }

    private void parseComponentSet(XMLStreamReader xr, Map<Class<?>, Component<?>> map, ClassLoader classLoader, DependencyFilter filter) throws XMLStreamException {
        while (xr.hasNext()) {
            switch (xr.next()) {
                case 2: {
                    return;
                }
                case 1: {
                    if (xr.getLocalName().equals("components")) {
                        this.parseComponents(xr, map, classLoader, filter);
                        break;
                    }
                    this.consume(xr);
                }
            }
        }
    }

    private void parseComponents(XMLStreamReader xr, Map<Class<?>, Component<?>> map, ClassLoader classLoader, DependencyFilter filter) throws XMLStreamException {
        while (xr.hasNext()) {
            switch (xr.next()) {
                case 2: {
                    return;
                }
                case 1: {
                    if (xr.getLocalName().equals("component")) {
                        this.parseComponent(xr, map, classLoader, filter);
                        break;
                    }
                    this.consume(xr);
                }
            }
        }
    }

    private void parseComponent(XMLStreamReader xr, Map<Class<?>, Component<?>> map, ClassLoader classLoader, DependencyFilter filter) throws XMLStreamException {
        Component<Object> component;
        Class<?> clazz = null;
        Class<?> type = null;
        String name = null;
        boolean singleton = false;
        List<Requirement> requirements = List.of();
        block34: while (xr.hasNext()) {
            switch (xr.next()) {
                case 2: {
                    break block34;
                }
                case 1: {
                    block14 : switch (xr.getLocalName()) {
                        case "implementation": {
                            String className;
                            if (clazz == null) {
                                className = xr.getElementText();
                                if (this.builder.isTypeFilteredOut(className)) continue block34;
                                try {
                                    clazz = Class.forName(className, false, classLoader);
                                }
                                catch (ClassNotFoundException | LinkageError ex) {
                                    continue block34;
                                }
                                if (new Annotations(clazz).getNamed() == null) break;
                                try {
                                    this.addClass(clazz, filter);
                                }
                                catch (LinkageError ex) {
                                    // empty catch block
                                }
                                this.consume(xr);
                                return;
                            }
                            this.consume(xr);
                            break;
                        }
                        case "role": {
                            String className;
                            if (type == null) {
                                className = xr.getElementText();
                                if (this.builder.isTypeFilteredOut(className)) continue block34;
                                try {
                                    type = Class.forName(className, false, classLoader);
                                    break;
                                }
                                catch (ClassNotFoundException | LinkageError ex) {
                                    continue block34;
                                }
                            }
                            this.consume(xr);
                            break;
                        }
                        case "role-hint": {
                            if (name == null) {
                                name = xr.getElementText();
                                if (!name.equals("default")) break;
                                name = "";
                                break;
                            }
                            this.consume(xr);
                            break;
                        }
                        case "instantiation-strategy": {
                            switch (xr.getElementText()) {
                                case "per-lookup": {
                                    singleton = false;
                                    break block14;
                                }
                                case "poolable": 
                                case "keep-alive": 
                                case "singleton": {
                                    singleton = true;
                                }
                            }
                            break;
                        }
                        case "requirements": {
                            requirements = this.parseRequirements(xr, classLoader, filter);
                            break;
                        }
                        default: {
                            this.consume(xr);
                        }
                    }
                }
                default: {
                    continue block34;
                }
            }
        }
        if (clazz == null || clazz.isInterface()) {
            if (type == null || type.isInterface()) {
                return;
            }
            clazz = type;
        }
        if ((component = map.get(clazz)) == null) {
            component = Component.of(clazz, type, name, singleton, requirements);
            map.put(clazz, component);
        } else {
            assert (clazz == component.clazz);
            if (component.types != null) {
                component.types.add(type);
            }
            if (name != null && !name.equals(component.name)) {
                Set<String> aliases = component.aliases;
                if (aliases == null) {
                    aliases = component.aliases = new HashSet<String>();
                }
                aliases.add(name);
            }
            component.requirements = Sisu.concatenate(component.requirements, requirements);
        }
    }

    static <T> List<T> concatenate(List<T> a, List<T> b) {
        if (a.isEmpty()) {
            if (b.isEmpty()) {
                return List.of();
            }
            return b;
        }
        if (b.isEmpty()) {
            return a;
        }
        ArrayList<T> out = new ArrayList<T>(a.size() + b.size());
        out.addAll(a);
        out.addAll(b);
        return List.copyOf(out);
    }

    private List<Requirement> parseRequirements(XMLStreamReader xr, ClassLoader classLoader, DependencyFilter filter) throws XMLStreamException {
        ArrayList<Requirement> list = null;
        block10: while (xr.hasNext()) {
            switch (xr.next()) {
                case 2: {
                    break block10;
                }
                case 1: {
                    switch (xr.getLocalName()) {
                        case "requirement": {
                            if (list == null) {
                                list = new ArrayList<Requirement>();
                            }
                            list.add(this.parseRequirement(xr, classLoader, filter));
                            break;
                        }
                        default: {
                            this.consume(xr);
                        }
                    }
                }
                default: {
                    continue block10;
                }
            }
        }
        return list == null ? List.of() : List.copyOf(list);
    }

    private Requirement parseRequirement(XMLStreamReader xr, ClassLoader classLoader, DependencyFilter filter) throws XMLStreamException {
        Requirement requirement = new Requirement();
        while (xr.hasNext()) {
            block0 : switch (xr.next()) {
                case 2: {
                    return requirement;
                }
                case 1: {
                    switch (xr.getLocalName()) {
                        case "role": {
                            requirement.injectType = xr.getElementText();
                            break block0;
                        }
                        case "role-hint": {
                            requirement.injectName = xr.getElementText();
                            if (!requirement.injectName.equals("default")) break block0;
                            requirement.injectName = "";
                            break block0;
                        }
                        case "field": 
                        case "field-name": {
                            requirement.fieldName = xr.getElementText();
                            break block0;
                        }
                    }
                    this.consume(xr);
                }
            }
        }
        return null;
    }

    private <T> void addBeanFromXml(Component<T> component, DependencyFilter filter, ClassLoader classLoader) {
        Class clazz = component.clazz;
        BeanBag.BeanBuilder beanBuilder = this.builder.addBean(clazz);
        Annotations clazzAnnotations = Annotations.of(clazz);
        if (component.singleton) {
            beanBuilder.setSingleton(true);
        }
        if (component.name != null && !component.name.isEmpty()) {
            beanBuilder.setName(component.name);
        }
        if (component.aliases != null) {
            component.aliases.forEach(arg_0 -> ((BeanBag.BeanBuilder)beanBuilder).addAlias(arg_0));
        }
        if (component.types != null) {
            beanBuilder.addRestrictedTypes(List.copyOf(component.types));
        }
        BeanBag.SupplierBuilder supplierBuilder = beanBuilder.buildSupplier();
        Constructor ctor = Sisu.findConstructor(clazz);
        for (Parameter parameter : ctor.getParameters()) {
            Annotations paramAnnotations = Annotations.of(parameter);
            boolean optional = paramAnnotations.isNullable();
            String paramNamed = paramAnnotations.getNamed();
            String name = paramNamed == null ? "" : paramNamed;
            Class<?> parameterType = parameter.getType();
            supplierBuilder.addConstructorArgument(Sisu.getSupplier(parameterType, parameter.getParameterizedType(), name, optional, filter));
        }
        supplierBuilder.setConstructor(ctor);
        Sisu.addFieldInjections(clazz, supplierBuilder, filter);
        Sisu.addMethodInjections(clazz, supplierBuilder, filter);
        HashMap<String, Field> injectableFields = new HashMap<String, Field>();
        for (Class cur = clazz; cur != null; cur = cur.getSuperclass()) {
            Module module = cur.getModule();
            if (!module.isOpen(cur.getPackageName(), Sisu.class.getModule())) continue;
            Field[] declaredFields = cur.getDeclaredFields();
            boolean open = cur.getModule().isOpen(cur.getPackageName(), Sisu.class.getModule());
            for (Field declaredField : declaredFields) {
                int mods = declaredField.getModifiers();
                if (Modifier.isStatic(mods) || Modifier.isFinal(mods) || injectableFields.containsKey(declaredField.getName()) || !Modifier.isPublic(mods) && !open) continue;
                injectableFields.put(declaredField.getName(), declaredField);
            }
        }
        for (Requirement req : component.requirements) {
            Field field;
            String fieldName = req.fieldName;
            if (fieldName == null || (field = (Field)injectableFields.get(fieldName)) == null || !field.trySetAccessible()) continue;
            Class<?> fieldType = field.getType();
            if (req.injectType != null) {
                try {
                    fieldType = Class.forName(req.injectType, false, classLoader);
                }
                catch (ClassNotFoundException paramNamed) {
                    // empty catch block
                }
            }
            String name = Objects.requireNonNullElse(req.injectName, "");
            supplierBuilder.injectField(field, Sisu.getSupplier(fieldType, field.getGenericType(), name, false, filter));
        }
        supplierBuilder.build();
        beanBuilder.build();
        for (Type genericInterface : clazz.getGenericInterfaces()) {
            if (Sisu.getRawType(genericInterface) != Provider.class) continue;
            Sisu.addOneProvider(this.builder, genericInterface, clazz.asSubclass(Provider.class), clazzAnnotations);
        }
    }

    public <T> void addClass(Class<T> clazz, DependencyFilter filter) {
        List<Class<?>> typed;
        Assert.checkNotNullParam((String)"clazz", clazz);
        Assert.checkNotNullParam((String)"filter", (Object)filter);
        if (this.visited.putIfAbsent(clazz, clazz) != null) {
            return;
        }
        BeanBag.BeanBuilder beanBuilder = this.builder.addBean(clazz);
        Annotations clazzAnnotations = Annotations.of(clazz);
        String named = clazzAnnotations.getNamed();
        if (named != null) {
            beanBuilder.setName(named);
        }
        if ((typed = clazzAnnotations.getTyped()) != null) {
            beanBuilder.addRestrictedTypes(typed);
        }
        if (clazzAnnotations.isSingleton()) {
            beanBuilder.setSingleton(true);
        }
        if (clazzAnnotations.hasPriority()) {
            int pv = clazzAnnotations.getPriority();
            if (pv >= 0 && named != null && named.equals("default")) {
                pv -= Integer.MIN_VALUE;
            }
            beanBuilder.setPriority(pv);
        }
        BeanBag.SupplierBuilder supplierBuilder = beanBuilder.buildSupplier();
        Constructor<T> ctor = Sisu.findConstructor(clazz);
        for (Parameter parameter : ctor.getParameters()) {
            Annotations paramAnnotations = Annotations.of(parameter);
            boolean optional = paramAnnotations.isNullable();
            String paramNamed = paramAnnotations.getNamed();
            String name = paramNamed == null ? "" : paramNamed;
            Class<?> parameterType = parameter.getType();
            supplierBuilder.addConstructorArgument(Sisu.getSupplier(parameterType, parameter.getParameterizedType(), name, optional, filter));
        }
        supplierBuilder.setConstructor(ctor);
        Sisu.addFieldInjections(clazz, supplierBuilder, filter);
        Sisu.addMethodInjections(clazz, supplierBuilder, filter);
        supplierBuilder.build();
        beanBuilder.build();
        for (Type genericInterface : clazz.getGenericInterfaces()) {
            if (Sisu.getRawType(genericInterface) != Provider.class) continue;
            Sisu.addOneProvider(this.builder, genericInterface, clazz.asSubclass(Provider.class), clazzAnnotations);
        }
    }

    public static void configureSisu(ClassLoader classLoader, BeanBag.Builder builder, DependencyFilter filter) {
        Sisu.createFor(builder).addClassLoader(classLoader, filter);
    }

    public static Sisu createFor(BeanBag.Builder builder) {
        Assert.checkNotNullParam((String)"builder", (Object)builder);
        return new Sisu(builder);
    }

    private static <T, P extends Provider<T>> void addOneProvider(BeanBag.Builder builder, Type genericInterface, Class<P> clazz, Annotations clazzAnnotations) {
        Class<?> providedType = Sisu.getRawType(Sisu.getTypeArgument(genericInterface, 0));
        BeanBag.BeanBuilder providedBuilder = builder.addBean(providedType);
        String named = clazzAnnotations.getNamed();
        if (named != null) {
            providedBuilder.setName(named);
        }
        if (clazzAnnotations.hasPriority()) {
            int pv = clazzAnnotations.getPriority();
            if (pv >= 0 && named != null && named.equals("default")) {
                pv -= Integer.MIN_VALUE;
            }
            providedBuilder.setPriority(pv);
        }
        String name = named == null ? "" : named;
        providedBuilder.setSupplier(BeanSupplier.resolving(clazz, (String)name, (boolean)false, (DependencyFilter)DependencyFilter.ACCEPT).transform(Provider::get));
        providedBuilder.build();
    }

    private static BeanSupplier<?> getSupplier(Class<?> rawType, Type parameterizedType, String name, boolean optional, DependencyFilter filter) {
        if (rawType == Provider.class) {
            Type providerType = Sisu.getTypeArgument(parameterizedType, 0);
            BeanSupplier<?> supplier = Sisu.getSupplier(Sisu.getRawType(providerType), providerType, name, optional, filter);
            return scope -> () -> supplier.get(scope);
        }
        if (rawType == Set.class) {
            Class<?> argType = Sisu.getRawType(Sisu.getTypeArgument(parameterizedType, 0));
            return BeanSupplier.resolvingAll(argType, (String)name, (DependencyFilter)filter).transform(Set::copyOf);
        }
        if (rawType == List.class || rawType == Collection.class) {
            Class<?> argType = Sisu.getRawType(Sisu.getTypeArgument(parameterizedType, 0));
            return BeanSupplier.resolvingAll(argType, (String)name, (DependencyFilter)filter);
        }
        if (rawType == Map.class) {
            Class<?> keyType = Sisu.getRawType(Sisu.getTypeArgument(parameterizedType, 0));
            Class<?> valType = Sisu.getRawType(Sisu.getTypeArgument(parameterizedType, 1));
            if (keyType == String.class) {
                return BeanSupplier.resolvingAllByName(valType, (DependencyFilter)filter);
            }
            throw new IllegalArgumentException("Invalid key type " + keyType + " for map");
        }
        if (rawType == String.class) {
            if (name.contains("${")) {
                return scope -> Sisu.parseExpressionString(new StringItr(name), 0, false, Objects.requireNonNullElse((Properties)scope.getOptionalBean(Properties.class), new Properties()));
            }
            return BeanSupplier.of((Object)name);
        }
        return BeanSupplier.resolving(rawType, (String)(name == null ? "" : name), (boolean)optional, (DependencyFilter)filter);
    }

    private static String parseExpressionString(StringItr itr, int recursion, boolean stopOnDefault, Properties properties) {
        if (recursion > 10) {
            throw new IllegalStateException("Deep recursion");
        }
        StringBuilder b = new StringBuilder();
        while (!(!itr.hasNext() || recursion > 0 && (itr.nextMatches("}") || stopOnDefault && itr.nextMatches(":-")))) {
            if (itr.match("${")) {
                Sisu.doExprPart(b, itr, recursion + 1, properties);
                continue;
            }
            b.append(itr.next());
        }
        return b.toString();
    }

    private static void doExprPart(StringBuilder b, StringItr itr, int recursion, Properties properties) {
        String key = Sisu.parseExpressionString(itr, recursion, true, properties);
        if (itr.match("}") || !itr.hasNext()) {
            b.append(properties.getProperty(key, ""));
            return;
        }
        if (itr.match(":-")) {
            b.append(properties.getProperty(key, Sisu.parseExpressionString(itr, recursion, false, properties)));
            itr.match("}");
            return;
        }
        throw new IllegalStateException();
    }

    private static Type getTypeArgument(Type type, int position) {
        if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            return pt.getActualTypeArguments()[position];
        }
        throw new IllegalArgumentException("No type argument given for " + type);
    }

    private static Class<?> getRawType(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            return Sisu.getRawType(pt.getRawType());
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType gat = (GenericArrayType)type;
            return Sisu.getArrayType(Sisu.getRawType(gat.getGenericComponentType()));
        }
        if (type instanceof WildcardType) {
            WildcardType wt = (WildcardType)type;
            Type[] ub = wt.getUpperBounds();
            return ub.length >= 1 ? Sisu.getRawType(ub[0]) : Object.class;
        }
        if (type instanceof TypeVariable) {
            TypeVariable tv = (TypeVariable)type;
            Type[] bounds = tv.getBounds();
            return bounds.length >= 1 ? Sisu.getRawType(bounds[0]) : Object.class;
        }
        throw new IllegalArgumentException("Cannot determine raw type of " + type);
    }

    private static <T> Class<T[]> getArrayType(Class<T> elementType) {
        return arrayTypes.get(elementType);
    }

    private static <T> void addFieldInjections(Class<? super T> clazz, BeanBag.SupplierBuilder<T> supplierBuilder, DependencyFilter filter) {
        if (clazz == Object.class) {
            return;
        }
        Class<? super T> superclass = clazz.getSuperclass();
        if (superclass != null) {
            Sisu.addFieldInjections(superclass, supplierBuilder, filter);
        }
        boolean open = clazz.getModule().isOpen(clazz.getPackageName(), Sisu.class.getModule());
        boolean publicClass = Modifier.isPublic(clazz.getModifiers());
        for (Field field : clazz.getDeclaredFields()) {
            Annotations fieldAnnotations;
            int mods = field.getModifiers();
            if (Modifier.isStatic(mods) || Modifier.isFinal(mods) || !(fieldAnnotations = Annotations.of(field)).isInject() || (!publicClass || !Modifier.isPublic(mods)) && (!open || !field.trySetAccessible())) continue;
            boolean optional = fieldAnnotations.isNullable();
            String paramNamed = fieldAnnotations.getNamed();
            String name = paramNamed == null ? "" : paramNamed;
            Class<?> fieldType = field.getType();
            supplierBuilder.injectField(field, Sisu.getSupplier(fieldType, field.getGenericType(), name, optional, filter));
        }
    }

    private static <T> void addMethodInjections(Class<? super T> clazz, BeanBag.SupplierBuilder<T> supplierBuilder, DependencyFilter filter) {
        Sisu.addMethodInjections(clazz, supplierBuilder, filter, new HashSet<Class<? super T>>());
    }

    private static <T> void addMethodInjections(Class<? super T> clazz, BeanBag.SupplierBuilder<T> supplierBuilder, DependencyFilter filter, Set<Class<? super T>> visited) {
        if (visited.add(clazz)) {
            if (clazz == Object.class) {
                return;
            }
            Class<? super T> superclass = clazz.getSuperclass();
            if (superclass != null) {
                Sisu.addMethodInjections(superclass, supplierBuilder, filter);
            }
            for (Class<?> anInterface : clazz.getInterfaces()) {
                Sisu.addMethodInjections(anInterface, supplierBuilder, filter);
            }
            boolean open = clazz.getModule().isOpen(clazz.getPackageName(), Sisu.class.getModule());
            boolean publicClass = Modifier.isPublic(clazz.getModifiers());
            for (Method method : clazz.getDeclaredMethods()) {
                Annotations methodAnnotations;
                int mods = method.getModifiers();
                if (Modifier.isStatic(mods) || !(methodAnnotations = Annotations.of(method)).isInject() || method.getParameterCount() != 1 || (!publicClass || !Modifier.isPublic(mods)) && (!open || !method.trySetAccessible())) continue;
                String named = methodAnnotations.getNamed();
                String name = named == null ? "" : named;
                Parameter argParam = method.getParameters()[0];
                boolean optional = Annotations.of(argParam).isNullable();
                supplierBuilder.injectMethod(method, argParam.getType(), name, optional, filter);
            }
        }
    }

    private static <T> Constructor<T> findConstructor(Class<T> clazz) {
        Constructor<?>[] declaredConstructors;
        Constructor<?> defaultConstructor = null;
        try {
            declaredConstructors = clazz.getDeclaredConstructors();
        }
        catch (Throwable t) {
            throw new RuntimeException("Cannot get declared constructors from " + clazz, t);
        }
        boolean open = clazz.getModule().isOpen(clazz.getPackageName(), Sisu.class.getModule());
        boolean publicClass = Modifier.isPublic(clazz.getModifiers());
        for (Constructor<?> constructor : declaredConstructors) {
            int mods = constructor.getModifiers();
            if (Annotations.of(constructor).isInject() && (publicClass && Modifier.isPublic(mods) || open && constructor.trySetAccessible())) {
                return constructor;
            }
            if (constructor.getParameterCount() != 0) continue;
            defaultConstructor = constructor;
        }
        if (defaultConstructor != null) {
            int mods = defaultConstructor.getModifiers();
            if (publicClass && Modifier.isPublic(mods) || open && defaultConstructor.trySetAccessible()) {
                return defaultConstructor;
            }
        }
        throw new RuntimeException("No valid constructor found on " + clazz);
    }

    private static interface BeanLoader {
        public void loadBeans(URL var1) throws IOException;
    }

    static interface XMLCloser
    extends AutoCloseable {
        @Override
        public void close() throws XMLStreamException;
    }

    static final class Component<T> {
        final Class<T> clazz;
        Set<Class<? super T>> types;
        String name;
        Set<String> aliases;
        boolean singleton;
        List<Requirement> requirements;

        Component(Class<T> clazz) {
            this.clazz = clazz;
        }

        public static <T> Component<T> of(Class<?> clazz, Class<?> type, String name, boolean singleton, List<Requirement> requirements) {
            Component c = new Component(clazz);
            if (type != null && type != clazz) {
                c.types = new HashSet(Set.of(type));
            }
            c.name = name;
            c.singleton = singleton;
            c.requirements = requirements;
            return c;
        }
    }

    static class Annotations {
        private final boolean hasPriority;
        private final int priority;
        private final String named;
        private final boolean inject;
        private final boolean singleton;
        private final boolean nullable;
        private final List<Class<?>> typed;

        private Annotations(AnnotatedElement element) {
            boolean hasPriority = false;
            int priority = 0;
            String named = null;
            boolean inject = false;
            boolean singleton = false;
            boolean nullable = false;
            List<Class<?>> typed = null;
            block19: for (Annotation annotation : element.getAnnotations()) {
                String annoName;
                Class<? extends Annotation> annoType = annotation.annotationType();
                switch (annoName = annoType.getName()) {
                    case "javax.inject.Inject": {
                        inject = true;
                        continue block19;
                    }
                    case "javax.inject.Singleton": 
                    case "org.eclipse.sisu.EagerSingleton": 
                    case "org.sonatype.inject.EagerSingleton": {
                        singleton = true;
                        continue block19;
                    }
                    case "javax.inject.Named": {
                        named = GET_NAMED_VALUE_FN.get(annoType).apply(annotation);
                        continue block19;
                    }
                    case "org.eclipse.sisu.Nullable": 
                    case "org.sonatype.inject.Nullable": {
                        nullable = true;
                        continue block19;
                    }
                    case "org.eclipse.sisu.Priority": {
                        priority = GET_PRIORITY_VALUE_FN.get(annoType).apply(annotation);
                        continue block19;
                    }
                    case "org.eclipse.sisu.Typed": {
                        typed = List.of(GET_TYPED_VALUE_FN.get(annoType).apply(annotation));
                    }
                }
            }
            this.hasPriority = hasPriority;
            this.priority = priority;
            this.named = named;
            this.inject = inject;
            this.singleton = singleton;
            this.nullable = nullable;
            this.typed = typed;
        }

        static Annotations of(AnnotatedElement element) {
            return new Annotations(element);
        }

        boolean hasPriority() {
            return this.hasPriority;
        }

        int getPriority() {
            return this.priority;
        }

        String getNamed() {
            return this.named;
        }

        boolean isInject() {
            return this.inject;
        }

        boolean isSingleton() {
            return this.singleton;
        }

        boolean isNullable() {
            return this.nullable;
        }

        List<Class<?>> getTyped() {
            return this.typed;
        }
    }

    static final class Requirement {
        String injectType;
        String injectName;
        String fieldName;

        Requirement() {
        }
    }

    private static final class StringItr {
        final String s;
        int pos;
        final int end;

        StringItr(String s) {
            this.s = s;
            this.pos = 0;
            this.end = s.length();
        }

        boolean hasNext() {
            return this.pos < this.end;
        }

        char next() {
            return this.s.charAt(this.pos++);
        }

        boolean nextMatches(String cmp) {
            int cmpLen = cmp.length();
            return this.pos + cmpLen <= this.end && this.s.regionMatches(this.pos, cmp, 0, cmpLen);
        }

        boolean match(String cmp) {
            boolean b = this.nextMatches(cmp);
            if (b) {
                this.pos += cmp.length();
            }
            return b;
        }
    }

    static class MethodFunction<R>
    implements Function<Annotation, R> {
        private final Method method;

        MethodFunction(Class<?> type, String expectedName) {
            Method method;
            Class<Annotation> annotationType = type.asSubclass(Annotation.class);
            if (!annotationType.getName().equals(expectedName)) {
                throw new IllegalArgumentException("Wrong class name");
            }
            try {
                method = annotationType.getDeclaredMethod("value", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
            this.method = method;
        }

        @Override
        public R apply(Annotation annotation) {
            try {
                return (R)this.method.invoke((Object)annotation, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

