/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute;

import io.quarkus.qute.Engine;
import io.quarkus.qute.EngineImpl;
import io.quarkus.qute.EvalContext;
import io.quarkus.qute.Expression;
import io.quarkus.qute.FragmentSectionHelper;
import io.quarkus.qute.ImmutableList;
import io.quarkus.qute.IncludeSectionHelper;
import io.quarkus.qute.LazyValue;
import io.quarkus.qute.LoopSectionHelper;
import io.quarkus.qute.NamespaceResolver;
import io.quarkus.qute.ParameterDeclaration;
import io.quarkus.qute.Parser;
import io.quarkus.qute.ResolutionContext;
import io.quarkus.qute.ResolutionContextImpl;
import io.quarkus.qute.Results;
import io.quarkus.qute.SectionBlock;
import io.quarkus.qute.SectionHelper;
import io.quarkus.qute.SectionNode;
import io.quarkus.qute.Template;
import io.quarkus.qute.TemplateException;
import io.quarkus.qute.TemplateInstance;
import io.quarkus.qute.TemplateInstanceBase;
import io.quarkus.qute.TemplateNode;
import io.quarkus.qute.UserTagSectionHelper;
import io.quarkus.qute.Variant;
import io.quarkus.qute.trace.TemplateEvent;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.subscription.MultiEmitter;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jboss.logging.Logger;

class TemplateImpl
implements Template {
    private static final Logger LOG = Logger.getLogger(TemplateImpl.class);
    private final String templateId;
    private final String generatedId;
    private final EngineImpl engine;
    private final Optional<Variant> variant;
    final SectionNode root;
    private final List<ParameterDeclaration> parameterDeclarations;
    private final LazyValue<Map<String, Template.Fragment>> fragments;
    final Capacity capacity;

    TemplateImpl(EngineImpl engine, SectionNode root, String templateId, String generatedId, Optional<Variant> variant) {
        this.engine = engine;
        this.root = root;
        this.templateId = templateId;
        this.generatedId = generatedId;
        this.variant = variant;
        this.parameterDeclarations = ImmutableList.copyOf(root.getParameterDeclarations());
        this.fragments = this.initFragments(root);
        this.capacity = new Capacity();
    }

    @Override
    public TemplateInstance instance() {
        TemplateInstanceImpl instance = new TemplateInstanceImpl();
        if (!this.engine.initializers.isEmpty()) {
            for (TemplateInstance.Initializer initializer : this.engine.initializers) {
                initializer.accept(instance);
            }
        }
        return instance;
    }

    @Override
    public List<Expression> getExpressions() {
        return this.root.getExpressions();
    }

    @Override
    public Expression findExpression(Predicate<Expression> predicate) {
        return this.root.findExpression(predicate);
    }

    @Override
    public List<ParameterDeclaration> getParameterDeclarations() {
        return this.parameterDeclarations;
    }

    @Override
    public String getGeneratedId() {
        return this.generatedId;
    }

    @Override
    public String getId() {
        return this.templateId;
    }

    @Override
    public Optional<Variant> getVariant() {
        return this.variant;
    }

    public String toString() {
        return "Template " + this.templateId + " [generatedId=" + this.generatedId + "]";
    }

    @Override
    public Template.Fragment getFragment(String identifier) {
        return this.fragments != null ? this.fragments.get().get(Objects.requireNonNull(identifier)) : null;
    }

    @Override
    public Set<String> getFragmentIds() {
        return this.fragments != null ? Set.copyOf(this.fragments.get().keySet()) : Set.of();
    }

    @Override
    public List<TemplateNode> getNodes() {
        return this.root.blocks.get((int)0).nodes;
    }

    @Override
    public Collection<TemplateNode> findNodes(Predicate<TemplateNode> predicate) {
        return this.root.findNodes(predicate);
    }

    @Override
    public SectionNode getRootNode() {
        return this.root;
    }

    private LazyValue<Map<String, Template.Fragment>> initFragments(final SectionNode section) {
        if (section.name.equals("$root")) {
            return new LazyValue<Map<String, Template.Fragment>>(new Supplier<Map<String, Template.Fragment>>(){

                @Override
                public Map<String, Template.Fragment> get() {
                    Predicate<TemplateNode> isFragmentNode = new Predicate<TemplateNode>(){

                        @Override
                        public boolean test(TemplateNode node) {
                            if (!node.isSection()) {
                                return false;
                            }
                            SectionNode sectionNode = (SectionNode)node;
                            return sectionNode.helper instanceof FragmentSectionHelper;
                        }
                    };
                    List<TemplateNode> fragmentNodes = section.findNodes(isFragmentNode);
                    if (fragmentNodes.isEmpty()) {
                        return Collections.emptyMap();
                    }
                    HashMap<String, Template.Fragment> fragments = new HashMap<String, Template.Fragment>();
                    for (TemplateNode fragmentNode : fragmentNodes) {
                        FragmentSectionHelper helper = (FragmentSectionHelper)((SectionNode)fragmentNode).helper;
                        FragmentImpl fragment = new FragmentImpl(TemplateImpl.this.engine, (SectionNode)fragmentNode, helper.getIdentifier(), TemplateImpl.this.engine.generateId(), TemplateImpl.this.variant);
                        fragments.put(helper.getIdentifier(), fragment);
                    }
                    return fragments;
                }
            });
        }
        return null;
    }

    class Capacity {
        static final int LIMIT = 65536;
        final int computed;
        int max;

        Capacity() {
            this.computed = Math.min(this.computeCapacity(TemplateImpl.this.root.blocks.get(0)), 65536);
        }

        void update(int length) {
            if (length > this.max) {
                this.max = length < 65536 ? length : 65536;
            }
        }

        int get() {
            return Math.max(this.max, this.computed);
        }

        private int computeCapacity(SectionBlock block) {
            int ret = 0;
            for (TemplateNode node : block.nodes) {
                if (Parser.isDummyNode(node)) continue;
                if (node.isText()) {
                    ret += node.asText().getValue().length();
                    continue;
                }
                if (node.isExpression()) {
                    ret += 10;
                    continue;
                }
                if (!node.isSection()) continue;
                SectionHelper helper = node.asSection().getHelper();
                if (LoopSectionHelper.class.isInstance(helper)) {
                    ret += 10 * this.computeCapacity(node.asSection().blocks.get(0));
                    continue;
                }
                if (IncludeSectionHelper.class.isInstance(helper)) {
                    ret += 500;
                    continue;
                }
                if (UserTagSectionHelper.class.isInstance(helper)) {
                    ret += 200;
                    continue;
                }
                for (SectionBlock b : node.asSection().blocks) {
                    ret += this.computeCapacity(b);
                }
            }
            return ret;
        }
    }

    private class TemplateInstanceImpl
    extends TemplateInstanceBase {
        private TemplateInstanceImpl() {
        }

        @Override
        public String render() {
            long timeout = this.getTimeout();
            try {
                return this.renderAsyncNoTimeout().toCompletableFuture().get(timeout, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IllegalStateException(e);
            }
            catch (TimeoutException e) {
                throw this.newTimeoutException(timeout);
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)e.getCause();
                }
                throw new IllegalStateException(e.getCause());
            }
        }

        @Override
        public Multi<String> createMulti() {
            Multi multi = Multi.createFrom().emitter(emitter -> this.renderData(this.data(), arg_0 -> ((MultiEmitter)emitter).emit(arg_0)).whenComplete((r, f) -> {
                if (f == null) {
                    emitter.complete();
                } else {
                    emitter.fail(f);
                }
            }));
            if (TemplateImpl.this.engine.useAsyncTimeout()) {
                long timeout = this.getTimeout();
                multi = multi.ifNoItem().after(Duration.ofMillis(timeout)).failWith(() -> this.newTimeoutException(timeout));
            }
            return multi;
        }

        @Override
        public Uni<String> createUni() {
            Uni uni = Uni.createFrom().completionStage(this::renderAsyncNoTimeout);
            if (TemplateImpl.this.engine.useAsyncTimeout()) {
                long timeout = this.getTimeout();
                uni = uni.ifNoItem().after(Duration.ofMillis(timeout)).failWith(() -> this.newTimeoutException(timeout));
            }
            return uni;
        }

        @Override
        public CompletionStage<String> renderAsync() {
            CompletionStage<String> cs = this.renderAsyncNoTimeout();
            if (TemplateImpl.this.engine.useAsyncTimeout()) {
                cs = cs.toCompletableFuture().orTimeout(this.getTimeout(), TimeUnit.MILLISECONDS);
            }
            return cs;
        }

        @Override
        public CompletionStage<Void> consume(Consumer<String> resultConsumer) {
            CompletionStage<Void> cs = this.renderData(this.data(), resultConsumer);
            if (TemplateImpl.this.engine.useAsyncTimeout()) {
                cs = cs.toCompletableFuture().orTimeout(this.getTimeout(), TimeUnit.MILLISECONDS);
            }
            return cs;
        }

        private TemplateException newTimeoutException(long timeout) {
            return new TemplateException(TemplateImpl.this.toString() + " rendering timeout [" + timeout + "ms] occured");
        }

        @Override
        protected Engine engine() {
            return TemplateImpl.this.engine;
        }

        private CompletionStage<String> renderAsyncNoTimeout() {
            StringBuilder builder = new StringBuilder(this.getCapacity());
            return this.renderData(this.data(), builder::append).thenApply(v -> {
                String str = builder.toString();
                TemplateImpl.this.capacity.update(str.length());
                return str;
            });
        }

        private int getCapacity() {
            return this.attributes.isEmpty() ? TemplateImpl.this.capacity.get() : this.getCapacityAttributeValue();
        }

        private int getCapacityAttributeValue() {
            Object c = this.getAttribute("capacity");
            if (c != null) {
                if (c instanceof Number) {
                    return ((Number)c).intValue();
                }
                try {
                    return Integer.parseInt(c.toString());
                }
                catch (NumberFormatException e) {
                    LOG.warnf("Invalid capacity value set for " + this.toString() + ": " + String.valueOf(c), new Object[0]);
                }
            }
            return TemplateImpl.this.capacity.get();
        }

        private CompletionStage<Void> renderData(Object data, Consumer<String> consumer) {
            TemplateEvent event;
            CompletableFuture<Void> result = new CompletableFuture<Void>();
            ResolutionContextImpl rootContext = new ResolutionContextImpl(data, TemplateImpl.this.engine.getEvaluator(), null, this);
            this.setAttribute("qute$rootContext", rootContext);
            TemplateEvent templateEvent = event = TemplateImpl.this.engine.traceManager != null ? new TemplateEvent(this, TemplateImpl.this.engine) : null;
            if (event != null) {
                TemplateImpl.this.engine.getTraceManager().fireStartTemplate(event);
            }
            TemplateImpl.this.root.resolve(rootContext).whenComplete((r, t) -> {
                if (t != null) {
                    result.completeExceptionally((Throwable)t);
                } else {
                    try {
                        r.process(consumer);
                        result.complete(null);
                    }
                    catch (Throwable e) {
                        result.completeExceptionally(e);
                    }
                    finally {
                        if (this.renderedActions != null) {
                            for (Runnable action : this.renderedActions) {
                                try {
                                    action.run();
                                }
                                catch (Throwable e) {
                                    LOG.error((Object)"Unable to perform an action when rendering finished", e);
                                }
                            }
                        }
                    }
                }
                if (event != null) {
                    event.done();
                    TemplateImpl.this.engine.getTraceManager().fireEndTemplate(event);
                }
            });
            return result;
        }

        @Override
        public Template getTemplate() {
            return TemplateImpl.this;
        }

        public String toString() {
            return "Instance of " + TemplateImpl.this.toString();
        }
    }

    static class DataNamespaceResolver
    implements NamespaceResolver {
        static final String ROOT_CONTEXT = "qute$rootContext";

        DataNamespaceResolver() {
        }

        @Override
        public CompletionStage<Object> resolve(EvalContext context) {
            Object rootContext = context.getAttribute(ROOT_CONTEXT);
            if (rootContext != null && rootContext instanceof ResolutionContext) {
                return ((ResolutionContext)rootContext).evaluate(context.getName());
            }
            return Results.notFound(context);
        }

        @Override
        public String getNamespace() {
            return "data";
        }
    }

    class FragmentImpl
    extends TemplateImpl
    implements Template.Fragment {
        FragmentImpl(EngineImpl engine, SectionNode root, String fragmentId, String generatedId, Optional<Variant> variant) {
            super(engine, root, fragmentId, generatedId, variant);
        }

        @Override
        public Template.Fragment getFragment(String id) {
            return TemplateImpl.this.getFragment(id);
        }

        @Override
        public Set<String> getFragmentIds() {
            return TemplateImpl.this.getFragmentIds();
        }

        @Override
        public Template getOriginalTemplate() {
            return TemplateImpl.this;
        }

        @Override
        public TemplateInstance instance() {
            TemplateInstance instance = super.instance();
            instance.setAttribute("qute$fragment", TemplateImpl.this.getGeneratedId() + this.getId());
            return instance;
        }
    }
}

