/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute;

import io.quarkus.qute.Expression;
import io.quarkus.qute.LiteralSupport;
import io.quarkus.qute.Parser;
import io.quarkus.qute.Results;
import io.quarkus.qute.Scope;
import io.quarkus.qute.TemplateNode;
import io.quarkus.qute.ValueResolver;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;

final class ExpressionImpl
implements Expression {
    static final ExpressionImpl EMPTY = new ExpressionImpl(null, Collections.emptyList(), null, null);
    private final String namespace;
    private final List<Expression.Part> parts;
    private final CompletableFuture<Object> literal;
    private final TemplateNode.Origin origin;

    static ExpressionImpl from(String value) {
        if (value == null || value.isEmpty()) {
            return EMPTY;
        }
        return Parser.parseExpression(value, Scope.EMPTY, Parser.SYNTHETIC_ORIGIN);
    }

    static ExpressionImpl literalFrom(String literal) {
        if (literal == null || literal.isEmpty()) {
            return EMPTY;
        }
        Object literalValue = LiteralSupport.getLiteralValue(literal);
        if (literalValue == null) {
            throw new IllegalArgumentException("Not a literal value: " + literal);
        }
        return ExpressionImpl.literal(literal, literalValue, Parser.SYNTHETIC_ORIGIN);
    }

    static ExpressionImpl literal(String literal, Object value, TemplateNode.Origin origin) {
        if (literal == null) {
            throw new IllegalArgumentException("Literal must not be null");
        }
        return new ExpressionImpl(null, Collections.singletonList(new PartImpl(literal, value != null ? '|' + value.getClass().getName() + '|' : null)), value, origin);
    }

    ExpressionImpl(String namespace, List<Expression.Part> parts, Object literal, TemplateNode.Origin origin) {
        this.namespace = namespace;
        this.parts = parts;
        this.literal = literal != Results.Result.NOT_FOUND ? CompletableFuture.completedFuture(literal) : null;
        this.origin = origin;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public List<Expression.Part> getParts() {
        return this.parts;
    }

    @Override
    public boolean isLiteral() {
        return this.literal != null;
    }

    @Override
    public CompletableFuture<Object> getLiteralValue() {
        return this.literal;
    }

    @Override
    public TemplateNode.Origin getOrigin() {
        return this.origin;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Objects.hashCode(this.toOriginalString());
        result = 31 * result + Objects.hashCode(this.origin);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExpressionImpl other = (ExpressionImpl)obj;
        return Objects.equals(this.toOriginalString(), other.toOriginalString()) && Objects.equals(this.origin, other.origin);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Expression [namespace=").append(this.namespace).append(", parts=").append(this.parts).append(", literal=").append(this.literalValue()).append("]");
        return builder.toString();
    }

    @Override
    public String toOriginalString() {
        StringBuilder builder = new StringBuilder();
        if (this.namespace != null) {
            builder.append(this.namespace);
            builder.append(":");
        }
        Iterator<Expression.Part> iterator = this.parts.iterator();
        while (iterator.hasNext()) {
            builder.append(iterator.next());
            if (!iterator.hasNext()) continue;
            builder.append(".");
        }
        return builder.toString();
    }

    private Object literalValue() {
        if (this.literal != null) {
            try {
                return this.literal.get();
            }
            catch (InterruptedException | ExecutionException e) {
                return null;
            }
        }
        return null;
    }

    static class PartImpl
    implements Expression.Part {
        protected final String name;
        protected final String typeInfo;
        protected volatile ValueResolver cachedResolver;

        PartImpl(String name, String typeInfo) {
            this.name = name;
            this.typeInfo = typeInfo;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getTypeInfo() {
            return this.typeInfo;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setCachedResolver(ValueResolver resolver) {
            ValueResolver last = this.cachedResolver;
            if (last != null) {
                return;
            }
            PartImpl partImpl = this;
            synchronized (partImpl) {
                if (this.cachedResolver == null) {
                    this.cachedResolver = resolver;
                }
            }
        }

        public int hashCode() {
            return Objects.hash(this.name, this.typeInfo);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PartImpl other = (PartImpl)obj;
            return Objects.equals(this.name, other.name) && Objects.equals(this.typeInfo, other.typeInfo);
        }

        public String toString() {
            return this.name;
        }
    }

    static class VirtualMethodPartImpl
    extends PartImpl
    implements Expression.VirtualMethodPart {
        private final List<Expression> parameters;

        VirtualMethodPartImpl(String name, List<Expression> parameters) {
            super(name, null);
            this.parameters = parameters;
        }

        @Override
        public List<Expression> getParameters() {
            return this.parameters;
        }

        @Override
        public boolean isVirtualMethod() {
            return true;
        }

        @Override
        public Expression.VirtualMethodPart asVirtualMethod() {
            return this;
        }

        @Override
        public String getTypeInfo() {
            return this.toString();
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + Objects.hash(this.parameters);
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            VirtualMethodPartImpl other = (VirtualMethodPartImpl)obj;
            return Objects.equals(this.parameters, other.parameters);
        }

        @Override
        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.name).append("(");
            Iterator<Expression> iterator = this.parameters.iterator();
            while (iterator.hasNext()) {
                Expression expression = iterator.next();
                builder.append(expression.toOriginalString());
                if (!iterator.hasNext()) continue;
                builder.append(",");
            }
            builder.append(")");
            return builder.toString();
        }
    }
}

