/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.deployment;

import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.builder.item.SimpleBuildItem;
import io.quarkus.deployment.ApplicationArchive;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.ApplicationArchivesBuildItem;
import io.quarkus.deployment.builditem.ExecutorBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.HotDeploymentWatchedFileBuildItem;
import io.quarkus.deployment.builditem.ShutdownContextBuildItem;
import io.quarkus.resteasy.common.deployment.ResteasyInjectionReadyBuildItem;
import io.quarkus.resteasy.runtime.standalone.ResteasyStandaloneRecorder;
import io.quarkus.resteasy.server.common.deployment.ResteasyDeploymentBuildItem;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.vertx.core.deployment.InternalWebVertxBuildItem;
import io.quarkus.vertx.http.deployment.DefaultRouteBuildItem;
import io.quarkus.vertx.http.deployment.RequireVirtualHttpBuildItem;
import io.quarkus.vertx.http.deployment.RouteBuildItem;
import io.quarkus.vertx.http.runtime.HttpBuildTimeConfig;
import io.vertx.core.Handler;
import java.net.JarURLConnection;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.jar.JarEntry;
import java.util.stream.Stream;

public class ResteasyStandaloneBuildStep {
    protected static final String META_INF_RESOURCES_SLASH = "META-INF/resources/";
    protected static final String META_INF_RESOURCES = "META-INF/resources";

    @BuildStep
    HotDeploymentWatchedFileBuildItem watchMetaInfResources() {
        return new HotDeploymentWatchedFileBuildItem(META_INF_RESOURCES);
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    public void staticInit(ResteasyStandaloneRecorder recorder, Capabilities capabilities, ResteasyDeploymentBuildItem deployment, ApplicationArchivesBuildItem applicationArchivesBuildItem, ResteasyInjectionReadyBuildItem resteasyInjectionReady, HttpBuildTimeConfig httpConfig, BuildProducer<ResteasyStandaloneBuildItem> standalone) throws Exception {
        if (capabilities.isCapabilityPresent("io.quarkus.servlet")) {
            return;
        }
        Set<String> knownPaths = this.getClasspathResources(applicationArchivesBuildItem);
        String deploymentRootPath = null;
        String rootPath = httpConfig.rootPath;
        if (deployment != null) {
            deploymentRootPath = deployment.getRootPath();
            if (rootPath.endsWith("/")) {
                rootPath = deploymentRootPath.startsWith("/") ? rootPath + deploymentRootPath.substring(1) : rootPath + deploymentRootPath;
            } else if (!deploymentRootPath.equals("/")) {
                if (!deploymentRootPath.startsWith("/")) {
                    rootPath = rootPath + "/";
                }
                rootPath = rootPath + deploymentRootPath;
            }
            recorder.staticInit(deployment.getDeployment(), rootPath, knownPaths);
        } else if (!knownPaths.isEmpty()) {
            recorder.staticInit(null, rootPath, knownPaths);
        }
        if (deployment != null || !knownPaths.isEmpty()) {
            standalone.produce((BuildItem)new ResteasyStandaloneBuildItem(deploymentRootPath));
        }
    }

    private Set<String> getClasspathResources(ApplicationArchivesBuildItem applicationArchivesBuildItem) throws Exception {
        Throwable throwable;
        Stream<Path> fileTreeElements;
        Path resource;
        final HashSet<String> knownPaths = new HashSet<String>();
        for (ApplicationArchive i : applicationArchivesBuildItem.getAllApplicationArchives()) {
            resource = i.getChildPath(META_INF_RESOURCES);
            if (resource == null || !Files.exists(resource, new LinkOption[0])) continue;
            fileTreeElements = Files.walk(resource, new FileVisitOption[0]);
            throwable = null;
            try {
                fileTreeElements.forEach(new Consumer<Path>(){

                    @Override
                    public void accept(Path path) {
                        if (resource.equals(path)) {
                            return;
                        }
                        Path rel = resource.relativize(path);
                        if (!Files.isDirectory(path, new LinkOption[0])) {
                            String file = rel.toString();
                            if (file.equals("index.html") || file.equals("index.htm")) {
                                knownPaths.add("/");
                            }
                            if (!file.startsWith("/")) {
                                file = "/" + file;
                            }
                            file = file.replace('\\', '/');
                            knownPaths.add(file);
                        }
                    }
                });
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (fileTreeElements == null) continue;
                if (throwable != null) {
                    try {
                        fileTreeElements.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                fileTreeElements.close();
            }
        }
        Enumeration<URL> resources = this.getClass().getClassLoader().getResources(META_INF_RESOURCES);
        while (resources.hasMoreElements()) {
            URL url = resources.nextElement();
            if (url.getProtocol().equals("jar")) {
                JarURLConnection jar = (JarURLConnection)url.openConnection();
                Enumeration<JarEntry> entries = jar.getJarFile().entries();
                while (entries.hasMoreElements()) {
                    String sub;
                    JarEntry entry = entries.nextElement();
                    if (!entry.getName().startsWith(META_INF_RESOURCES_SLASH) || (sub = entry.getName().substring(META_INF_RESOURCES_SLASH.length())).isEmpty()) continue;
                    if (sub.equals("index.html") || sub.equals("index.htm")) {
                        knownPaths.add("/");
                    }
                    if (!sub.startsWith("/")) {
                        sub = "/" + sub;
                    }
                    knownPaths.add(sub);
                }
            }
            if (!url.getProtocol().equals("file") || (resource = Paths.get(url.toURI())) == null || !Files.exists(resource, new LinkOption[0])) continue;
            fileTreeElements = Files.walk(resource, new FileVisitOption[0]);
            throwable = null;
            try {
                fileTreeElements.forEach(new Consumer<Path>(){

                    @Override
                    public void accept(Path path) {
                        if (resource.equals(path)) {
                            return;
                        }
                        Path rel = resource.relativize(path);
                        if (!Files.isDirectory(path, new LinkOption[0])) {
                            String file = rel.toString();
                            if (file.equals("index.html") || file.equals("index.htm")) {
                                knownPaths.add("/");
                            }
                            if (!file.startsWith("/")) {
                                file = "/" + file;
                            }
                            file = file.replace('\\', '/');
                            knownPaths.add(file);
                        }
                    }
                });
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (fileTreeElements == null) continue;
                if (throwable != null) {
                    try {
                        fileTreeElements.close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                    continue;
                }
                fileTreeElements.close();
            }
        }
        return knownPaths;
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public void boot(ShutdownContextBuildItem shutdown, ResteasyStandaloneRecorder recorder, BuildProducer<FeatureBuildItem> feature, BuildProducer<DefaultRouteBuildItem> defaultRoutes, BuildProducer<RouteBuildItem> routes, InternalWebVertxBuildItem vertx, BeanContainerBuildItem beanContainer, ResteasyStandaloneBuildItem standalone, Optional<RequireVirtualHttpBuildItem> requireVirtual, HttpBuildTimeConfig httpConfig, ExecutorBuildItem executorBuildItem) throws Exception {
        boolean isDefaultOrNullDeploymentPath;
        if (standalone == null) {
            return;
        }
        feature.produce((BuildItem)new FeatureBuildItem("resteasy"));
        boolean bl = isDefaultOrNullDeploymentPath = standalone.deploymentRootPath == null || standalone.deploymentRootPath.equals("/");
        if (!isDefaultOrNullDeploymentPath) {
            Handler handler = recorder.vertxRequestHandler(vertx.getVertx(), beanContainer.getValue(), (Executor)executorBuildItem.getExecutorProxy());
            routes.produce((BuildItem)new RouteBuildItem(standalone.deploymentRootPath, handler, false));
            String matchPath = standalone.deploymentRootPath;
            matchPath = matchPath.endsWith("/") ? matchPath + "*" : matchPath + "/*";
            routes.produce((BuildItem)new RouteBuildItem(matchPath, handler, false));
        }
        boolean isVirtual = requireVirtual.isPresent();
        Consumer ut = recorder.start(vertx.getVertx(), (ShutdownContext)shutdown, beanContainer.getValue(), isVirtual, isDefaultOrNullDeploymentPath, (Executor)executorBuildItem.getExecutorProxy());
        defaultRoutes.produce((BuildItem)new DefaultRouteBuildItem(ut));
    }

    public static final class ResteasyStandaloneBuildItem
    extends SimpleBuildItem {
        final String deploymentRootPath;

        public ResteasyStandaloneBuildItem(String deploymentRootPath) {
            this.deploymentRootPath = deploymentRootPath != null ? (deploymentRootPath.startsWith("/") ? deploymentRootPath : "/" + deploymentRootPath) : null;
        }
    }
}

