/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.quartz.runtime;

import io.quarkus.datasource.common.runtime.DatabaseKind;
import io.quarkus.quartz.runtime.QuartzBuildTimeConfig;
import io.quarkus.quartz.runtime.QuartzRuntimeConfig;
import io.quarkus.quartz.runtime.jdbc.JDBCDataSource;
import io.quarkus.quartz.runtime.jdbc.QuarkusDBv8Delegate;
import io.quarkus.quartz.runtime.jdbc.QuarkusHSQLDBDelegate;
import io.quarkus.quartz.runtime.jdbc.QuarkusMSSQLDelegate;
import io.quarkus.quartz.runtime.jdbc.QuarkusPostgreSQLDelegate;
import io.quarkus.quartz.runtime.jdbc.QuarkusStdJDBCDelegate;
import io.quarkus.runtime.configuration.ConfigurationException;
import io.quarkus.scheduler.common.runtime.ScheduledMethod;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class QuartzSupport {
    private final QuartzRuntimeConfig runtimeConfig;
    private final QuartzBuildTimeConfig buildTimeConfig;
    private final Optional<String> driverDialect;
    private final Set<String> nonconcurrentMethods;

    public QuartzSupport(QuartzRuntimeConfig runtimeConfig, QuartzBuildTimeConfig buildTimeConfig, Optional<String> driverDialect, List<JDBCDataSource> dataSources, Set<String> nonconcurrentMethods) {
        this.runtimeConfig = runtimeConfig;
        this.buildTimeConfig = buildTimeConfig;
        this.nonconcurrentMethods = Set.copyOf(nonconcurrentMethods);
        if (dataSources == null) {
            this.driverDialect = driverDialect;
        } else {
            if (runtimeConfig.deferredDatasourceName().isEmpty()) {
                throw new ConfigurationException("Deferred datasource name is missing - you can configure it via quarkus.quartz.deferred-datasource-name.");
            }
            Optional<JDBCDataSource> selectedDataSource = dataSources.stream().filter(i -> runtimeConfig.deferredDatasourceName().get().equals(i.getName())).findFirst();
            if (!selectedDataSource.isPresent()) {
                String message = String.format("JDBC Store configured but the '%s' datasource is not configured properly. You can configure your datasource by following the guide available at: https://quarkus.io/guides/datasource", runtimeConfig.deferredDatasourceName().isPresent() ? runtimeConfig.deferredDatasourceName().get() : "default");
                throw new ConfigurationException(message);
            }
            String dataSourceKind = selectedDataSource.get().getDbKind();
            this.driverDialect = DatabaseKind.isPostgreSQL((String)dataSourceKind) ? Optional.of(QuarkusPostgreSQLDelegate.class.getName()) : (DatabaseKind.isH2((String)dataSourceKind) ? Optional.of(QuarkusHSQLDBDelegate.class.getName()) : (DatabaseKind.isMsSQL((String)dataSourceKind) ? Optional.of(QuarkusMSSQLDelegate.class.getName()) : (DatabaseKind.isDB2((String)dataSourceKind) ? Optional.of(QuarkusDBv8Delegate.class.getName()) : Optional.of(QuarkusStdJDBCDelegate.class.getName()))));
        }
    }

    public QuartzRuntimeConfig getRuntimeConfig() {
        return this.runtimeConfig;
    }

    public QuartzBuildTimeConfig getBuildTimeConfig() {
        return this.buildTimeConfig;
    }

    public Optional<String> getDriverDialect() {
        return this.driverDialect;
    }

    public boolean isNonconcurrent(ScheduledMethod method) {
        return this.nonconcurrentMethods.contains(method.getMethodDescription());
    }
}

