/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.opentelemetry.runtime;

import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ContextStorage;
import io.opentelemetry.context.Scope;
import io.quarkus.opentelemetry.runtime.MDCEnabledContextStorage;
import io.quarkus.opentelemetry.runtime.OpenTelemetryUtil;
import io.quarkus.vertx.core.runtime.context.VertxContextSafetyToggle;
import io.smallrye.common.vertx.VertxContext;
import io.vertx.core.Vertx;
import org.jboss.logging.Logger;

public enum QuarkusContextStorage implements ContextStorage
{
    INSTANCE;

    private static final Logger log;
    private static final String OTEL_CONTEXT;
    private static final ContextStorage FALLBACK_CONTEXT_STORAGE;
    static Vertx vertx;

    public Scope attach(Context otelToAttach) {
        io.vertx.core.Context vertxContext = QuarkusContextStorage.getVertxContext();
        return vertxContext != null && VertxContext.isDuplicatedContext((io.vertx.core.Context)vertxContext) ? this.attach(vertxContext, otelToAttach) : FALLBACK_CONTEXT_STORAGE.attach(otelToAttach);
    }

    public Scope attach(final io.vertx.core.Context vertxContext, final Context otelToAttach) {
        if (vertxContext == null || otelToAttach == null) {
            return Scope.noop();
        }
        if (!VertxContext.isDuplicatedContext((io.vertx.core.Context)vertxContext)) {
            throw new IllegalArgumentException("The Vert.x Context to attach the OpenTelemetry Context must be a duplicated Context");
        }
        final Context otelBeforeAttach = QuarkusContextStorage.getOtelContext(vertxContext);
        if (otelToAttach == otelBeforeAttach) {
            return Scope.noop();
        }
        if (log.isDebugEnabled()) {
            log.debugv("Setting Otel context: {0}", OpenTelemetryUtil.getSpanData(otelToAttach));
        }
        vertxContext.putLocal((Object)OTEL_CONTEXT, (Object)otelToAttach);
        OpenTelemetryUtil.setMDCData(otelToAttach, vertxContext);
        return new Scope(){

            public void close() {
                Context otelBefore = QuarkusContextStorage.getOtelContext(vertxContext);
                if (log.isDebugEnabled()) {
                    log.debugv("Closing Otel context: {0}", OpenTelemetryUtil.getSpanData(otelToAttach));
                }
                if (otelBefore != otelToAttach) {
                    log.info((Object)("Context in storage not the expected context, Scope.close was not called correctly. Details: OTel context otelBefore: " + String.valueOf(OpenTelemetryUtil.getSpanData(otelBefore)) + ". OTel context otelToAttach: " + String.valueOf(OpenTelemetryUtil.getSpanData(otelToAttach))));
                }
                if (otelBeforeAttach == null) {
                    OpenTelemetryUtil.clearMDCData(vertxContext);
                    vertxContext.removeLocal((Object)OTEL_CONTEXT);
                } else {
                    Span span = Span.fromContextOrNull((Context)otelBeforeAttach);
                    if (span != null && span.isRecording()) {
                        OpenTelemetryUtil.setMDCData(otelBeforeAttach, vertxContext);
                        vertxContext.putLocal((Object)OTEL_CONTEXT, (Object)otelBeforeAttach);
                    } else {
                        OpenTelemetryUtil.clearMDCData(vertxContext);
                        vertxContext.removeLocal((Object)OTEL_CONTEXT);
                    }
                }
            }

            public String toString() {
                Context otelInVertxContext = QuarkusContextStorage.getOtelContext(vertxContext);
                return "OTelContext: " + String.valueOf(OpenTelemetryUtil.getSpanData(otelToAttach)) + ". vertxContext: " + String.valueOf(OpenTelemetryUtil.getSpanData(otelInVertxContext));
            }
        };
    }

    public Context current() {
        io.vertx.core.Context current = QuarkusContextStorage.getVertxContext();
        if (current != null) {
            return (Context)current.getLocal((Object)OTEL_CONTEXT);
        }
        return FALLBACK_CONTEXT_STORAGE.current();
    }

    public static Context getOtelContext(io.vertx.core.Context vertxContext) {
        return vertxContext != null && VertxContext.isDuplicatedContext((io.vertx.core.Context)vertxContext) ? (Context)vertxContext.getLocal((Object)OTEL_CONTEXT) : null;
    }

    public static io.vertx.core.Context getVertxContext() {
        io.vertx.core.Context context = Vertx.currentContext();
        if (context != null && VertxContext.isOnDuplicatedContext()) {
            return context;
        }
        if (context != null) {
            io.vertx.core.Context dc = VertxContext.createNewDuplicatedContext((io.vertx.core.Context)context);
            VertxContextSafetyToggle.setContextSafe((io.vertx.core.Context)dc, (boolean)true);
            return dc;
        }
        return null;
    }

    static {
        log = Logger.getLogger(QuarkusContextStorage.class);
        OTEL_CONTEXT = QuarkusContextStorage.class.getName() + ".otelContext";
        FALLBACK_CONTEXT_STORAGE = MDCEnabledContextStorage.INSTANCE;
    }
}

