/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.deployment.devservices.keycloak;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.IsDockerWorking;
import io.quarkus.deployment.IsNormal;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CuratedApplicationShutdownBuildItem;
import io.quarkus.deployment.builditem.DevServicesConfigResultBuildItem;
import io.quarkus.deployment.builditem.DevServicesSharedNetworkBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.console.ConsoleInstalledBuildItem;
import io.quarkus.deployment.console.StartupLogCompressor;
import io.quarkus.deployment.dev.devservices.GlobalDevServicesConfig;
import io.quarkus.deployment.logging.LoggingSetupBuildItem;
import io.quarkus.devservices.common.ContainerAddress;
import io.quarkus.devservices.common.ContainerLocator;
import io.quarkus.oidc.deployment.OidcBuildStep;
import io.quarkus.oidc.deployment.devservices.OidcDevServicesBuildItem;
import io.quarkus.oidc.deployment.devservices.OidcDevServicesUtils;
import io.quarkus.oidc.deployment.devservices.keycloak.DevServicesConfig;
import io.quarkus.oidc.deployment.devservices.keycloak.KeycloakBuildTimeConfig;
import io.quarkus.oidc.deployment.devservices.keycloak.KeycloakDevServicesConfigBuildItem;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.configuration.ConfigUtils;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.json.JsonObject;
import io.vertx.mutiny.core.buffer.Buffer;
import io.vertx.mutiny.ext.web.client.HttpResponse;
import io.vertx.mutiny.ext.web.client.WebClient;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.logging.Logger;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.CredentialRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.RolesRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.util.JsonSerialization;
import org.testcontainers.containers.BindMode;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.Base58;
import org.testcontainers.utility.DockerImageName;

public class KeycloakDevServicesProcessor {
    static volatile DevServicesConfig capturedDevServicesConfiguration;
    static volatile Vertx vertxInstance;
    private static final Logger LOG;
    private static final String CONFIG_PREFIX = "quarkus.oidc.";
    private static final String TENANT_ENABLED_CONFIG_KEY = "quarkus.oidc.tenant-enabled";
    private static final String AUTH_SERVER_URL_CONFIG_KEY = "quarkus.oidc.auth-server-url";
    private static final String APPLICATION_TYPE_CONFIG_KEY = "quarkus.oidc.application-type";
    private static final String CLIENT_ID_CONFIG_KEY = "quarkus.oidc.client-id";
    private static final String CLIENT_SECRET_CONFIG_KEY = "quarkus.oidc.credentials.secret";
    private static final String KEYCLOAK_URL_KEY = "keycloak.url";
    private static final String KEYCLOAK_REALM_KEY = "keycloak.realm";
    private static final int KEYCLOAK_PORT = 8080;
    private static final String JAVA_OPTS = "JAVA_OPTS";
    private static final String KEYCLOAK_DOCKER_REALM_PATH = "/tmp/realm.json";
    private static final String KEYCLOAK_USER_PROP = "KEYCLOAK_USER";
    private static final String KEYCLOAK_PASSWORD_PROP = "KEYCLOAK_PASSWORD";
    private static final String KEYCLOAK_VENDOR_PROP = "DB_VENDOR";
    private static final String KEYCLOAK_IMPORT_PROP = "KEYCLOAK_IMPORT";
    private static final String KEYCLOAK_ADMIN_USER = "admin";
    private static final String KEYCLOAK_ADMIN_PASSWORD = "admin";
    private static final String KEYCLOAK_DB_VENDOR = "H2";
    private static final String OIDC_USERS = "oidc.users";
    private static final String DEV_SERVICE_LABEL = "quarkus-dev-service-keycloak";
    private static final ContainerLocator keycloakDevModeContainerLocator;
    private static volatile List<Closeable> closeables;
    private static volatile boolean first;
    private static volatile String capturedKeycloakUrl;
    private static volatile FileTime capturedRealmFileLastModifiedDate;
    private final IsDockerWorking isDockerWorking = new IsDockerWorking(true);
    private static volatile KeycloakDevServicesConfigBuildItem existingDevServiceConfig;

    @BuildStep(onlyIfNot={IsNormal.class}, onlyIf={OidcBuildStep.IsEnabled.class, GlobalDevServicesConfig.Enabled.class})
    public KeycloakDevServicesConfigBuildItem startKeycloakContainer(Optional<DevServicesSharedNetworkBuildItem> devServicesSharedNetworkBuildItem, BuildProducer<DevServicesConfigResultBuildItem> devServices, Optional<OidcDevServicesBuildItem> oidcProviderBuildItem, KeycloakBuildTimeConfig config, CuratedApplicationShutdownBuildItem closeBuildItem, LaunchModeBuildItem launchMode, Optional<ConsoleInstalledBuildItem> consoleInstalledBuildItem, LoggingSetupBuildItem loggingSetupBuildItem) {
        StartResult startResult;
        if (oidcProviderBuildItem.isPresent()) {
            return null;
        }
        DevServicesConfig currentDevServicesConfiguration = config.devservices;
        if (closeables != null) {
            Object currentRealmFileLastModifiedDate;
            boolean restartRequired;
            boolean bl = restartRequired = !currentDevServicesConfiguration.equals(capturedDevServicesConfiguration);
            if (!restartRequired && (currentRealmFileLastModifiedDate = this.getRealmFileLastModifiedDate(currentDevServicesConfiguration.realmPath)) != null && !((FileTime)currentRealmFileLastModifiedDate).equals(capturedRealmFileLastModifiedDate)) {
                restartRequired = true;
                capturedRealmFileLastModifiedDate = currentRealmFileLastModifiedDate;
            }
            if (!restartRequired) {
                return existingDevServiceConfig;
            }
            for (Closeable closeable : closeables) {
                try {
                    closeable.close();
                }
                catch (Throwable e) {
                    LOG.error((Object)"Failed to stop Keycloak container", e);
                }
            }
            closeables = null;
            capturedDevServicesConfiguration = null;
            capturedKeycloakUrl = null;
            existingDevServiceConfig = null;
        }
        capturedDevServicesConfiguration = currentDevServicesConfiguration;
        StartupLogCompressor compressor = new StartupLogCompressor((launchMode.isTest() ? "(test) " : "") + "KeyCloak Dev Services Starting:", consoleInstalledBuildItem, loggingSetupBuildItem);
        try {
            startResult = this.startContainer(devServicesSharedNetworkBuildItem.isPresent());
            if (startResult == null) {
                compressor.close();
                return null;
            }
            List<Closeable> list = closeables = startResult.closeable != null ? Collections.singletonList(startResult.closeable) : null;
            if (first) {
                first = false;
                Runnable closeTask = new Runnable(){

                    @Override
                    public void run() {
                        if (closeables != null) {
                            for (Closeable closeable : closeables) {
                                try {
                                    closeable.close();
                                }
                                catch (Throwable t) {
                                    LOG.error((Object)"Failed to stop Keycloak container", t);
                                }
                            }
                        }
                        if (vertxInstance != null) {
                            try {
                                vertxInstance.close();
                            }
                            catch (Throwable t) {
                                LOG.error((Object)"Failed to close Vertx instance", t);
                            }
                        }
                        first = true;
                        closeables = null;
                        capturedDevServicesConfiguration = null;
                        vertxInstance = null;
                        capturedRealmFileLastModifiedDate = null;
                    }
                };
                closeBuildItem.addCloseTask(closeTask, true);
            }
            capturedKeycloakUrl = startResult.url + "/auth";
            if (vertxInstance == null) {
                vertxInstance = Vertx.vertx();
            }
            capturedRealmFileLastModifiedDate = this.getRealmFileLastModifiedDate(KeycloakDevServicesProcessor.capturedDevServicesConfiguration.realmPath);
            compressor.close();
        }
        catch (Throwable t) {
            compressor.closeAndDumpCaptured();
            throw new RuntimeException(t);
        }
        LOG.info((Object)"Dev Services for Keycloak started.");
        return this.prepareConfiguration(KeycloakDevServicesProcessor.capturedDevServicesConfiguration.createRealm && startResult.createDefaultRealm, startResult.realmNameToUse, devServices, startResult.shared);
    }

    private KeycloakDevServicesConfigBuildItem prepareConfiguration(boolean createRealm, String realmNameToUse, BuildProducer<DevServicesConfigResultBuildItem> devServices, boolean shared) {
        String realmName = realmNameToUse != null ? realmNameToUse : this.getDefaultRealmName();
        String authServerUrl = capturedKeycloakUrl + "/realms/" + realmName;
        String oidcClientId = KeycloakDevServicesProcessor.getOidcClientId();
        String oidcClientSecret = KeycloakDevServicesProcessor.getOidcClientSecret();
        String oidcApplicationType = KeycloakDevServicesProcessor.getOidcApplicationType();
        Map<String, String> users = this.getUsers(KeycloakDevServicesProcessor.capturedDevServicesConfiguration.users);
        if (createRealm) {
            this.createRealm(capturedKeycloakUrl, users, oidcClientId, oidcClientSecret);
        }
        devServices.produce((BuildItem)new DevServicesConfigResultBuildItem(KEYCLOAK_URL_KEY, capturedKeycloakUrl));
        devServices.produce((BuildItem)new DevServicesConfigResultBuildItem(AUTH_SERVER_URL_CONFIG_KEY, authServerUrl));
        devServices.produce((BuildItem)new DevServicesConfigResultBuildItem(APPLICATION_TYPE_CONFIG_KEY, oidcApplicationType));
        devServices.produce((BuildItem)new DevServicesConfigResultBuildItem(CLIENT_ID_CONFIG_KEY, oidcClientId));
        devServices.produce((BuildItem)new DevServicesConfigResultBuildItem(CLIENT_SECRET_CONFIG_KEY, oidcClientSecret));
        HashMap<String, Object> configProperties = new HashMap<String, Object>();
        configProperties.put(KEYCLOAK_URL_KEY, capturedKeycloakUrl);
        configProperties.put(KEYCLOAK_REALM_KEY, realmName);
        configProperties.put(AUTH_SERVER_URL_CONFIG_KEY, authServerUrl);
        configProperties.put(APPLICATION_TYPE_CONFIG_KEY, oidcApplicationType);
        configProperties.put(CLIENT_ID_CONFIG_KEY, oidcClientId);
        configProperties.put(CLIENT_SECRET_CONFIG_KEY, oidcClientSecret);
        configProperties.put(OIDC_USERS, users);
        existingDevServiceConfig = new KeycloakDevServicesConfigBuildItem(configProperties);
        return existingDevServiceConfig;
    }

    private String getDefaultRealmName() {
        return KeycloakDevServicesProcessor.capturedDevServicesConfiguration.realmName.orElse("quarkus");
    }

    private StartResult startContainer(boolean useSharedContainer) {
        if (!KeycloakDevServicesProcessor.capturedDevServicesConfiguration.enabled) {
            LOG.debug((Object)"Not starting Dev Services for Keycloak as it has been disabled in the config");
            return null;
        }
        if (!KeycloakDevServicesProcessor.isOidcTenantEnabled()) {
            LOG.debug((Object)"Not starting Dev Services for Keycloak as 'quarkus.oidc.tenant.enabled' is false");
            return null;
        }
        if (ConfigUtils.isPropertyPresent((String)AUTH_SERVER_URL_CONFIG_KEY)) {
            LOG.debug((Object)"Not starting Dev Services for Keycloak as 'quarkus.oidc.auth-server-url' has been provided");
            return null;
        }
        if (!this.isDockerWorking.getAsBoolean()) {
            LOG.warn((Object)"Please configure 'quarkus.oidc.auth-server-url' or get a working docker instance");
            return null;
        }
        Optional maybeContainerAddress = keycloakDevModeContainerLocator.locateContainer(KeycloakDevServicesProcessor.capturedDevServicesConfiguration.serviceName, KeycloakDevServicesProcessor.capturedDevServicesConfiguration.shared, LaunchMode.current());
        Supplier<StartResult> defaultKeycloakContainerSupplier = () -> {
            String imageName = KeycloakDevServicesProcessor.capturedDevServicesConfiguration.imageName;
            DockerImageName dockerImageName = DockerImageName.parse((String)imageName).asCompatibleSubstituteFor(imageName);
            final QuarkusOidcContainer oidcContainer = new QuarkusOidcContainer(dockerImageName, KeycloakDevServicesProcessor.capturedDevServicesConfiguration.port, useSharedContainer, KeycloakDevServicesProcessor.capturedDevServicesConfiguration.realmName, KeycloakDevServicesProcessor.capturedDevServicesConfiguration.realmPath, KeycloakDevServicesProcessor.capturedDevServicesConfiguration.serviceName, KeycloakDevServicesProcessor.capturedDevServicesConfiguration.shared, KeycloakDevServicesProcessor.capturedDevServicesConfiguration.javaOpts);
            oidcContainer.start();
            String url = "http://" + oidcContainer.getHost() + ":" + oidcContainer.getPort();
            return new StartResult(url, !oidcContainer.realmFileExists, oidcContainer.realmNameToUse, new Closeable(){

                @Override
                public void close() {
                    oidcContainer.close();
                    LOG.info((Object)"Dev Services for Keycloak shut down.");
                }
            }, false);
        };
        return maybeContainerAddress.map(containerAddress -> new StartResult(this.getSharedContainerUrl((ContainerAddress)containerAddress), false, null, null, true)).orElseGet(defaultKeycloakContainerSupplier);
    }

    private String getSharedContainerUrl(ContainerAddress containerAddress) {
        return "http://" + ("0.0.0.0".equals(containerAddress.getHost()) ? "localhost" : containerAddress.getHost()) + ":" + containerAddress.getPort();
    }

    private FileTime getRealmFileLastModifiedDate(Optional<String> realm) {
        if (realm.isPresent()) {
            Path realmPath = Paths.get(realm.get(), new String[0]);
            try {
                return Files.getLastModifiedTime(realmPath, new LinkOption[0]);
            }
            catch (IOException ex) {
                LOG.tracef("Unable to get the last modified date of the realm file %s", (Object)realmPath);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createRealm(String keycloakUrl, Map<String, String> users, String oidcClientId, String oidcClientSecret) {
        RealmRepresentation realm = this.createRealmRep();
        realm.getClients().add(this.createClient(oidcClientId, oidcClientSecret));
        for (Map.Entry<String, String> entry : users.entrySet()) {
            realm.getUsers().add(this.createUser(entry.getKey(), entry.getValue(), this.getUserRoles(entry.getKey())));
        }
        try (WebClient client = OidcDevServicesUtils.createWebClient(vertxInstance);){
            String token = OidcDevServicesUtils.getPasswordAccessToken(client, keycloakUrl + "/realms/master/protocol/openid-connect/token", "admin-cli", null, "admin", "admin", KeycloakDevServicesProcessor.capturedDevServicesConfiguration.webClienTimeout);
            HttpResponse response = (HttpResponse)client.postAbs(keycloakUrl + "/admin/realms").putHeader(HttpHeaders.CONTENT_TYPE.toString(), "application/json").putHeader(HttpHeaders.AUTHORIZATION.toString(), "Bearer " + token).sendBuffer(Buffer.buffer().appendString(JsonSerialization.writeValueAsString((Object)realm))).await().atMost(KeycloakDevServicesProcessor.capturedDevServicesConfiguration.webClienTimeout);
            if (response.statusCode() > 299) {
                LOG.errorf("Realm %s can not be created %d - %s ", (Object)realm.getRealm(), (Object)response.statusCode(), (Object)response.statusMessage());
            }
        }
    }

    private Map<String, String> getUsers(Map<String, String> configuredUsers) {
        if (configuredUsers.isEmpty()) {
            LinkedHashMap<String, String> users = new LinkedHashMap<String, String>();
            users.put("alice", "alice");
            users.put("bob", "bob");
            return users;
        }
        return configuredUsers;
    }

    private String[] getUserRoles(String user) {
        String[] stringArray;
        String roles = KeycloakDevServicesProcessor.capturedDevServicesConfiguration.roles.get(user);
        if (roles == null) {
            if ("alice".equals(user)) {
                String[] stringArray2 = new String[2];
                stringArray2[0] = "admin";
                stringArray = stringArray2;
                stringArray2[1] = "user";
            } else {
                String[] stringArray3 = new String[1];
                stringArray = stringArray3;
                stringArray3[0] = "user";
            }
        } else {
            stringArray = roles.split(",");
        }
        return stringArray;
    }

    private RealmRepresentation createRealmRep() {
        RealmRepresentation realm = new RealmRepresentation();
        realm.setRealm(this.getDefaultRealmName());
        realm.setEnabled(Boolean.valueOf(true));
        realm.setUsers(new ArrayList());
        realm.setClients(new ArrayList());
        RolesRepresentation roles = new RolesRepresentation();
        ArrayList realmRoles = new ArrayList();
        roles.setRealm(realmRoles);
        realm.setRoles(roles);
        if (KeycloakDevServicesProcessor.capturedDevServicesConfiguration.roles.isEmpty()) {
            realm.getRoles().getRealm().add(new RoleRepresentation("user", null, false));
            realm.getRoles().getRealm().add(new RoleRepresentation("admin", null, false));
        } else {
            List distinctRoles = KeycloakDevServicesProcessor.capturedDevServicesConfiguration.roles.values().stream().distinct().collect(Collectors.toList());
            for (String role : distinctRoles) {
                realm.getRoles().getRealm().add(new RoleRepresentation(role, null, false));
            }
        }
        return realm;
    }

    private ClientRepresentation createClient(String clientId, String oidcClientSecret) {
        ClientRepresentation client = new ClientRepresentation();
        client.setClientId(clientId);
        client.setRedirectUris(Arrays.asList("*"));
        client.setPublicClient(Boolean.valueOf(false));
        client.setSecret(oidcClientSecret);
        client.setDirectAccessGrantsEnabled(Boolean.valueOf(true));
        client.setServiceAccountsEnabled(Boolean.valueOf(true));
        client.setImplicitFlowEnabled(Boolean.valueOf(true));
        client.setEnabled(Boolean.valueOf(true));
        client.setRedirectUris(Arrays.asList("*"));
        client.setDefaultClientScopes(Arrays.asList("microprofile-jwt"));
        return client;
    }

    private UserRepresentation createUser(String username, String password, String ... realmRoles) {
        UserRepresentation user = new UserRepresentation();
        user.setUsername(username);
        user.setEnabled(Boolean.valueOf(true));
        user.setCredentials(new ArrayList());
        user.setRealmRoles(Arrays.asList(realmRoles));
        CredentialRepresentation credential = new CredentialRepresentation();
        credential.setType("password");
        credential.setValue(password);
        credential.setTemporary(Boolean.valueOf(false));
        user.getCredentials().add(credential);
        return user;
    }

    private static boolean isOidcTenantEnabled() {
        return ConfigProvider.getConfig().getOptionalValue(TENANT_ENABLED_CONFIG_KEY, Boolean.class).orElse(true);
    }

    private static String getOidcApplicationType() {
        return ConfigProvider.getConfig().getOptionalValue(APPLICATION_TYPE_CONFIG_KEY, String.class).orElse("service");
    }

    private static String getOidcClientId() {
        return ConfigProvider.getConfig().getOptionalValue(CLIENT_ID_CONFIG_KEY, String.class).orElse("quarkus-app");
    }

    private static String getOidcClientSecret() {
        return ConfigProvider.getConfig().getOptionalValue(CLIENT_SECRET_CONFIG_KEY, String.class).orElse("secret");
    }

    static {
        LOG = Logger.getLogger(KeycloakDevServicesProcessor.class);
        keycloakDevModeContainerLocator = new ContainerLocator(DEV_SERVICE_LABEL, 8080);
        first = true;
    }

    private static class QuarkusOidcContainer
    extends GenericContainer {
        private final OptionalInt fixedExposedPort;
        private final boolean useSharedNetwork;
        private final Optional<String> configuredRealmName;
        private final Optional<String> realmPath;
        private final String containerLabelValue;
        private final Optional<String> javaOpts;
        private final boolean sharedContainer;
        private boolean realmFileExists;
        private String hostName = null;
        private String realmNameToUse;

        public QuarkusOidcContainer(DockerImageName dockerImageName, OptionalInt fixedExposedPort, boolean useSharedNetwork, Optional<String> configuredRealmName, Optional<String> realmPath, String containerLabelValue, boolean sharedContainer, Optional<String> javaOpts) {
            super(dockerImageName);
            this.fixedExposedPort = fixedExposedPort;
            this.useSharedNetwork = useSharedNetwork;
            this.configuredRealmName = configuredRealmName;
            this.realmPath = realmPath;
            this.containerLabelValue = containerLabelValue;
            this.sharedContainer = sharedContainer;
            this.javaOpts = javaOpts;
        }

        protected void configure() {
            super.configure();
            if (this.useSharedNetwork) {
                this.setNetwork(Network.SHARED);
                this.hostName = "keycloak-" + Base58.randomString((int)5);
                this.setNetworkAliases(Collections.singletonList(this.hostName));
            } else {
                if (this.fixedExposedPort.isPresent()) {
                    this.addFixedExposedPort(this.fixedExposedPort.getAsInt(), 8080);
                }
                this.addExposedPort(8080);
            }
            if (this.sharedContainer && LaunchMode.current() == LaunchMode.DEVELOPMENT) {
                this.withLabel(KeycloakDevServicesProcessor.DEV_SERVICE_LABEL, this.containerLabelValue);
            }
            this.addEnv(KeycloakDevServicesProcessor.KEYCLOAK_USER_PROP, "admin");
            this.addEnv(KeycloakDevServicesProcessor.KEYCLOAK_PASSWORD_PROP, "admin");
            this.addEnv(KeycloakDevServicesProcessor.KEYCLOAK_VENDOR_PROP, KeycloakDevServicesProcessor.KEYCLOAK_DB_VENDOR);
            if (this.javaOpts.isPresent()) {
                this.addEnv(KeycloakDevServicesProcessor.JAVA_OPTS, this.javaOpts.get());
            }
            if (this.realmPath.isPresent()) {
                URL realmPathUrl = null;
                realmPathUrl = Thread.currentThread().getContextClassLoader().getResource(this.realmPath.get());
                if (realmPathUrl != null) {
                    this.realmFileExists = true;
                    this.realmNameToUse = this.configuredRealmName.isPresent() ? null : this.getRealmNameFromRealmFile(realmPathUrl, this.realmPath.get());
                    this.withClasspathResourceMapping(this.realmPath.get(), KeycloakDevServicesProcessor.KEYCLOAK_DOCKER_REALM_PATH, BindMode.READ_ONLY);
                    this.addEnv(KeycloakDevServicesProcessor.KEYCLOAK_IMPORT_PROP, KeycloakDevServicesProcessor.KEYCLOAK_DOCKER_REALM_PATH);
                } else {
                    Path filePath = Paths.get(this.realmPath.get(), new String[0]);
                    if (Files.exists(filePath, new LinkOption[0])) {
                        this.realmFileExists = true;
                        this.realmNameToUse = this.configuredRealmName.isPresent() ? null : this.getRealmNameFromRealmFile(filePath.toUri(), this.realmPath.get());
                        this.withFileSystemBind(this.realmPath.get(), KeycloakDevServicesProcessor.KEYCLOAK_DOCKER_REALM_PATH, BindMode.READ_ONLY);
                        this.addEnv(KeycloakDevServicesProcessor.KEYCLOAK_IMPORT_PROP, KeycloakDevServicesProcessor.KEYCLOAK_DOCKER_REALM_PATH);
                    } else {
                        LOG.debugf("Realm %s resource is not available", (Object)this.realmPath.get());
                    }
                }
            }
            super.setWaitStrategy((WaitStrategy)Wait.forHttp((String)"/auth").forPort(8080));
        }

        private String getRealmNameFromRealmFile(URI uri, String realmPath) {
            try {
                return this.getRealmNameFromRealmFile(uri.toURL(), realmPath);
            }
            catch (MalformedURLException ex) {
                throw new RuntimeException(ex);
            }
        }

        private String getRealmNameFromRealmFile(URL url, String realmPath) {
            String string;
            block8: {
                InputStream is = url.openStream();
                try {
                    String realmName;
                    JsonObject realmJson = new JsonObject(io.vertx.core.buffer.Buffer.buffer((byte[])is.readAllBytes()));
                    string = realmName = realmJson.getString("realm");
                    if (is == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException ex) {
                        LOG.errorf("Realm %s resource can not be opened: %s", (Object)realmPath, (Object)ex.getMessage());
                        return null;
                    }
                }
                is.close();
            }
            return string;
        }

        public String getHost() {
            if (this.useSharedNetwork) {
                return this.hostName;
            }
            return super.getHost();
        }

        public int getPort() {
            if (this.useSharedNetwork) {
                return 8080;
            }
            if (this.fixedExposedPort.isPresent()) {
                return this.fixedExposedPort.getAsInt();
            }
            return this.getFirstMappedPort();
        }
    }

    private static class StartResult {
        private final String url;
        private final boolean createDefaultRealm;
        private String realmNameToUse;
        private final Closeable closeable;
        private final boolean shared;

        public StartResult(String url, boolean createDefaultRealm, String realmNameToUse, Closeable closeable, boolean shared) {
            this.url = url;
            this.createDefaultRealm = createDefaultRealm;
            this.realmNameToUse = realmNameToUse;
            this.closeable = closeable;
            this.shared = shared;
        }
    }
}

