/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.maven;

import io.quarkus.bootstrap.app.CuratedApplication;
import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.bootstrap.model.ApplicationModel;
import io.quarkus.maven.QuarkusBootstrapMojo;
import io.quarkus.paths.PathCollection;
import io.quarkus.paths.PathList;
import io.quarkus.runtime.LaunchMode;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.List;
import java.util.Properties;
import java.util.function.Consumer;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="generate-code", defaultPhase=LifecyclePhase.PROCESS_RESOURCES, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, threadSafe=true)
public class GenerateCodeMojo
extends QuarkusBootstrapMojo {
    @Parameter(defaultValue="false", property="quarkus.generate-code.skip", alias="quarkus.prepare.skip")
    private boolean skipSourceGeneration = false;
    @Parameter(defaultValue="NORMAL", property="launchMode")
    String mode;

    @Override
    protected boolean beforeExecute() throws MojoExecutionException, MojoFailureException {
        if (this.mavenProject().getPackaging().equals("pom")) {
            this.getLog().info((CharSequence)"Type of the artifact is POM, skipping build goal");
            return false;
        }
        if (this.skipSourceGeneration) {
            this.getLog().info((CharSequence)"Skipping Quarkus code generation");
            return false;
        }
        return true;
    }

    @Override
    protected void doExecute() throws MojoExecutionException, MojoFailureException {
        this.generateCode(this.getParentDirs(this.mavenProject().getCompileSourceRoots()), path -> this.mavenProject().addCompileSourceRoot(path.toString()), false);
    }

    void generateCode(PathCollection sourceParents, Consumer<Path> sourceRegistrar, boolean test) throws MojoFailureException, MojoExecutionException {
        LaunchMode launchMode = test ? LaunchMode.TEST : (this.mavenSession().getGoals().contains("quarkus:dev") ? LaunchMode.DEVELOPMENT : LaunchMode.valueOf((String)this.mode));
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Bootstrapping Quarkus application in mode " + String.valueOf(launchMode)));
        }
        ClassLoader originalTccl = Thread.currentThread().getContextClassLoader();
        CuratedApplication curatedApplication = null;
        QuarkusClassLoader deploymentClassLoader = null;
        try {
            curatedApplication = this.bootstrapApplication(launchMode);
            deploymentClassLoader = curatedApplication.createDeploymentClassLoader();
            Thread.currentThread().setContextClassLoader((ClassLoader)deploymentClassLoader);
            Class codeGenerator = deploymentClassLoader.loadClass("io.quarkus.deployment.CodeGenerator");
            Method initAndRun = codeGenerator.getMethod("initAndRun", QuarkusClassLoader.class, PathCollection.class, Path.class, Path.class, Consumer.class, ApplicationModel.class, Properties.class, String.class, Boolean.TYPE);
            initAndRun.invoke(null, deploymentClassLoader, sourceParents, this.generatedSourcesDir(test), this.buildDir().toPath(), sourceRegistrar, curatedApplication.getApplicationModel(), this.getBuildSystemProperties(false), launchMode.name(), test);
        }
        catch (Exception any) {
            throw new MojoExecutionException("Quarkus code generation phase has failed", any);
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalTccl);
            if (deploymentClassLoader != null) {
                deploymentClassLoader.close();
            }
            if (test && curatedApplication != null) {
                curatedApplication.close();
            }
        }
    }

    protected PathCollection getParentDirs(List<String> sourceDirs) {
        if (sourceDirs.size() == 1) {
            return PathList.of((Path[])new Path[]{Path.of(sourceDirs.get(0), new String[0]).getParent()});
        }
        PathList.Builder builder = PathList.builder();
        for (int i = 0; i < sourceDirs.size(); ++i) {
            Path parentDir = Path.of(sourceDirs.get(i), new String[0]).getParent();
            if (builder.contains(parentDir)) continue;
            builder.add(parentDir);
        }
        return builder.build();
    }

    private Path generatedSourcesDir(boolean test) {
        return test ? this.buildDir().toPath().resolve("generated-test-sources") : this.buildDir().toPath().resolve("generated-sources");
    }
}

