/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.flyway.runtime;

import io.quarkus.agroal.runtime.AgroalDataSourceUtil;
import io.quarkus.arc.ActiveResult;
import io.quarkus.arc.Arc;
import io.quarkus.arc.InjectableBean;
import io.quarkus.arc.InjectableInstance;
import io.quarkus.arc.SyntheticCreationalContext;
import io.quarkus.flyway.runtime.FlywayContainer;
import io.quarkus.flyway.runtime.FlywayContainerProducer;
import io.quarkus.flyway.runtime.FlywayContainerUtil;
import io.quarkus.flyway.runtime.FlywayDataSourceRuntimeConfig;
import io.quarkus.flyway.runtime.FlywayRuntimeConfig;
import io.quarkus.flyway.runtime.QuarkusPathLocationScanner;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.sql.DataSource;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.FlywayExecutor;
import org.flywaydb.core.api.callback.Callback;
import org.flywaydb.core.api.migration.JavaMigration;
import org.flywaydb.core.api.output.BaselineResult;
import org.flywaydb.core.api.output.ValidateResult;
import org.flywaydb.core.internal.callback.CallbackExecutor;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.database.base.Schema;
import org.flywaydb.core.internal.jdbc.StatementInterceptor;
import org.flywaydb.core.internal.resolver.CompositeMigrationResolver;
import org.flywaydb.core.internal.schemahistory.SchemaHistory;
import org.jboss.logging.Logger;

@Recorder
public class FlywayRecorder {
    private static final Logger log = Logger.getLogger(FlywayRecorder.class);
    private final RuntimeValue<FlywayRuntimeConfig> config;

    public FlywayRecorder(RuntimeValue<FlywayRuntimeConfig> config) {
        this.config = config;
    }

    public void setApplicationMigrationFiles(Collection<String> migrationFiles) {
        log.debugv("Setting the following application migration files: {0}", migrationFiles);
        QuarkusPathLocationScanner.setApplicationMigrationFiles(migrationFiles);
    }

    public void setApplicationMigrationClasses(Collection<Class<? extends JavaMigration>> migrationClasses) {
        log.debugv("Setting the following application migration classes: {0}", migrationClasses);
        QuarkusPathLocationScanner.setApplicationMigrationClasses(migrationClasses);
    }

    public void setApplicationCallbackClasses(Map<String, Collection<Callback>> callbackClasses) {
        log.debugv("Setting application callbacks: {0} total", (Object)callbackClasses.values().size());
        QuarkusPathLocationScanner.setApplicationCallbackClasses(callbackClasses);
    }

    public Supplier<ActiveResult> flywayCheckActiveSupplier(final String dataSourceName) {
        return new Supplier<ActiveResult>(){

            @Override
            public ActiveResult get() {
                InjectableBean dataSourceBean = AgroalDataSourceUtil.dataSourceInstance((String)dataSourceName).getHandle().getBean();
                ActiveResult dataSourceActive = dataSourceBean.checkActive();
                if (!dataSourceActive.value()) {
                    return ActiveResult.inactive((String)String.format(Locale.ROOT, "Flyway for datasource '%s' was deactivated automatically because this datasource was deactivated.", dataSourceName), (ActiveResult)dataSourceActive);
                }
                return ActiveResult.active();
            }
        };
    }

    public Function<SyntheticCreationalContext<FlywayContainer>, FlywayContainer> flywayContainerFunction(final String dataSourceName, final boolean hasMigrations, final boolean createPossible) {
        return new Function<SyntheticCreationalContext<FlywayContainer>, FlywayContainer>(){

            @Override
            public FlywayContainer apply(SyntheticCreationalContext<FlywayContainer> context) {
                DataSource dataSource = (DataSource)context.getInjectedReference(DataSource.class, new Annotation[]{AgroalDataSourceUtil.qualifier((String)dataSourceName)});
                FlywayContainerProducer flywayProducer = (FlywayContainerProducer)context.getInjectedReference(FlywayContainerProducer.class, new Annotation[0]);
                return flywayProducer.createFlyway(dataSource, dataSourceName, hasMigrations, createPossible);
            }
        };
    }

    public Function<SyntheticCreationalContext<Flyway>, Flyway> flywayFunction(final String dataSourceName) {
        return new Function<SyntheticCreationalContext<Flyway>, Flyway>(){

            @Override
            public Flyway apply(SyntheticCreationalContext<Flyway> context) {
                FlywayContainer flywayContainer = (FlywayContainer)context.getInjectedReference(FlywayContainer.class, new Annotation[]{FlywayContainerUtil.getFlywayContainerQualifier(dataSourceName)});
                return flywayContainer.getFlyway();
            }
        };
    }

    public void doStartActions(String dataSourceName) {
        FlywayDataSourceRuntimeConfig flywayDataSourceRuntimeConfig = ((FlywayRuntimeConfig)this.config.getValue()).datasources().get(dataSourceName);
        if (flywayDataSourceRuntimeConfig.active().isPresent() && !flywayDataSourceRuntimeConfig.active().get().booleanValue()) {
            return;
        }
        InjectableInstance flywayContainerInstance = Arc.container().select(FlywayContainer.class, new Annotation[]{FlywayContainerUtil.getFlywayContainerQualifier(dataSourceName)});
        if (!flywayContainerInstance.isResolvable() || !flywayContainerInstance.getHandle().getBean().isActive()) {
            return;
        }
        FlywayContainer flywayContainer = (FlywayContainer)flywayContainerInstance.get();
        if (flywayContainer.isCleanAtStart()) {
            flywayContainer.getFlyway().clean();
        }
        if (flywayContainer.isValidateAtStart()) {
            if (flywayContainer.isCleanOnValidationError()) {
                ValidateResult result = flywayContainer.getFlyway().validateWithResult();
                if (!result.validationSuccessful) {
                    flywayContainer.getFlyway().clean();
                }
            } else {
                flywayContainer.getFlyway().validate();
            }
        }
        if (flywayContainer.isBaselineAtStart()) {
            new FlywayExecutor(flywayContainer.getFlyway().getConfiguration()).execute((FlywayExecutor.Command)new BaselineCommand(flywayContainer.getFlyway()), true, null);
        }
        if (flywayContainer.isRepairAtStart()) {
            flywayContainer.getFlyway().repair();
        }
        if (flywayContainer.isMigrateAtStart()) {
            flywayContainer.getFlyway().migrate();
        }
    }

    static class BaselineCommand
    implements FlywayExecutor.Command<BaselineResult> {
        final Flyway flyway;

        BaselineCommand(Flyway flyway) {
            this.flyway = flyway;
        }

        public BaselineResult execute(CompositeMigrationResolver cmr, SchemaHistory schemaHistory, Database d, Schema defaultSchema, Schema[] s, CallbackExecutor ce, StatementInterceptor si) {
            if (!schemaHistory.exists()) {
                return this.flyway.baseline();
            }
            return null;
        }
    }
}

