/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.flyway.runtime;

import io.quarkus.flyway.runtime.FlywayDataSourceBuildTimeConfig;
import io.quarkus.runtime.annotations.ConfigItem;
import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.annotations.ConfigRoot;
import java.util.Collections;
import java.util.Map;

@ConfigRoot(name="flyway", phase=ConfigPhase.BUILD_AND_RUN_TIME_FIXED)
public final class FlywayBuildTimeConfig {
    @ConfigItem(name="<<parent>>")
    public FlywayDataSourceBuildTimeConfig defaultDataSource;
    @ConfigItem(name="<<parent>>")
    public Map<String, FlywayDataSourceBuildTimeConfig> namedDataSources = Collections.emptyMap();

    public static final FlywayBuildTimeConfig defaultConfig() {
        FlywayBuildTimeConfig defaultConfig = new FlywayBuildTimeConfig();
        defaultConfig.defaultDataSource = FlywayDataSourceBuildTimeConfig.defaultConfig();
        return defaultConfig;
    }

    public FlywayDataSourceBuildTimeConfig getConfigForDataSourceName(String dataSourceName) {
        return this.namedDataSources.getOrDefault(dataSourceName, FlywayDataSourceBuildTimeConfig.defaultConfig());
    }
}

