/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.commands.handlers;

import io.quarkus.devtools.codestarts.CodestartProjectDefinition;
import io.quarkus.devtools.codestarts.CodestartType;
import io.quarkus.devtools.codestarts.quarkus.QuarkusCodestartCatalog;
import io.quarkus.devtools.codestarts.quarkus.QuarkusCodestartData;
import io.quarkus.devtools.codestarts.quarkus.QuarkusCodestartProjectInput;
import io.quarkus.devtools.commands.data.QuarkusCommandException;
import io.quarkus.devtools.commands.data.QuarkusCommandInvocation;
import io.quarkus.devtools.commands.data.QuarkusCommandOutcome;
import io.quarkus.devtools.commands.handlers.QuarkusCommandHandler;
import io.quarkus.devtools.commands.handlers.QuarkusCommandHandlers;
import io.quarkus.devtools.messagewriter.MessageIcons;
import io.quarkus.devtools.messagewriter.MessageWriter;
import io.quarkus.devtools.project.extensions.Extensions;
import io.quarkus.maven.ArtifactCoords;
import io.quarkus.maven.ArtifactKey;
import io.quarkus.platform.tools.ToolsUtils;
import io.quarkus.registry.catalog.Extension;
import io.quarkus.registry.catalog.ExtensionCatalog;
import io.quarkus.registry.catalog.ExtensionOrigin;
import io.quarkus.registry.catalog.json.JsonCatalogMerger;
import io.quarkus.registry.catalog.selection.ExtensionOrigins;
import io.quarkus.registry.catalog.selection.OriginCombination;
import io.quarkus.registry.catalog.selection.OriginPreference;
import io.quarkus.registry.catalog.selection.OriginSelector;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;

public class CreateProjectCommandHandler
implements QuarkusCommandHandler {
    @Override
    public QuarkusCommandOutcome execute(QuarkusCommandInvocation invocation) throws QuarkusCommandException {
        List<ExtensionCatalog> extensionOrigins;
        Set<String> extensionsQuery = invocation.getValue("extensions", Collections.emptySet());
        String className = invocation.getStringValue("class_name");
        String pkgName = invocation.getStringValue("package_name");
        String groupId = invocation.getStringValue("project_groupId");
        if (pkgName == null) {
            if (className != null && className.contains(".")) {
                int idx = className.lastIndexOf(46);
                invocation.setValue("package_name", className.substring(0, idx));
                invocation.setValue("class_name", className.substring(idx + 1));
            } else if (groupId != null) {
                invocation.setValue("package_name", groupId.replace('-', '.').replace('_', '.'));
            }
        }
        List<Extension> extensionsToAdd = this.computeRequiredExtensions(invocation.getExtensionsCatalog(), extensionsQuery, invocation.log());
        ExtensionCatalog mainCatalog = invocation.getExtensionsCatalog();
        try {
            extensionOrigins = CreateProjectCommandHandler.getExtensionOrigins(mainCatalog, extensionsToAdd);
        }
        catch (QuarkusCommandException e2) {
            StringBuilder buf = new StringBuilder();
            buf.append(MessageIcons.ERROR_ICON).append(' ').append(e2.getLocalizedMessage());
            invocation.log().info(buf.toString());
            return QuarkusCommandOutcome.failure();
        }
        ArrayList<ArtifactCoords> platformBoms = new ArrayList<ArtifactCoords>(Math.max(extensionOrigins.size(), 1));
        if (extensionOrigins.size() > 0) {
            extensionsToAdd = this.computeRequiredExtensions(JsonCatalogMerger.merge(extensionOrigins), extensionsQuery, invocation.log());
            boolean sawFirstPlatform = false;
            for (ExtensionCatalog c : extensionOrigins) {
                if (!c.isPlatform()) continue;
                if (c.getBom().getArtifactId().equals("quarkus-bom") || !sawFirstPlatform) {
                    mainCatalog = c;
                    sawFirstPlatform = true;
                }
                platformBoms.add(c.getBom());
            }
        } else {
            platformBoms.add(mainCatalog.getBom());
        }
        ArrayList<ArtifactCoords> extensionCoords = new ArrayList<ArtifactCoords>(extensionsToAdd.size());
        for (Extension e3 : extensionsToAdd) {
            ArtifactCoords coords = e3.getArtifact();
            for (ExtensionOrigin origin : e3.getOrigins()) {
                if (!origin.isPlatform() || origin.getBom() == null || !platformBoms.contains(origin.getBom())) continue;
                coords = Extensions.stripVersion(coords);
                break;
            }
            extensionCoords.add(coords);
        }
        invocation.setValue("bom_groupId", mainCatalog.getBom().getGroupId());
        invocation.setValue("bom_artifactId", mainCatalog.getBom().getArtifactId());
        invocation.setValue("bom_version", mainCatalog.getBom().getVersion());
        invocation.setValue("quarkus_version", mainCatalog.getQuarkusCoreVersion());
        Properties quarkusProps = ToolsUtils.readQuarkusProperties(mainCatalog);
        quarkusProps.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
            String name = k.toString().replace('-', '_');
            if (!invocation.hasValue(name)) {
                invocation.setValue(name, v.toString());
            }
        }));
        try {
            HashMap platformData = new HashMap();
            if (mainCatalog.getMetadata().get("maven") != null) {
                platformData.put("maven", mainCatalog.getMetadata().get("maven"));
            }
            if (mainCatalog.getMetadata().get("gradle") != null) {
                platformData.put("gradle", mainCatalog.getMetadata().get("gradle"));
            }
            QuarkusCodestartProjectInput input = QuarkusCodestartProjectInput.builder().addPlatforms(platformBoms).addExtensions(extensionCoords).buildTool(invocation.getQuarkusProject().getBuildTool()).example((String)invocation.getValue("quarkus.create-project.example")).noCode(invocation.getValue("quarkus.create-project.no-code", false)).addCodestarts((Collection)invocation.getValue("quarkus.create-project.extra-codestarts", Collections.emptySet())).noBuildToolWrapper(invocation.getValue("quarkus.create-project.no-buildtool-wrapper", false)).noDockerfiles(invocation.getValue("quarkus.create-project.no-dockerfiles", false)).addData((Map)platformData).addData((Map)QuarkusCodestartData.LegacySupport.convertFromLegacy(invocation.getValues())).putData("app-config", invocation.getValue("app-config", Collections.emptyMap())).messageWriter(invocation.log()).build();
            invocation.log().info("-----------");
            if (!extensionsToAdd.isEmpty()) {
                invocation.log().info("selected extensions: \n" + extensionsToAdd.stream().map(e -> "- " + e.getArtifact().getGroupId() + ":" + e.getArtifact().getArtifactId() + "\n").collect(Collectors.joining()));
            }
            QuarkusCodestartCatalog catalog = QuarkusCodestartCatalog.fromExtensionsCatalog(invocation.getQuarkusProject().getExtensionsCatalog(), invocation.getQuarkusProject().getCodestartResourceLoaders());
            CodestartProjectDefinition projectDefinition = catalog.createProject(input);
            projectDefinition.generate(invocation.getQuarkusProject().getProjectDirPath());
            invocation.log().info("\n-----------\n" + MessageIcons.OK_ICON + " " + projectDefinition.getRequiredCodestart(CodestartType.PROJECT).getName() + " project has been successfully generated in:\n--> " + invocation.getQuarkusProject().getProjectDirPath().toString() + "\n-----------");
        }
        catch (IOException e4) {
            throw new QuarkusCommandException("Failed to create project: " + e4.getMessage(), e4);
        }
        return QuarkusCommandOutcome.success();
    }

    private List<Extension> computeRequiredExtensions(ExtensionCatalog catalog, Set<String> extensionsQuery, MessageWriter log) throws QuarkusCommandException {
        List<Extension> extensionsToAdd = QuarkusCommandHandlers.computeExtensionsFromQuery(catalog, extensionsQuery, log);
        if (extensionsToAdd == null) {
            throw new QuarkusCommandException("Failed to create project because of invalid extensions");
        }
        return extensionsToAdd;
    }

    private static List<ExtensionCatalog> getExtensionOrigins(ExtensionCatalog extensionCatalog, List<Extension> extensionsToAdd) throws QuarkusCommandException {
        ArrayList<ExtensionOrigins> extOrigins = new ArrayList<ExtensionOrigins>(extensionsToAdd.size());
        for (Extension e2 : extensionsToAdd) {
            CreateProjectCommandHandler.addOrigins(extOrigins, e2);
        }
        if (extOrigins.isEmpty()) {
            return Collections.emptyList();
        }
        Optional<Extension> quarkusCore = extensionCatalog.getExtensions().stream().filter(e -> e.getArtifact().getArtifactId().equals("quarkus-core")).findFirst();
        if (!quarkusCore.isPresent()) {
            throw new QuarkusCommandException("Failed to locate quarkus-core in the extension catalog");
        }
        CreateProjectCommandHandler.addOrigins(extOrigins, quarkusCore.get());
        OriginSelector os = new OriginSelector(extOrigins);
        os.calculateCompatibleCombinations();
        OriginCombination recommendedCombination = os.getRecommendedCombination();
        if (recommendedCombination == null) {
            StringBuilder buf = new StringBuilder();
            buf.append("Failed to determine a compatible Quarkus version for the requested extensions: ");
            buf.append(extensionsToAdd.get(0).getArtifact().getKey().toGacString());
            for (int i = 1; i < extensionsToAdd.size(); ++i) {
                buf.append(", ").append(extensionsToAdd.get(i).getArtifact().getKey().toGacString());
            }
            throw new QuarkusCommandException(buf.toString());
        }
        return recommendedCombination.getUniqueSortedOrigins().stream().map(o -> o.getCatalog()).collect(Collectors.toList());
    }

    private static void addOrigins(List<ExtensionOrigins> extOrigins, Extension e) {
        ExtensionOrigins.Builder eoBuilder = null;
        for (ExtensionOrigin o : e.getOrigins()) {
            ExtensionCatalog c;
            OriginPreference op;
            if (!(o instanceof ExtensionCatalog) || (op = (OriginPreference)(c = (ExtensionCatalog)o).getMetadata().get("origin-preference")) == null) continue;
            if (eoBuilder == null) {
                eoBuilder = ExtensionOrigins.builder((ArtifactKey)e.getArtifact().getKey());
            }
            eoBuilder.addOrigin(c, op);
        }
        if (eoBuilder != null) {
            extOrigins.add(eoBuilder.build());
        }
    }
}

