/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cli.commands.file;

import io.quarkus.cli.commands.file.BuildFile;
import io.quarkus.cli.commands.writer.ProjectWriter;
import io.quarkus.dependencies.Extension;
import io.quarkus.generators.BuildTool;
import io.quarkus.maven.utilities.MojoUtils;
import io.quarkus.platform.descriptor.QuarkusPlatformDescriptor;
import io.quarkus.platform.tools.ToolsUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.maven.model.Activation;
import org.apache.maven.model.ActivationProperty;
import org.apache.maven.model.Build;
import org.apache.maven.model.BuildBase;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.PluginManagement;
import org.apache.maven.model.Profile;

public class MavenBuildFile
extends BuildFile {
    private Model model;

    public MavenBuildFile(ProjectWriter writer) throws IOException {
        super(writer, BuildTool.MAVEN);
    }

    private void initModel() throws IOException {
        if (this.getWriter().exists(BuildTool.MAVEN.getDependenciesFile())) {
            byte[] content = this.getWriter().getContent(BuildTool.MAVEN.getDependenciesFile());
            this.model = MojoUtils.readPom(new ByteArrayInputStream(content));
        }
    }

    @Override
    public void close() throws IOException {
        if (this.getModel() == null) {
            return;
        }
        try (ByteArrayOutputStream pomOutputStream = new ByteArrayOutputStream();){
            MojoUtils.write(this.getModel(), pomOutputStream);
            this.write(BuildTool.MAVEN.getDependenciesFile(), pomOutputStream.toString("UTF-8"));
        }
    }

    @Override
    protected void addDependencyInBuildFile(Dependency dependency) throws IOException {
        if (this.getModel() != null) {
            this.getModel().addDependency(dependency);
        }
    }

    @Override
    protected boolean hasDependency(Extension extension) throws IOException {
        return this.getModel() != null && MojoUtils.hasDependency(this.getModel(), extension.getGroupId(), extension.getArtifactId());
    }

    @Override
    public List<Dependency> getDependencies() throws IOException {
        return this.getModel() == null ? Collections.emptyList() : this.getModel().getDependencies();
    }

    @Override
    protected boolean containsBOM(String groupId, String artifactId) throws IOException {
        if (this.getModel() == null || this.getModel().getDependencyManagement() == null) {
            return false;
        }
        List dependencies = this.getModel().getDependencyManagement().getDependencies();
        return dependencies.stream().filter(dependency -> "import".equals(dependency.getScope())).filter(dependency -> "pom".equals(dependency.getType())).anyMatch(dependency -> dependency.getArtifactId().equals(MojoUtils.TEMPLATE_PROPERTY_QUARKUS_PLATFORM_ARTIFACT_ID_VALUE) && dependency.getGroupId().equals(MojoUtils.TEMPLATE_PROPERTY_QUARKUS_PLATFORM_GROUP_ID_VALUE));
    }

    @Override
    public void completeFile(String groupId, String artifactId, String version, QuarkusPlatformDescriptor platform, Properties props) throws IOException {
        this.addQuarkusProperties(platform);
        this.addBom(platform);
        String pluginGroupId = ToolsUtils.getPluginGroupId(props);
        String pluginArtifactId = ToolsUtils.getPluginArtifactId(props);
        this.addMainPluginConfig(pluginGroupId, pluginArtifactId);
        this.addNativeProfile(pluginGroupId, pluginArtifactId);
    }

    private void addBom(QuarkusPlatformDescriptor platform) throws IOException {
        boolean hasBom = false;
        DependencyManagement dm = this.getModel().getDependencyManagement();
        if (dm == null) {
            dm = new DependencyManagement();
            this.getModel().setDependencyManagement(dm);
        } else {
            hasBom = this.containsBOM(platform.getBomGroupId(), platform.getBomArtifactId());
        }
        if (!hasBom) {
            Dependency bom = new Dependency();
            bom.setGroupId(MojoUtils.TEMPLATE_PROPERTY_QUARKUS_PLATFORM_GROUP_ID_VALUE);
            bom.setArtifactId(MojoUtils.TEMPLATE_PROPERTY_QUARKUS_PLATFORM_ARTIFACT_ID_VALUE);
            bom.setVersion(MojoUtils.TEMPLATE_PROPERTY_QUARKUS_PLATFORM_VERSION_VALUE);
            bom.setType("pom");
            bom.setScope("import");
            dm.addDependency(bom);
        }
    }

    private void addNativeProfile(String pluginGroupId, String pluginArtifactId) throws IOException {
        boolean match = this.getModel().getProfiles().stream().anyMatch(p -> p.getId().equals("native"));
        if (!match) {
            PluginExecution exec = new PluginExecution();
            exec.addGoal("native-image");
            exec.setConfiguration((Object)MojoUtils.configuration(new MojoUtils.Element("enableHttpUrlHandler", "true", new MojoUtils.Element[0])));
            Plugin plg = MojoUtils.plugin(pluginGroupId, pluginArtifactId, MojoUtils.TEMPLATE_PROPERTY_QUARKUS_PLUGIN_VERSION_VALUE);
            plg.addExecution(exec);
            BuildBase buildBase = new BuildBase();
            buildBase.addPlugin(plg);
            Profile profile = new Profile();
            profile.setId("native");
            profile.setBuild(buildBase);
            Activation activation = new Activation();
            ActivationProperty property = new ActivationProperty();
            property.setName("native");
            activation.setProperty(property);
            profile.setActivation(activation);
            this.getModel().addProfile(profile);
        }
    }

    private void addMainPluginConfig(String groupId, String artifactId) throws IOException {
        if (!this.hasPlugin(groupId, artifactId)) {
            Build build = this.createBuildSectionIfRequired();
            Plugin plugin = MojoUtils.plugin(groupId, artifactId, MojoUtils.TEMPLATE_PROPERTY_QUARKUS_PLUGIN_VERSION_VALUE);
            if (this.isParentPom()) {
                this.addPluginManagementSection(plugin);
                plugin = MojoUtils.plugin(groupId, artifactId);
            }
            PluginExecution pluginExec = new PluginExecution();
            pluginExec.addGoal("build");
            plugin.addExecution(pluginExec);
            build.getPlugins().add(plugin);
        }
    }

    private boolean hasPlugin(String groupId, String artifactId) throws IOException {
        if (this.getModel() == null) {
            return false;
        }
        List plugins = null;
        Build build = this.getModel().getBuild();
        if (build != null) {
            if (this.isParentPom()) {
                PluginManagement management = build.getPluginManagement();
                if (management != null) {
                    plugins = management.getPlugins();
                }
            } else {
                plugins = build.getPlugins();
            }
        }
        return plugins != null && build.getPlugins().stream().anyMatch(p -> p.getGroupId().equalsIgnoreCase(groupId) && p.getArtifactId().equalsIgnoreCase(artifactId));
    }

    private void addPluginManagementSection(Plugin plugin) throws IOException {
        Build build = this.getModel().getBuild();
        if (build != null && build.getPluginManagement() != null) {
            if (build.getPluginManagement().getPlugins() == null) {
                build.getPluginManagement().setPlugins(new ArrayList());
            }
            build.getPluginManagement().getPlugins().add(plugin);
        }
    }

    private Build createBuildSectionIfRequired() throws IOException {
        Build build = this.getModel().getBuild();
        if (build == null) {
            build = new Build();
            this.getModel().setBuild(build);
        }
        if (build.getPlugins() == null) {
            build.setPlugins(new ArrayList());
        }
        return build;
    }

    private void addQuarkusProperties(QuarkusPlatformDescriptor platform) throws IOException {
        Properties properties = this.getModel().getProperties();
        if (properties == null) {
            properties = new Properties();
            this.getModel().setProperties(properties);
        }
        properties.putIfAbsent("quarkus-plugin.version", ToolsUtils.getPluginVersion(ToolsUtils.readQuarkusProperties(platform)));
        properties.putIfAbsent("quarkus.platform.group-id", platform.getBomGroupId());
        properties.putIfAbsent("quarkus.platform.artifact-id", platform.getBomArtifactId());
        properties.putIfAbsent("quarkus.platform.version", platform.getBomVersion());
    }

    private boolean isParentPom() throws IOException {
        return this.getModel() != null && "pom".equals(this.getModel().getPackaging());
    }

    @Override
    public List<Dependency> getManagedDependencies() throws IOException {
        if (this.getModel() == null) {
            return Collections.emptyList();
        }
        DependencyManagement managed = this.getModel().getDependencyManagement();
        return managed != null ? managed.getDependencies() : Collections.emptyList();
    }

    @Override
    public String getProperty(String propertyName) throws IOException {
        if (this.getModel() == null) {
            return null;
        }
        return this.getModel().getProperties().getProperty(propertyName);
    }

    private Model getModel() throws IOException {
        if (this.model == null) {
            this.initModel();
        }
        return this.model;
    }
}

