/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cli.commands;

import io.quarkus.cli.commands.AddExtensions;
import io.quarkus.cli.commands.Printer;
import io.quarkus.cli.commands.QuarkusCommand;
import io.quarkus.cli.commands.QuarkusCommandException;
import io.quarkus.cli.commands.QuarkusCommandInvocation;
import io.quarkus.cli.commands.QuarkusCommandOutcome;
import io.quarkus.cli.commands.SelectionResult;
import io.quarkus.cli.commands.file.BuildFile;
import io.quarkus.dependencies.Extension;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;

public class AddExtensionsCommandHandler
implements QuarkusCommand {
    static final Printer PRINTER = new Printer();

    @Override
    public QuarkusCommandOutcome execute(QuarkusCommandInvocation invocation) throws QuarkusCommandException {
        Set extensions = invocation.getValue(AddExtensions.EXTENSIONS, Collections.emptySet());
        if (extensions.isEmpty()) {
            return (QuarkusCommandOutcome)QuarkusCommandOutcome.success().setValue(AddExtensions.OUTCOME_UPDATED, false);
        }
        boolean updated = false;
        boolean success = true;
        List registry = invocation.getPlatformDescriptor().getExtensions();
        BuildFile buildFile = invocation.getBuildFile();
        try {
            for (String query : extensions) {
                if (query.contains(":")) {
                    updated = buildFile.addExtensionAsGAV(query) || updated;
                    continue;
                }
                SelectionResult result = AddExtensionsCommandHandler.select(query, registry, false);
                if (!result.matches()) {
                    StringBuilder sb = new StringBuilder();
                    Set<Extension> candidates = result.getExtensions();
                    if (candidates.isEmpty()) {
                        PRINTER.nok(" Cannot find a dependency matching '" + query + "', maybe a typo?");
                        success = false;
                        continue;
                    }
                    sb.append("\u274c").append(" Multiple extensions matching '").append(query).append("'");
                    result.getExtensions().forEach(extension -> sb.append(System.lineSeparator()).append("     * ").append(extension.managementKey()));
                    sb.append(System.lineSeparator()).append("     Be more specific e.g using the exact name or the full GAV.");
                    PRINTER.print(sb.toString());
                    success = false;
                    continue;
                }
                for (Extension extension2 : result) {
                    updated = buildFile.addDependency(invocation.getPlatformDescriptor(), extension2) || updated;
                }
            }
        }
        catch (IOException e) {
            throw new QuarkusCommandException("Failed to add extensions", e);
        }
        if (updated) {
            try {
                buildFile.close();
            }
            catch (IOException e) {
                throw new QuarkusCommandException("Failed to update the project", e);
            }
        }
        return (QuarkusCommandOutcome)new QuarkusCommandOutcome(success).setValue(AddExtensions.OUTCOME_UPDATED, updated);
    }

    static SelectionResult select(String query, List<Extension> extensions, boolean labelLookup) {
        String q = query.trim().toLowerCase();
        Set<Extension> matchesNameOrArtifactId = extensions.stream().filter(extension -> extension.getName().equalsIgnoreCase(q) || AddExtensionsCommandHandler.matchesArtifactId(extension.getArtifactId(), q)).collect(Collectors.toSet());
        if (matchesNameOrArtifactId.size() == 1) {
            return new SelectionResult(matchesNameOrArtifactId, true);
        }
        Set<Extension> matchesShortName = (extensions = extensions.stream().filter(e -> !e.isUnlisted()).collect(Collectors.toList())).stream().filter(extension -> AddExtensionsCommandHandler.matchesShortName(extension, q)).collect(Collectors.toSet());
        if (matchesShortName.size() == 1 && matchesNameOrArtifactId.isEmpty()) {
            return new SelectionResult(matchesShortName, true);
        }
        Set<Extension> partialMatches = extensions.stream().filter(extension -> extension.getName().toLowerCase().contains(q) || extension.getArtifactId().toLowerCase().contains(q) || extension.getShortName().toLowerCase().contains(q)).collect(Collectors.toSet());
        if (partialMatches.size() == 1 && matchesNameOrArtifactId.isEmpty() && matchesShortName.isEmpty()) {
            return new SelectionResult(partialMatches, true);
        }
        List matchesLabels = labelLookup ? extensions.stream().filter(extension -> extension.labelsForMatching().contains(q)).collect(Collectors.toList()) : Collections.emptyList();
        Pattern pattern = AddExtensionsCommandHandler.toRegex(q);
        if (pattern != null) {
            Set<Extension> matchesPatterns = extensions.stream().filter(extension -> pattern.matcher(extension.getName().toLowerCase()).matches() || pattern.matcher(extension.getArtifactId().toLowerCase()).matches() || pattern.matcher(extension.getShortName().toLowerCase()).matches() || AddExtensionsCommandHandler.matchLabels(pattern, extension.getKeywords())).collect(Collectors.toSet());
            return new SelectionResult(matchesPatterns, true);
        }
        Set matchesPatterns = Collections.emptySet();
        LinkedHashSet<Extension> candidates = new LinkedHashSet<Extension>();
        candidates.addAll(matchesNameOrArtifactId);
        candidates.addAll(matchesShortName);
        candidates.addAll(partialMatches);
        candidates.addAll(matchesLabels);
        candidates.addAll(matchesPatterns);
        return new SelectionResult(candidates, false);
    }

    private static boolean matchLabels(Pattern pattern, List<String> labels) {
        boolean matches = false;
        for (String label : labels) {
            matches = matches || pattern.matcher(label.toLowerCase()).matches();
        }
        return matches;
    }

    private static Pattern toRegex(String str) {
        try {
            String wildcardToRegex = AddExtensionsCommandHandler.wildcardToRegex(str);
            if (wildcardToRegex != null && !wildcardToRegex.isEmpty()) {
                return Pattern.compile(wildcardToRegex);
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            // empty catch block
        }
        return null;
    }

    private static String wildcardToRegex(String wildcard) {
        if (wildcard == null || wildcard.isEmpty()) {
            return null;
        }
        if (!wildcard.contains("*") && !wildcard.contains("?")) {
            return null;
        }
        StringBuffer s = new StringBuffer(wildcard.length());
        s.append("^.*");
        int is = wildcard.length();
        block6: for (int i = 0; i < is; ++i) {
            char c = wildcard.charAt(i);
            switch (c) {
                case '*': {
                    s.append(".*");
                    continue block6;
                }
                case '?': {
                    s.append(".");
                    continue block6;
                }
                case '^': {
                    s.append("\\");
                    continue block6;
                }
                case '$': 
                case '(': 
                case ')': 
                case '.': 
                case '[': 
                case '\\': 
                case ']': 
                case '{': 
                case '|': 
                case '}': {
                    s.append("\\");
                    s.append(c);
                    continue block6;
                }
                default: {
                    s.append(c);
                }
            }
        }
        s.append(".*$");
        return s.toString();
    }

    private static boolean matchesShortName(Extension extension, String q) {
        return q.equalsIgnoreCase(extension.getShortName());
    }

    private static boolean matchesArtifactId(String artifactId, String q) {
        return artifactId.equalsIgnoreCase(q) || artifactId.equalsIgnoreCase("quarkus-" + q);
    }
}

