/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.maven.utilities;

import io.quarkus.bootstrap.resolver.AppModelResolverException;
import io.quarkus.bootstrap.resolver.maven.MavenArtifactResolver;
import io.quarkus.dependencies.Extension;
import io.quarkus.maven.utilities.SortedProperties;
import io.quarkus.platform.descriptor.QuarkusPlatformDescriptor;
import io.quarkus.platform.descriptor.loader.json.ArtifactResolver;
import io.quarkus.platform.tools.config.QuarkusPlatformConfig;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Scanner;
import java.util.function.Function;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;

public class MojoUtils {
    public static final String JAVA_FILE_EXTENSION = ".java";
    public static final String KOTLIN_FILE_EXTENSION = ".kt";
    public static final String SCALA_FILE_EXTENSION = ".scala";
    public static final String JAVA_EXTENSION_NAME = "java";
    public static final String KOTLIN_EXTENSION_NAME = "kotlin";
    public static final String SCALA_EXTENSION_NAME = "scala";
    public static final String TEMPLATE_PROPERTY_QUARKUS_VERSION_NAME = "quarkus.version";
    public static final String TEMPLATE_PROPERTY_QUARKUS_VERSION_VALUE = MojoUtils.toPropExpr("quarkus.version");
    public static final String TEMPLATE_PROPERTY_QUARKUS_PLATFORM_GROUP_ID_NAME = "quarkus.platform.group-id";
    public static final String TEMPLATE_PROPERTY_QUARKUS_PLATFORM_GROUP_ID_VALUE = MojoUtils.toPropExpr("quarkus.platform.group-id");
    public static final String TEMPLATE_PROPERTY_QUARKUS_PLATFORM_ARTIFACT_ID_NAME = "quarkus.platform.artifact-id";
    public static final String TEMPLATE_PROPERTY_QUARKUS_PLATFORM_ARTIFACT_ID_VALUE = MojoUtils.toPropExpr("quarkus.platform.artifact-id");
    public static final String TEMPLATE_PROPERTY_QUARKUS_PLATFORM_VERSION_NAME = "quarkus.platform.version";
    public static final String TEMPLATE_PROPERTY_QUARKUS_PLATFORM_VERSION_VALUE = MojoUtils.toPropExpr("quarkus.platform.version");
    public static final String TEMPLATE_PROPERTY_QUARKUS_PLUGIN_VERSION_NAME = "quarkus-plugin.version";
    public static final String TEMPLATE_PROPERTY_QUARKUS_PLUGIN_VERSION_VALUE = MojoUtils.toPropExpr("quarkus-plugin.version");
    private static Properties properties;
    private static QuarkusPlatformDescriptor platformDescr;

    private static String toPropExpr(String name) {
        return "${" + name + "}";
    }

    private static QuarkusPlatformDescriptor getPlatformDescriptor() {
        return platformDescr == null ? (platformDescr = QuarkusPlatformConfig.getGlobalDefault().getPlatformDescriptor()) : platformDescr;
    }

    private static Properties getProperties() {
        if (properties == null) {
            try {
                properties = (Properties)MojoUtils.getPlatformDescriptor().loadResource("quarkus.properties", is -> {
                    Properties props = new Properties();
                    props.load(is);
                    return props;
                });
            }
            catch (IOException e) {
                throw new IllegalStateException("The quarkus.properties file cannot be read", e);
            }
        }
        return properties;
    }

    private MojoUtils() {
    }

    public static Map<String, String> getAllProperties() {
        HashMap<String, String> all = new HashMap<String, String>();
        MojoUtils.getProperties().stringPropertyNames().forEach(s -> all.put((String)s, MojoUtils.getProperties().getProperty((String)s)));
        return all;
    }

    public static String getPluginArtifactId() {
        return MojoUtils.get("plugin-artifactId");
    }

    public static String getPluginGroupId() {
        return MojoUtils.get("plugin-groupId");
    }

    public static String getPluginKey() {
        return MojoUtils.getPluginGroupId() + ":" + MojoUtils.getPluginArtifactId();
    }

    public static String getPluginVersion() {
        return MojoUtils.getPlatformDescriptor().getQuarkusVersion();
    }

    public static String getBomArtifactId() {
        return MojoUtils.getPlatformDescriptor().getBomArtifactId();
    }

    public static String getBomGroupId() {
        return MojoUtils.getPlatformDescriptor().getBomGroupId();
    }

    public static String getBomVersion() {
        return MojoUtils.getPlatformDescriptor().getBomVersion();
    }

    public static String getQuarkusVersion() {
        return MojoUtils.getPlatformDescriptor().getQuarkusVersion();
    }

    public static String getProposedMavenVersion() {
        return MojoUtils.get("proposed-maven-version");
    }

    public static String getMavenWrapperVersion() {
        return MojoUtils.get("maven-wrapper-version");
    }

    public static String getGradleWrapperVersion() {
        return MojoUtils.get("gradle-wrapper-version");
    }

    public static String get(String key) {
        return MojoUtils.getProperties().getProperty(key);
    }

    public static boolean hasDependency(Model model, String groupId, String artifactId) {
        return model.getDependencies().stream().anyMatch(d -> groupId.equals(d.getGroupId()) && artifactId.equals(d.getArtifactId()));
    }

    public static Dependency parse(String dependency) {
        Dependency res = new Dependency();
        String[] segments = dependency.split(":");
        if (segments.length >= 2) {
            res.setGroupId(segments[0]);
            res.setArtifactId(segments[1]);
            if (segments.length >= 3 && !segments[2].isEmpty()) {
                res.setVersion(segments[2]);
            }
            if (segments.length >= 4) {
                res.setClassifier(segments[3]);
            }
            return res;
        }
        throw new IllegalArgumentException("Invalid dependency description '" + dependency + "'");
    }

    public static Xpp3Dom configuration(Element ... elements) {
        Xpp3Dom dom = new Xpp3Dom("configuration");
        for (Element e : elements) {
            dom.addChild(e.toDom());
        }
        return dom;
    }

    public static Plugin plugin(String groupId, String artifactId) {
        return MojoUtils.plugin(groupId, artifactId, null);
    }

    public static Plugin plugin(String groupId, String artifactId, String version) {
        return MojoUtils.plugin(groupId, artifactId, version, Collections.emptyList());
    }

    public static Plugin plugin(String groupId, String artifactId, String version, List<Dependency> dependencies) {
        Plugin plugin = new Plugin();
        plugin.setArtifactId(artifactId);
        plugin.setGroupId(groupId);
        plugin.setVersion(version);
        plugin.setDependencies(dependencies);
        return plugin;
    }

    public static Model readPom(File pom) throws IOException {
        return MojoUtils.readPom(new FileInputStream(pom));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Model readPom(InputStream resourceAsStream) throws IOException {
        try (InputStream stream = resourceAsStream;){
            Model model = new MavenXpp3Reader().read(stream);
            return model;
        }
        catch (XmlPullParserException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    public static String[] readGavFromPom(InputStream resourceAsStream) throws IOException {
        Model model = MojoUtils.readPom(resourceAsStream);
        return new String[]{model.getGroupId(), model.getArtifactId(), model.getVersion()};
    }

    public static void write(Model model, File outputFile) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(outputFile);
        MojoUtils.write(model, fileOutputStream);
    }

    public static void write(Model model, OutputStream fileOutputStream) throws IOException {
        Properties props = model.getProperties();
        if (!props.isEmpty() && !(props instanceof SortedProperties)) {
            SortedProperties sorted = new SortedProperties();
            sorted.putAll((Map<?, ?>)props);
            model.setProperties((Properties)sorted);
        }
        try (OutputStream stream = fileOutputStream;){
            new MavenXpp3Writer().write(stream, model);
        }
    }

    public static List<Extension> loadExtensions() {
        return QuarkusPlatformConfig.getGlobalDefault().getPlatformDescriptor().getExtensions();
    }

    public static String credentials(Dependency d) {
        return String.format("%s:%s", d.getGroupId(), d.getArtifactId());
    }

    public static boolean checkProjectForMavenBuildPlugin(MavenProject project) {
        for (Plugin plugin : project.getBuildPlugins()) {
            if (!plugin.getGroupId().equals("io.quarkus") || !plugin.getArtifactId().equals("quarkus-maven-plugin")) continue;
            for (PluginExecution pluginExecution : plugin.getExecutions()) {
                if (!pluginExecution.getGoals().contains("build")) continue;
                return true;
            }
        }
        return false;
    }

    public static String[] readGavFromSettingsGradle(ByteArrayInputStream buildFileInputStream, String[] gavIn) {
        String[] gavOut = Arrays.copyOf(gavIn, gavIn.length);
        try (Scanner scanner = new Scanner((InputStream)buildFileInputStream, StandardCharsets.UTF_8.name());){
            while (scanner.hasNextLine()) {
                String currentLine = scanner.nextLine();
                if (currentLine.startsWith("group")) {
                    gavOut[0] = currentLine.substring(currentLine.indexOf(39) + 1, currentLine.lastIndexOf(39));
                    continue;
                }
                if (currentLine.startsWith("rootProject.name")) {
                    gavOut[1] = currentLine.substring(currentLine.indexOf(39) + 1, currentLine.lastIndexOf(39));
                    continue;
                }
                if (!currentLine.startsWith("version")) continue;
                gavOut[2] = currentLine.substring(currentLine.indexOf(39) + 1, currentLine.lastIndexOf(39));
            }
        }
        return gavOut;
    }

    public static Path getClassOrigin(Class<?> cls) throws IOException {
        String pluginClassPath = cls.getName().replace('.', '/') + ".class";
        URL url = cls.getClassLoader().getResource(pluginClassPath);
        if (url == null) {
            throw new IOException("Failed to locate the origin of " + cls);
        }
        String classLocation = url.toExternalForm();
        classLocation = url.getProtocol().equals("jar") ? classLocation.substring(4, classLocation.length() - pluginClassPath.length() - 2) : classLocation.substring(0, classLocation.length() - pluginClassPath.length());
        return MojoUtils.urlSpecToPath(classLocation);
    }

    private static Path urlSpecToPath(String urlSpec) throws IOException {
        try {
            return Paths.get(new URL(urlSpec).toURI());
        }
        catch (Throwable e) {
            throw new IOException("Failed to create an instance of " + Path.class.getName() + " from " + urlSpec, e);
        }
    }

    public static ArtifactResolver toJsonArtifactResolver(final MavenArtifactResolver mvn) {
        return new ArtifactResolver(){

            @Override
            public <T> T process(String groupId, String artifactId, String classifier, String type, String version, Function<Path, T> processor) {
                DefaultArtifact artifact = new DefaultArtifact(groupId, artifactId, classifier, type, version);
                try {
                    return processor.apply(mvn.resolve((Artifact)artifact).getArtifact().getFile().toPath());
                }
                catch (AppModelResolverException e) {
                    throw new IllegalStateException("Failed to resolve " + artifact, e);
                }
            }

            @Override
            public List<Dependency> getManagedDependencies(String groupId, String artifactId, String classifier, String type, String version) {
                List deps;
                DefaultArtifact a = new DefaultArtifact(groupId, artifactId, classifier, type, version);
                try {
                    deps = mvn.resolveDescriptor((Artifact)a).getManagedDependencies();
                }
                catch (AppModelResolverException e) {
                    throw new IllegalStateException("Failed to resolve descriptor for " + a, e);
                }
                ArrayList<Dependency> result = new ArrayList<Dependency>(deps.size());
                for (org.eclipse.aether.graph.Dependency dep : deps) {
                    a = dep.getArtifact();
                    Dependency d = new Dependency();
                    d.setGroupId(a.getGroupId());
                    d.setArtifactId(a.getArtifactId());
                    d.setClassifier(a.getClassifier());
                    d.setType(a.getExtension());
                    d.setVersion(a.getVersion());
                    d.setOptional(dep.isOptional());
                    d.setScope(dep.getScope());
                    result.add(d);
                }
                return result;
            }
        };
    }

    public static class Attribute {
        private final String name;
        private final String value;

        public Attribute(String name, String value) {
            this.name = name;
            this.value = value;
        }
    }

    public static class Attributes {
        private List<Attribute> attributes;

        public Attributes(Attribute ... attributes) {
            this.attributes = Arrays.asList(attributes);
        }
    }

    public static class Element {
        private final Element[] children;
        private final String name;
        private final String text;
        private final Attributes attributes;

        public Element(String name, Element ... children) {
            this(name, null, new Attributes(new Attribute[0]), children);
        }

        public Element(String name, Attributes attributes, Element ... children) {
            this(name, null, attributes, children);
        }

        public Element(String name, String text, Element ... children) {
            this.name = name;
            this.text = text;
            this.children = children;
            this.attributes = new Attributes(new Attribute[0]);
        }

        public Element(String name, String text, Attributes attributes, Element ... children) {
            this.name = name;
            this.text = text;
            this.children = children;
            this.attributes = attributes;
        }

        public Xpp3Dom toDom() {
            Xpp3Dom dom = new Xpp3Dom(this.name);
            if (this.text != null) {
                dom.setValue(this.text);
            }
            for (Element e : this.children) {
                dom.addChild(e.toDom());
            }
            for (Attribute attribute : this.attributes.attributes) {
                dom.setAttribute(attribute.name, attribute.value);
            }
            return dom;
        }
    }
}

