/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cli.commands.file;

import io.quarkus.cli.commands.file.BuildFile;
import io.quarkus.cli.commands.writer.ProjectWriter;
import io.quarkus.dependencies.Extension;
import io.quarkus.generators.BuildTool;
import io.quarkus.maven.utilities.MojoUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.maven.model.Activation;
import org.apache.maven.model.ActivationProperty;
import org.apache.maven.model.Build;
import org.apache.maven.model.BuildBase;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.PluginManagement;
import org.apache.maven.model.Profile;

public class MavenBuildFile
extends BuildFile {
    private Model model;

    public MavenBuildFile(ProjectWriter writer) throws IOException {
        super(writer, BuildTool.MAVEN);
    }

    private void initModel() throws IOException {
        if (this.getWriter().exists(BuildTool.MAVEN.getDependenciesFile())) {
            byte[] content = this.getWriter().getContent(BuildTool.MAVEN.getDependenciesFile());
            this.model = MojoUtils.readPom(new ByteArrayInputStream(content));
        }
    }

    @Override
    public void close() throws IOException {
        ByteArrayOutputStream pomOutputStream = new ByteArrayOutputStream();
        MojoUtils.write(this.getModel(), pomOutputStream);
        this.write(BuildTool.MAVEN.getDependenciesFile(), pomOutputStream.toString("UTF-8"));
    }

    @Override
    protected void addDependencyInBuildFile(Dependency dependency) throws IOException {
        this.getModel().addDependency(dependency);
    }

    @Override
    protected boolean hasDependency(Extension extension) throws IOException {
        return MojoUtils.hasDependency(this.getModel(), extension.getGroupId(), extension.getArtifactId());
    }

    @Override
    public List<Dependency> getDependencies() throws IOException {
        return this.getModel().getDependencies();
    }

    @Override
    protected boolean containsBOM() throws IOException {
        if (this.getModel().getDependencyManagement() == null) {
            return false;
        }
        List dependencies = this.getModel().getDependencyManagement().getDependencies();
        return dependencies.stream().filter(dependency -> "import".equalsIgnoreCase(dependency.getScope())).filter(dependency -> "pom".equalsIgnoreCase(dependency.getType())).anyMatch(dependency -> dependency.getArtifactId().equalsIgnoreCase(MojoUtils.getBomArtifactId()));
    }

    @Override
    public void completeFile(String groupId, String artifactId, String version) throws IOException {
        this.addVersionProperty();
        this.addBom();
        this.addMainPluginConfig();
        this.addNativeProfile();
    }

    private void addBom() throws IOException {
        boolean hasBom = false;
        DependencyManagement dm = this.getModel().getDependencyManagement();
        if (dm == null) {
            dm = new DependencyManagement();
            this.getModel().setDependencyManagement(dm);
        } else {
            hasBom = dm.getDependencies().stream().anyMatch(d -> d.getGroupId().equals(MojoUtils.getPluginGroupId()) && d.getArtifactId().equals(MojoUtils.getBomArtifactId()));
        }
        if (!hasBom) {
            Dependency bom = new Dependency();
            bom.setGroupId(MojoUtils.getPluginGroupId());
            bom.setArtifactId(MojoUtils.getBomArtifactId());
            bom.setVersion("${quarkus.version}");
            bom.setType("pom");
            bom.setScope("import");
            dm.addDependency(bom);
        }
    }

    private void addNativeProfile() throws IOException {
        boolean match = this.getModel().getProfiles().stream().anyMatch(p -> p.getId().equals("native"));
        if (!match) {
            PluginExecution exec = new PluginExecution();
            exec.addGoal("native-image");
            exec.setConfiguration((Object)MojoUtils.configuration(new MojoUtils.Element("enableHttpUrlHandler", "true", new MojoUtils.Element[0])));
            Plugin plg = MojoUtils.plugin(MojoUtils.getPluginGroupId(), MojoUtils.getPluginArtifactId(), "${quarkus.version}");
            plg.addExecution(exec);
            BuildBase buildBase = new BuildBase();
            buildBase.addPlugin(plg);
            Profile profile = new Profile();
            profile.setId("native");
            profile.setBuild(buildBase);
            Activation activation = new Activation();
            ActivationProperty property = new ActivationProperty();
            property.setName("native");
            activation.setProperty(property);
            profile.setActivation(activation);
            this.getModel().addProfile(profile);
        }
    }

    private void addMainPluginConfig() throws IOException {
        if (!this.hasPlugin()) {
            Build build = this.createBuildSectionIfRequired();
            Plugin plugin = MojoUtils.plugin(MojoUtils.getPluginGroupId(), MojoUtils.getPluginArtifactId(), "${quarkus.version}");
            if (this.isParentPom()) {
                this.addPluginManagementSection(plugin);
                plugin = MojoUtils.plugin(MojoUtils.getPluginGroupId(), MojoUtils.getPluginArtifactId());
            }
            PluginExecution pluginExec = new PluginExecution();
            pluginExec.addGoal("build");
            plugin.addExecution(pluginExec);
            build.getPlugins().add(plugin);
        }
    }

    private boolean hasPlugin() throws IOException {
        List plugins = null;
        Build build = this.getModel().getBuild();
        if (build != null) {
            if (this.isParentPom()) {
                PluginManagement management = build.getPluginManagement();
                if (management != null) {
                    plugins = management.getPlugins();
                }
            } else {
                plugins = build.getPlugins();
            }
        }
        return plugins != null && build.getPlugins().stream().anyMatch(p -> p.getGroupId().equalsIgnoreCase(MojoUtils.getPluginGroupId()) && p.getArtifactId().equalsIgnoreCase(MojoUtils.getPluginArtifactId()));
    }

    private void addPluginManagementSection(Plugin plugin) throws IOException {
        if (this.getModel().getBuild() != null && this.getModel().getBuild().getPluginManagement() != null) {
            if (this.getModel().getBuild().getPluginManagement().getPlugins() == null) {
                this.getModel().getBuild().getPluginManagement().setPlugins(new ArrayList());
            }
            this.getModel().getBuild().getPluginManagement().getPlugins().add(plugin);
        }
    }

    private Build createBuildSectionIfRequired() throws IOException {
        Build build = this.getModel().getBuild();
        if (build == null) {
            build = new Build();
            this.getModel().setBuild(build);
        }
        if (build.getPlugins() == null) {
            build.setPlugins(new ArrayList());
        }
        return build;
    }

    private void addVersionProperty() throws IOException {
        Properties properties = this.getModel().getProperties();
        if (properties == null) {
            properties = new Properties();
            this.getModel().setProperties(properties);
        }
        properties.putIfAbsent("quarkus.version", MojoUtils.getPluginVersion());
    }

    private boolean isParentPom() throws IOException {
        return "pom".equals(this.getModel().getPackaging());
    }

    @Override
    protected List<Dependency> getManagedDependencies() throws IOException {
        DependencyManagement managed = this.getModel().getDependencyManagement();
        return managed != null ? managed.getDependencies() : Collections.emptyList();
    }

    @Override
    public String getProperty(String propertyName) throws IOException {
        return this.getModel().getProperties().getProperty(propertyName);
    }

    private Model getModel() throws IOException {
        if (this.model == null) {
            this.initModel();
        }
        return this.model;
    }
}

