/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.codestarts.core;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.quarkus.devtools.codestarts.CodestartType;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public final class CodestartSpec {
    private final String name;
    private final boolean isPreselected;
    private final String ref;
    private final CodestartType type;
    private final boolean isFallback;
    private final Set<String> tags;
    private final Map<String, String> outputStrategy;
    private final Map<String, LanguageSpec> languagesSpec;

    @JsonCreator
    public CodestartSpec(@JsonProperty(value="name", required=true) String name, @JsonProperty(value="ref") String ref, @JsonProperty(value="type") CodestartType type, @JsonProperty(value="fallback") boolean isFallback, @JsonProperty(value="preselected") boolean isPreselected, @JsonProperty(value="tags") Set<String> tags, @JsonProperty(value="output-strategy") Map<String, String> outputStrategy, @JsonProperty(value="language") Map<String, LanguageSpec> languagesSpec) {
        this.name = Objects.requireNonNull(name, "name is required");
        this.tags = tags != null ? tags : Collections.emptySet();
        this.ref = ref != null ? ref : name;
        this.type = type != null ? type : CodestartType.CODE;
        this.isFallback = isFallback;
        this.isPreselected = isPreselected;
        this.outputStrategy = outputStrategy != null ? outputStrategy : Collections.emptyMap();
        this.languagesSpec = languagesSpec != null ? languagesSpec : Collections.emptyMap();
    }

    public String getName() {
        return this.name;
    }

    public String getRef() {
        return this.ref;
    }

    public Set<String> getTags() {
        return this.tags;
    }

    public CodestartType getType() {
        return this.type;
    }

    public boolean isFallback() {
        return this.isFallback;
    }

    public boolean isPreselected() {
        return this.isPreselected;
    }

    public Map<String, String> getOutputStrategy() {
        return this.outputStrategy;
    }

    public Map<String, LanguageSpec> getLanguagesSpec() {
        return this.languagesSpec;
    }

    public static class CodestartDep
    extends HashMap<String, String> {
        private static final String GROUP_ID = "groupId";
        private static final String ARTIFACT_ID = "artifactId";
        private static final String VERSION = "version";

        public CodestartDep() {
        }

        @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
        public CodestartDep(String expression) {
            String[] split = expression.split(":");
            if (split.length < 2 || split.length > 3) {
                throw new IllegalArgumentException("Invalid CodestartDep expression: " + expression);
            }
            this.put(GROUP_ID, split[0]);
            this.put(ARTIFACT_ID, split[1]);
            if (split.length == 3) {
                this.put(VERSION, split[2]);
            }
        }

        public String getGroupId() {
            return (String)this.get(GROUP_ID);
        }

        public String getArtifactId() {
            return (String)this.get(ARTIFACT_ID);
        }

        public String getVersion() {
            return (String)this.get(VERSION);
        }

        @Override
        public String toString() {
            String version = Optional.ofNullable(this.getVersion()).map(v -> ":" + v).orElse("");
            return this.getGroupId() + ":" + this.getArtifactId() + version;
        }

        @Override
        public int hashCode() {
            return this.getGroupId().hashCode() + this.getArtifactId().hashCode();
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof Map) {
                Map map = (Map)o;
                return Objects.equals(this.getGroupId(), map.get(GROUP_ID)) && Objects.equals(this.getArtifactId(), map.get(ARTIFACT_ID));
            }
            return false;
        }
    }

    public static final class LanguageSpec {
        private final Map<String, Object> data;
        private final Map<String, Object> sharedData;
        private final List<CodestartDep> dependencies;
        private final List<CodestartDep> testDependencies;

        public LanguageSpec() {
            this(null, null, null, null);
        }

        @JsonCreator
        public LanguageSpec(@JsonProperty(value="data") Map<String, Object> data, @JsonProperty(value="shared-data") Map<String, Object> sharedData, @JsonProperty(value="dependencies") List<CodestartDep> dependencies, @JsonProperty(value="test-dependencies") List<CodestartDep> testDependencies) {
            this.data = data != null ? data : Collections.emptyMap();
            this.sharedData = sharedData != null ? sharedData : Collections.emptyMap();
            this.dependencies = dependencies != null ? dependencies : Collections.emptyList();
            this.testDependencies = testDependencies != null ? testDependencies : Collections.emptyList();
        }

        public Map<String, Object> getData() {
            return this.data;
        }

        public Map<String, Object> getSharedData() {
            return this.sharedData;
        }

        public List<CodestartDep> getDependencies() {
            return this.dependencies;
        }

        public List<CodestartDep> getTestDependencies() {
            return this.testDependencies;
        }
    }
}

