/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.dev;

import io.quarkus.runtime.util.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class CompilerFlags {
    private final Set<String> defaultFlags;
    private final List<String> userFlags;
    private final String sourceJavaVersion;
    private final String targetJavaVersion;

    public CompilerFlags(Set<String> defaultFlags, Collection<String> userFlags, String sourceJavaVersion, String targetJavaVersion) {
        this.defaultFlags = defaultFlags == null ? new HashSet<String>() : new HashSet<String>(defaultFlags);
        this.userFlags = userFlags == null ? new ArrayList<String>() : new ArrayList<String>(userFlags);
        this.sourceJavaVersion = sourceJavaVersion;
        this.targetJavaVersion = targetJavaVersion;
    }

    public List<String> toList() {
        ArrayList<String> flagList = new ArrayList<String>();
        HashSet<String> effectiveDefaultFlags = new HashSet<String>(this.defaultFlags);
        effectiveDefaultFlags.removeAll(this.userFlags);
        flagList.addAll(effectiveDefaultFlags);
        if (this.sourceJavaVersion != null) {
            flagList.add("-source");
            flagList.add(this.sourceJavaVersion);
        }
        if (this.targetJavaVersion != null) {
            flagList.add("-target");
            flagList.add(this.targetJavaVersion);
        }
        flagList.addAll(this.userFlags);
        return flagList;
    }

    public int hashCode() {
        return this.toList().hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof CompilerFlags && this.toList().equals(((CompilerFlags)obj).toList());
    }

    public String toString() {
        return "CompilerFlags@{" + StringUtil.join((String)", ", this.toList().iterator()) + "}";
    }
}

